/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.storage;

import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.properties.IPropertyContainer;
import betterquesting.api.properties.IPropertyType;
import betterquesting.api.utils.JsonHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class PropertyContainer
implements IPropertyContainer {
    private JsonObject jInfo = new JsonObject();

    @Override
    public <T> T getProperty(IPropertyType<T> prop) {
        if (prop == null) {
            return null;
        }
        return this.getProperty(prop, prop.getDefault());
    }

    @Override
    public <T> T getProperty(IPropertyType<T> prop, T def) {
        if (prop == null) {
            return null;
        }
        JsonElement jProp = this.getJsonDomain(prop.getKey()).get(prop.getKey().func_110623_a());
        if (jProp == null) {
            return def;
        }
        return prop.readValue(jProp);
    }

    @Override
    public boolean hasProperty(IPropertyType<?> prop) {
        if (prop == null) {
            return false;
        }
        return this.getJsonDomain(prop.getKey()).has(prop.getKey().func_110623_a());
    }

    @Override
    public <T> void setProperty(IPropertyType<T> prop, T value) {
        if (prop == null || value == null) {
            return;
        }
        JsonObject dom = this.getJsonDomain(prop.getKey());
        dom.add(prop.getKey().func_110623_a(), prop.writeValue(value));
        this.jInfo.add(prop.getKey().func_110624_b(), (JsonElement)dom);
    }

    @Override
    public JsonObject writeToJson(JsonObject json, EnumSaveType saveType) {
        for (Map.Entry entry : this.jInfo.entrySet()) {
            json.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return json;
    }

    @Override
    public void readFromJson(JsonObject json, EnumSaveType saveType) {
        this.jInfo = new JsonObject();
        for (Map.Entry entry : json.entrySet()) {
            this.jInfo.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    private JsonObject getJsonDomain(ResourceLocation res) {
        return JsonHelper.GetObject(this.jInfo, res.func_110624_b());
    }
}

