/*
 * Decompiled with CFR 0.152.
 */
package cofh.vanillatools;

import cofh.core.item.tool.ItemBowCore;
import cofh.core.item.tool.ItemFishingRodCore;
import cofh.core.item.tool.ItemHammerCore;
import cofh.core.item.tool.ItemShearsCore;
import cofh.core.item.tool.ItemShieldCore;
import cofh.core.item.tool.ItemSickleCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.vanillatools.VanillaTools;
import java.util.Locale;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Equipment {
    public static final Equipment INSTANCE = new Equipment();

    private Equipment() {
    }

    public static void preInit() {
        for (ToolSetVanilla e : ToolSetVanilla.values()) {
            e.preInit();
            VanillaTools.proxy.addIModelRegister(e);
        }
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        for (ToolSetVanilla e : ToolSetVanilla.values()) {
            e.initialize();
        }
    }

    public static enum ToolSetVanilla implements IModelRegister
    {
        WOOD("wood", Item.ToolMaterial.WOOD, "plankWood"){

            @Override
            protected void create() {
                this.itemBow = Items.field_151031_f;
                this.itemFishingRod = Items.field_151112_aM;
                this.itemShears = new ItemShearsCore(this.material);
                this.itemSickle = new ItemSickleCore(this.material);
                this.itemHammer = new ItemHammerCore(this.material);
                this.itemShield = Items.field_185159_cQ;
            }
        }
        ,
        STONE("stone", Item.ToolMaterial.STONE, "cobblestone"),
        IRON("iron", Item.ToolMaterial.IRON, "ingotIron"){

            @Override
            protected void create() {
                this.itemBow = new ItemBowCore(this.material);
                this.itemFishingRod = new ItemFishingRodCore(this.material);
                this.itemShears = Items.field_151097_aZ;
                this.itemSickle = new ItemSickleCore(this.material);
                this.itemHammer = new ItemHammerCore(this.material);
                this.itemShield = new ItemShieldCore(this.material);
            }
        }
        ,
        DIAMOND("diamond", Item.ToolMaterial.DIAMOND, "gemDiamond"),
        GOLD("gold", Item.ToolMaterial.GOLD, "ingotGold");

        public final String name;
        public final String ingot;
        public final Item.ToolMaterial material;
        private float arrowSpeed = 0.0f;
        private float arrowDamage = 0.0f;
        private float zoomMultiplier = 0.15f;
        private int luckModifier = 0;
        private int speedModifier = 0;
        public ItemBow itemBow;
        public ItemFishingRod itemFishingRod;
        public ItemShears itemShears;
        public ItemSickleCore itemSickle;
        public ItemHammerCore itemHammer;
        public Item itemShield;
        public ItemStack toolBow;
        public ItemStack toolFishingRod;
        public ItemStack toolShears;
        public ItemStack toolSickle;
        public ItemStack toolHammer;
        public ItemStack toolShield;
        public boolean[] enable = new boolean[6];

        private ToolSetVanilla(String name, Item.ToolMaterial materialIn, String ingot) {
            this.name = name.toLowerCase(Locale.US);
            this.ingot = ingot;
            this.material = materialIn;
            this.arrowDamage = this.material.func_78000_c() / 4.0f;
            this.arrowSpeed = this.material.func_77998_b() / 20.0f;
            this.zoomMultiplier = MathHelper.clamp((float)(this.material.func_77998_b() / 30.0f), (float)this.zoomMultiplier, (float)(this.zoomMultiplier * 2.0f));
            this.luckModifier = this.material.func_77996_d() / 2;
            this.speedModifier = (int)this.material.func_77998_b() / 3;
        }

        protected void create() {
            this.itemBow = new ItemBowCore(this.material);
            this.itemFishingRod = new ItemFishingRodCore(this.material);
            this.itemShears = new ItemShearsCore(this.material);
            this.itemSickle = new ItemSickleCore(this.material);
            this.itemHammer = new ItemHammerCore(this.material);
            this.itemShield = new ItemShieldCore(this.material);
        }

        protected boolean enableDefault(ToolSetVanilla type) {
            return type != WOOD && type != STONE;
        }

        protected void preInit() {
            String TOOL = "vanillaplus.tool." + this.name;
            String category = "Equipment.Tool." + StringHelper.titleCase((String)this.name);
            if (this != WOOD) {
                this.enable[0] = VanillaTools.CONFIG.getConfiguration().get(category, "Bow", this.enableDefault(this)).getBoolean(this.enableDefault(this));
                this.enable[1] = VanillaTools.CONFIG.getConfiguration().get(category, "FishingRod", this.enableDefault(this)).getBoolean(this.enableDefault(this));
            }
            if (this != IRON) {
                this.enable[2] = VanillaTools.CONFIG.getConfiguration().get(category, "Shears", this.enableDefault(this)).getBoolean(this.enableDefault(this));
            }
            this.enable[3] = VanillaTools.CONFIG.getConfiguration().get(category, "Sickle", this.enableDefault(this)).getBoolean(this.enableDefault(this));
            this.enable[4] = VanillaTools.CONFIG.getConfiguration().get(category, "Hammer", this.enableDefault(this)).getBoolean(this.enableDefault(this));
            if (this != WOOD) {
                this.enable[5] = VanillaTools.CONFIG.getConfiguration().get(category, "Shield", this.enableDefault(this)).getBoolean(this.enableDefault(this));
            }
            this.create();
            if (this.itemBow instanceof ItemBowCore) {
                ItemBowCore itemBow = (ItemBowCore)this.itemBow;
                itemBow.setRepairIngot(this.ingot).func_77655_b(TOOL + "Bow").func_77637_a(CreativeTabs.field_78037_j);
                itemBow.setArrowDamage(this.arrowDamage).setArrowSpeed(this.arrowSpeed).setZoomMultiplier(this.zoomMultiplier);
                itemBow.setShowInCreative(this.enable[0]);
                itemBow.setRegistryName("tool.bow_" + this.name);
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBow);
            }
            if (this.itemFishingRod instanceof ItemFishingRodCore) {
                ItemFishingRodCore itemFishingRod = (ItemFishingRodCore)this.itemFishingRod;
                itemFishingRod.setRepairIngot(this.ingot).func_77655_b(TOOL + "FishingRod").func_77637_a(CreativeTabs.field_78040_i);
                itemFishingRod.setLuckModifier(this.luckModifier).setSpeedModifier(this.speedModifier);
                itemFishingRod.setShowInCreative(this.enable[1]);
                itemFishingRod.setRegistryName("tool.fishing_rod_" + this.name);
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemFishingRod);
            }
            if (this.itemShears instanceof ItemShearsCore) {
                ItemShearsCore itemShears = (ItemShearsCore)this.itemShears;
                itemShears.setRepairIngot(this.ingot).func_77655_b(TOOL + "Shears").func_77637_a(CreativeTabs.field_78040_i);
                itemShears.setShowInCreative(this.enable[2]);
                itemShears.setRegistryName("tool.shears_" + this.name);
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemShears);
            }
            this.itemSickle.setRepairIngot(this.ingot).func_77655_b(TOOL + "Sickle").func_77637_a(CreativeTabs.field_78040_i);
            this.itemSickle.setShowInCreative(this.enable[3]);
            this.itemSickle.setRegistryName("tool.sickle_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemSickle);
            this.itemHammer.setRepairIngot(this.ingot).func_77655_b(TOOL + "Hammer").func_77637_a(CreativeTabs.field_78040_i);
            this.itemHammer.setShowInCreative(this.enable[4]);
            this.itemHammer.setRegistryName("tool.hammer_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemHammer);
            if (this.itemShield instanceof ItemShieldCore) {
                ((ItemShieldCore)this.itemShield).setRepairIngot(this.ingot).func_77655_b(TOOL + "Shield").func_77637_a(CreativeTabs.field_78037_j);
                ((ItemShieldCore)this.itemShield).setShowInCreative(this.enable[5]);
                this.itemShield.setRegistryName("tool.shield_" + this.name);
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemShield);
            }
            this.toolBow = new ItemStack((Item)this.itemBow);
            this.toolFishingRod = new ItemStack((Item)this.itemFishingRod);
            this.toolShears = new ItemStack((Item)this.itemShears);
            this.toolSickle = new ItemStack((Item)this.itemSickle);
            this.toolHammer = new ItemStack((Item)this.itemHammer);
            this.toolShield = new ItemStack(this.itemShield);
        }

        protected void initialize() {
            if (this.enable[0]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolBow, (Object[])new Object[]{" I#", "S #", " I#", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood", Character.valueOf('#'), Items.field_151007_F});
            }
            if (this.enable[1]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolFishingRod, (Object[])new Object[]{"  I", " I#", "S #", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood", Character.valueOf('#'), Items.field_151007_F});
            }
            if (this.enable[2]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolShears, (Object[])new Object[]{" I", "I ", Character.valueOf('I'), this.ingot});
            }
            if (this.enable[3]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolSickle, (Object[])new Object[]{" I ", "  I", "SI ", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"});
            }
            if (this.enable[4]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolHammer, (Object[])new Object[]{"III", "ISI", " S ", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"});
            }
            if (this.enable[5]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolShield, (Object[])new Object[]{"III", "ISI", " I ", Character.valueOf('I'), this.ingot, Character.valueOf('S'), Items.field_185159_cQ});
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModel(Item item, String stackName) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("vanillatools:tool", "type=" + stackName));
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModelOverride(Item item, String stackName) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("vanillatools:tool/" + stackName, "inventory"));
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModels() {
            if (this.itemBow instanceof ItemBowCore) {
                this.registerModelOverride((Item)this.itemBow, "bow_" + this.name);
            }
            if (this.itemFishingRod instanceof ItemFishingRodCore) {
                this.registerModelOverride((Item)this.itemFishingRod, "fishing_rod_" + this.name);
            }
            if (this.itemShears instanceof ItemShearsCore) {
                this.registerModel((Item)this.itemShears, "shears_" + this.name);
            }
            this.registerModel((Item)this.itemSickle, "sickle_" + this.name);
            this.registerModel((Item)this.itemHammer, "hammer_" + this.name);
            if (this.itemShield instanceof ItemShieldCore) {
                this.registerModelOverride(this.itemShield, "shield_" + this.name);
            }
        }
    }
}

