/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseContainer;
import gcewing.architecture.BaseMod;
import gcewing.architecture.BaseModClient;
import gcewing.architecture.BaseUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class BaseGui {
    public static final int defaultTextColor = 0x404040;

    static boolean isFocused(IWidget iWidget) {
        if (iWidget == null) {
            return false;
        }
        if (iWidget instanceof Root) {
            return true;
        }
        IWidgetContainer iWidgetContainer = iWidget.parent();
        return iWidgetContainer != null && iWidgetContainer.getFocus() == iWidget && BaseGui.isFocused(iWidgetContainer);
    }

    static void tellFocusChanged(IWidget iWidget, boolean bl) {
        if (iWidget != null) {
            iWidget.focusChanged(bl);
            if (iWidget instanceof IWidgetContainer) {
                BaseGui.tellFocusChanged(((IWidgetContainer)iWidget).getFocus(), bl);
            }
        }
    }

    static String name(Object object) {
        if (object != null) {
            return object.getClass().getSimpleName();
        }
        return "null";
    }

    public static Ref ref(Object object, String string) {
        return new FieldRef(object, string);
    }

    public static Ref ref(Object object, String string, String string2) {
        return new PropertyRef(object, string, string2);
    }

    public static Action action(Object object, String string) {
        return new MethodAction(object, string);
    }

    public static class GState {
        public GState previous;
        public double uscale;
        public double vscale;
        public float red;
        public float green;
        public float blue;
        public int textColor;
        public boolean textShadow;
        public ResourceLocation texture;

        public GState() {
            this.uscale = 1.0;
            this.vscale = 1.0;
            this.blue = 1.0f;
            this.green = 1.0f;
            this.red = 1.0f;
            this.textColor = 0x404040;
            this.textShadow = false;
        }

        public GState(GState gState) {
            this.previous = gState;
            this.uscale = gState.uscale;
            this.vscale = gState.vscale;
            this.red = gState.red;
            this.green = gState.green;
            this.blue = gState.blue;
            this.textColor = gState.textColor;
            this.textShadow = gState.textShadow;
            this.texture = gState.texture;
        }
    }

    public static class MethodAction
    implements Action {
        Object target;
        Method method;

        public MethodAction(Object object, String string) {
            try {
                this.target = object;
                this.method = object.getClass().getMethod(string, new Class[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void perform() {
            try {
                this.method.invoke(this.target, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static interface Action {
        public void perform();
    }

    public static class PropertyRef
    implements Ref {
        public Object target;
        public Method getter;
        public Method setter;

        public PropertyRef(Object object, String string, String string2) {
            this.target = object;
            try {
                Class<?> clazz = object.getClass();
                this.getter = clazz.getMethod(string, new Class[0]);
                this.setter = clazz.getMethod(string2, this.getter.getReturnType());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public Object get() {
            try {
                return this.getter.invoke(this.target, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void set(Object object) {
            try {
                this.setter.invoke(this.target, object);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static class FieldRef
    implements Ref {
        public Object target;
        public Field field;

        public FieldRef(Object object, String string) {
            try {
                this.target = object;
                this.field = object.getClass().getField(string);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public Object get() {
            try {
                return this.field.get(this.target);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void set(Object object) {
            try {
                this.field.set(this.target, object);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static interface Ref {
        public Object get();

        public void set(Object var1);
    }

    public static class Root
    extends Group {
        public Screen screen;
        public List<IWidget> popupStack;

        public Root(Screen screen) {
            this.screen = screen;
            this.popupStack = new ArrayList<IWidget>();
        }

        @Override
        public int width() {
            return this.screen.getWidth();
        }

        @Override
        public int height() {
            return this.screen.getHeight();
        }

        @Override
        public IWidget dispatchMousePress(int n, int n2, int n3) {
            IWidget iWidget = this.topPopup();
            if (iWidget == null) {
                iWidget = super.dispatchMousePress(n, n2, n3);
            }
            return iWidget;
        }

        @Override
        public void addPopup(int n, int n2, IWidget iWidget) {
            this.add(n, n2, iWidget);
            this.popupStack.add(iWidget);
            this.screen.focusOn(iWidget);
        }

        @Override
        public void remove(IWidget iWidget) {
            super.remove(iWidget);
            this.popupStack.remove(iWidget);
            this.focusTopPopup();
        }

        public IWidget topPopup() {
            int n = this.popupStack.size();
            if (n > 0) {
                return this.popupStack.get(n - 1);
            }
            return null;
        }

        void focusTopPopup() {
            IWidget iWidget = this.topPopup();
            if (iWidget != null) {
                this.screen.focusOn(iWidget);
            }
        }
    }

    public static class Group
    extends Widget
    implements IWidgetContainer {
        protected List<IWidget> widgets = new ArrayList<IWidget>();
        protected IWidget focus;

        @Override
        public IWidget getFocus() {
            return this.focus;
        }

        @Override
        public void setFocus(IWidget iWidget) {
            this.focus = iWidget;
        }

        public void add(int n, int n2, IWidget iWidget) {
            iWidget.setLeft(n);
            iWidget.setTop(n2);
            iWidget.setParent(this);
            this.widgets.add(iWidget);
        }

        public void remove(IWidget iWidget) {
            this.widgets.remove(iWidget);
            if (this.getFocus() == iWidget) {
                if (BaseGui.isFocused(this)) {
                    BaseGui.tellFocusChanged(iWidget, false);
                }
                this.setFocus(null);
            }
        }

        @Override
        public void draw(Screen screen, int n, int n2) {
            super.draw(screen, n, n2);
            for (IWidget iWidget : this.widgets) {
                int n3 = iWidget.left();
                int n4 = iWidget.top();
                GL11.glPushMatrix();
                GL11.glTranslated((double)n3, (double)n4, (double)0.0);
                iWidget.draw(screen, n - n3, n2 - n4);
                GL11.glPopMatrix();
            }
        }

        @Override
        public IWidget dispatchMousePress(int n, int n2, int n3) {
            IWidget iWidget = this.findWidget(n, n2);
            if (iWidget != null) {
                return iWidget.dispatchMousePress(n - iWidget.left(), n2 - iWidget.top(), n3);
            }
            return this;
        }

        @Override
        public boolean dispatchKeyPress(char c, int n) {
            IWidget iWidget = this.getFocus();
            if (iWidget != null && iWidget.dispatchKeyPress(c, n)) {
                return true;
            }
            return super.dispatchKeyPress(c, n);
        }

        public IWidget findWidget(int n, int n2) {
            for (int i = this.widgets.size() - 1; i >= 0; --i) {
                IWidget iWidget = this.widgets.get(i);
                int n3 = iWidget.left();
                int n4 = iWidget.top();
                if (n < n3 || n2 < n4 || n >= n3 + iWidget.width() || n2 >= n4 + iWidget.height()) continue;
                return iWidget;
            }
            return null;
        }

        @Override
        public void layout() {
            for (IWidget iWidget : this.widgets) {
                iWidget.layout();
            }
        }
    }

    public static interface IWidgetContainer
    extends IWidget {
        public IWidget getFocus();

        public void setFocus(IWidget var1);
    }

    public static class Widget
    implements IWidget {
        public IWidgetContainer parent;
        public int left;
        public int top;
        public int width;
        public int height;

        public Widget() {
        }

        public Widget(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        @Override
        public IWidgetContainer parent() {
            return this.parent;
        }

        @Override
        public void setParent(IWidgetContainer iWidgetContainer) {
            this.parent = iWidgetContainer;
        }

        @Override
        public int left() {
            return this.left;
        }

        @Override
        public int top() {
            return this.top;
        }

        @Override
        public int width() {
            return this.width;
        }

        @Override
        public int height() {
            return this.height;
        }

        @Override
        public void setLeft(int n) {
            this.left = n;
        }

        @Override
        public void setTop(int n) {
            this.top = n;
        }

        @Override
        public void draw(Screen screen, int n, int n2) {
        }

        @Override
        public void mousePressed(MouseCoords mouseCoords, int n) {
        }

        @Override
        public void mouseMoved(MouseCoords mouseCoords) {
        }

        @Override
        public void mouseReleased(MouseCoords mouseCoords, int n) {
        }

        @Override
        public boolean keyPressed(char c, int n) {
            return false;
        }

        @Override
        public void focusChanged(boolean bl) {
        }

        @Override
        public void close() {
        }

        @Override
        public void layout() {
        }

        @Override
        public IWidget dispatchMousePress(int n, int n2, int n3) {
            return this;
        }

        @Override
        public boolean dispatchKeyPress(char c, int n) {
            return this.keyPressed(c, n);
        }

        public static int stringWidth(String string) {
            return Minecraft.func_71410_x().field_71466_p.func_78256_a(string);
        }

        public void addPopup(int n, int n2, IWidget iWidget) {
            IWidget iWidget2 = this;
            while (!(iWidget2 instanceof Root)) {
                n += iWidget2.left();
                n2 += iWidget2.top();
                iWidget2 = iWidget2.parent();
            }
            ((Root)iWidget2).addPopup(n, n2, iWidget);
        }

        public void removePopup() {
            Root root = this.getRoot();
            root.remove(this);
        }

        public Root getRoot() {
            IWidget iWidget;
            for (iWidget = this; iWidget != null && !(iWidget instanceof Root); iWidget = iWidget.parent()) {
            }
            return (Root)iWidget;
        }
    }

    public static interface IWidget {
        public IWidgetContainer parent();

        public void setParent(IWidgetContainer var1);

        public int left();

        public int top();

        public int width();

        public int height();

        public void setLeft(int var1);

        public void setTop(int var1);

        public void draw(Screen var1, int var2, int var3);

        public IWidget dispatchMousePress(int var1, int var2, int var3);

        public boolean dispatchKeyPress(char var1, int var2);

        public void mousePressed(MouseCoords var1, int var2);

        public void mouseMoved(MouseCoords var1);

        public void mouseReleased(MouseCoords var1, int var2);

        public boolean keyPressed(char var1, int var2);

        public void focusChanged(boolean var1);

        public void close();

        public void layout();
    }

    public static class MouseCoords {
        int x;
        int y;

        public MouseCoords(IWidget iWidget, int n, int n2) {
            while (iWidget != null) {
                n -= iWidget.left();
                n2 -= iWidget.top();
                iWidget = iWidget.parent();
            }
            this.x = n;
            this.y = n2;
        }
    }

    public static class Screen
    extends GuiContainer
    implements BaseMod.ISetMod {
        static final int defaultTextColor = 0x404040;
        protected BaseMod mod;
        protected Root root;
        protected String title;
        protected IWidget mouseWidget;
        protected GState gstate;

        public Screen(Container container, int n, int n2) {
            super(container);
            this.field_146999_f = n;
            this.field_147000_g = n2;
            this.root = new Root(this);
            this.initGraphics();
        }

        public Screen(BaseContainer baseContainer) {
            this(baseContainer, baseContainer.xSize, baseContainer.ySize);
        }

        public int getWidth() {
            return this.field_146999_f;
        }

        public int getHeight() {
            return this.field_147000_g;
        }

        @Override
        public void setMod(BaseMod baseMod) {
            this.mod = baseMod;
        }

        public void func_73866_w_() {
            super.func_73866_w_();
            this.root.layout();
        }

        protected void initGraphics() {
            this.gstate = new GState();
        }

        protected void func_146976_a(float f, int n, int n2) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
            this.initGraphics();
            this.drawBackgroundLayer();
            if (this.title != null) {
                this.drawTitle(this.title);
            }
            this.root.draw(this, n - this.field_147003_i, n2 - this.field_147009_r);
            GL11.glPopMatrix();
        }

        protected void drawBackgroundLayer() {
            this.initGraphics();
            this.drawGuiBackground(0.0, 0.0, this.field_146999_f, this.field_147000_g);
        }

        protected void func_146979_b(int n, int n2) {
            this.drawForegroundLayer();
        }

        protected void drawForegroundLayer() {
        }

        public void close() {
            this.dispatchClosure(this.root);
            this.onClose();
            this.field_146297_k.field_71439_g.func_71053_j();
        }

        protected void onClose() {
        }

        public void bindTexture(String string) {
            this.bindTexture(string, 1, 1);
        }

        public void bindTexture(String string, int n, int n2) {
            this.bindTexture(((BaseModClient)this.mod.client).textureLocation(string), n, n2);
        }

        public void bindTexture(ResourceLocation resourceLocation) {
            this.bindTexture(resourceLocation, 1, 1);
        }

        public void bindTexture(ResourceLocation resourceLocation, int n, int n2) {
            this.gstate.texture = resourceLocation;
            this.field_146297_k.func_110434_K().func_110577_a(resourceLocation);
            this.gstate.uscale = 1.0 / (double)n;
            this.gstate.vscale = 1.0 / (double)n2;
        }

        public void gSave() {
            this.gstate = new GState(this.gstate);
        }

        public void gRestore() {
            if (this.gstate.previous != null) {
                this.gstate = this.gstate.previous;
                this.field_146297_k.func_110434_K().func_110577_a(this.gstate.texture);
            } else {
                System.out.printf("BaseGui: Warning: Graphics state stack underflow\n", new Object[0]);
            }
        }

        public void drawRect(double d, double d2, double d3, double d4) {
            GL11.glDisable((int)3553);
            GL11.glColor3d((double)this.gstate.red, (double)this.gstate.green, (double)this.gstate.blue);
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)d, (double)(d2 + d4), (double)this.field_73735_i);
            GL11.glVertex3d((double)(d + d3), (double)(d2 + d4), (double)this.field_73735_i);
            GL11.glVertex3d((double)(d + d3), (double)d2, (double)this.field_73735_i);
            GL11.glVertex3d((double)d, (double)d2, (double)this.field_73735_i);
            GL11.glEnd();
            GL11.glEnable((int)3553);
        }

        public void drawBorderedRect(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
            double d11 = d9;
            double d12 = d10;
            double d13 = d3 - 2.0 * d9;
            double d14 = d4 - 2.0 * d10;
            double d15 = d7 - 2.0 * d9;
            double d16 = d8 - 2.0 * d10;
            double d17 = d + d11;
            double d18 = d3 - d11;
            double d19 = d2 + d12;
            double d20 = d4 - d12;
            double d21 = d5 + d11;
            double d22 = d7 - d11;
            double d23 = d6 + d12;
            double d24 = d8 - d11;
            this.drawTexturedRect(d, d2, d11, d12, d5, d6);
            this.drawTexturedRect(d18, d2, d11, d12, d22, d6);
            this.drawTexturedRect(d, d20, d11, d12, d5, d24);
            this.drawTexturedRect(d18, d20, d11, d12, d22, d24);
            this.drawTexturedRect(d17, d2, d13, d12, d21, d6, d15, d12);
            this.drawTexturedRect(d17, d20, d13, d12, d21, d24, d15, d12);
            this.drawTexturedRect(d, d19, d11, d14, d5, d23, d11, d16);
            this.drawTexturedRect(d18, d19, d11, d14, d22, d23, d11, d16);
            this.drawTexturedRect(d17, d19, d13, d14, d21, d23, d15, d16);
        }

        public void drawGuiBackground(double d, double d2, double d3, double d4) {
            this.bindTexture("gui/gui_background.png", 16, 16);
            this.setColor(0xFFFFFF);
            this.drawBorderedRect(d, d2, d3, d4, 0.0, 0.0, 16.0, 16.0, 4.0, 4.0);
        }

        public void drawTexturedRect(double d, double d2, double d3, double d4) {
            this.drawTexturedRectUV(d, d2, d3, d4, 0.0, 0.0, 1.0, 1.0);
        }

        public void drawTexturedRect(double d, double d2, double d3, double d4, double d5, double d6) {
            this.drawTexturedRect(d, d2, d3, d4, d5, d6, d3, d4);
        }

        public void drawTexturedRect(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            this.drawTexturedRectUV(d, d2, d3, d4, d5 * this.gstate.uscale, d6 * this.gstate.vscale, d7 * this.gstate.uscale, d8 * this.gstate.vscale);
        }

        public void drawTexturedRectUV(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            GL11.glBegin((int)7);
            GL11.glColor3f((float)this.gstate.red, (float)this.gstate.green, (float)this.gstate.blue);
            GL11.glTexCoord2d((double)d5, (double)(d6 + d8));
            GL11.glVertex3d((double)d, (double)(d2 + d4), (double)this.field_73735_i);
            GL11.glTexCoord2d((double)(d5 + d7), (double)(d6 + d8));
            GL11.glVertex3d((double)(d + d3), (double)(d2 + d4), (double)this.field_73735_i);
            GL11.glTexCoord2d((double)(d5 + d7), (double)d6);
            GL11.glVertex3d((double)(d + d3), (double)d2, (double)this.field_73735_i);
            GL11.glTexCoord2d((double)d5, (double)d6);
            GL11.glVertex3d((double)d, (double)d2, (double)this.field_73735_i);
            GL11.glEnd();
        }

        public void setColor(int n) {
            this.setColor((double)(n >> 16) / 255.0, (double)(n >> 8 & 0xFF) / 255.0, (double)(n & 0xFF) / 255.0);
        }

        public void setColor(double d, double d2, double d3) {
            this.gstate.red = (float)d;
            this.gstate.green = (float)d2;
            this.gstate.blue = (float)d3;
        }

        public void resetColor() {
            this.setColor(1.0, 1.0, 1.0);
        }

        public void setTextColor(int n) {
            this.gstate.textColor = n;
        }

        public void setTextColor(double d, double d2, double d3) {
            this.setTextColor(BaseUtils.packedColor(d, d2, d3));
        }

        public void setTextShadow(boolean bl) {
            this.gstate.textShadow = bl;
        }

        public void drawString(String string, int n, int n2) {
            this.field_146289_q.func_85187_a(string, n, n2, this.gstate.textColor, this.gstate.textShadow);
        }

        public void drawCenteredString(String string, int n, int n2) {
            this.field_146289_q.func_85187_a(string, n - this.field_146289_q.func_78256_a(string) / 2, n2, this.gstate.textColor, this.gstate.textShadow);
        }

        public void drawRightAlignedString(String string, int n, int n2) {
            this.field_146289_q.func_85187_a(string, n - this.field_146289_q.func_78256_a(string), n2, this.gstate.textColor, this.gstate.textShadow);
        }

        public void drawTitle(String string) {
            this.drawCenteredString(string, this.field_146999_f / 2, 4);
        }

        public void drawInventoryName(IInventory iInventory, int n, int n2) {
            this.drawString(Screen.inventoryName(iInventory), n, n2);
        }

        public void drawPlayerInventoryName() {
            this.drawString(Screen.playerInventoryName(), 8, this.field_147000_g - 96 + 2);
        }

        public static String inventoryName(IInventory iInventory) {
            String string = iInventory.func_145825_b();
            if (!iInventory.func_145818_k_()) {
                string = StatCollector.func_74838_a((String)string);
            }
            return string;
        }

        public static String playerInventoryName() {
            return StatCollector.func_74838_a((String)"container.inventory");
        }

        protected void func_146286_b(int n, int n2, int n3) {
            super.func_146286_b(n, n2, n3);
            if (this.mouseWidget != null) {
                MouseCoords mouseCoords = new MouseCoords(this.mouseWidget, n, n2);
                if (n3 == -1) {
                    this.mouseWidget.mouseMoved(mouseCoords);
                } else {
                    this.mouseWidget.mouseReleased(mouseCoords, n3);
                    this.mouseWidget = null;
                }
            }
        }

        public void func_73864_a(int n, int n2, int n3) {
            super.func_73864_a(n, n2, n3);
            this.mousePressed(n - this.field_147003_i, n2 - this.field_147009_r, n3);
        }

        protected void mousePressed(int n, int n2, int n3) {
            this.mouseWidget = this.root.dispatchMousePress(n, n2, n3);
            if (this.mouseWidget != null) {
                this.closeOldFocus(this.mouseWidget);
                this.focusOn(this.mouseWidget);
                this.mouseWidget.mousePressed(new MouseCoords(this.mouseWidget, n, n2), n3);
            }
        }

        void closeOldFocus(IWidget iWidget) {
            if (!BaseGui.isFocused(iWidget)) {
                IWidgetContainer iWidgetContainer = iWidget.parent();
                while (!BaseGui.isFocused(iWidgetContainer)) {
                    iWidgetContainer = iWidgetContainer.parent();
                }
                this.dispatchClosure(iWidgetContainer.getFocus());
            }
        }

        void dispatchClosure(IWidget iWidget) {
            while (iWidget != null) {
                iWidget.close();
                iWidget = this.getFocusOf(iWidget);
            }
        }

        IWidget getFocusOf(IWidget iWidget) {
            if (iWidget instanceof IWidgetContainer) {
                return ((IWidgetContainer)iWidget).getFocus();
            }
            return null;
        }

        public void func_73869_a(char c, int n) {
            if (!this.root.dispatchKeyPress(c, n)) {
                if (n == 1 || n == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
                    this.close();
                } else {
                    super.func_73869_a(c, n);
                }
            }
        }

        public void focusOn(IWidget iWidget) {
            IWidgetContainer iWidgetContainer = iWidget.parent();
            if (iWidgetContainer != null) {
                IWidget iWidget2 = iWidgetContainer.getFocus();
                if (BaseGui.isFocused(iWidgetContainer)) {
                    if (iWidget2 != iWidget) {
                        BaseGui.tellFocusChanged(iWidget2, false);
                        iWidgetContainer.setFocus(iWidget);
                        BaseGui.tellFocusChanged(iWidget, true);
                    }
                } else {
                    iWidgetContainer.setFocus(iWidget);
                    this.focusOn(iWidgetContainer);
                }
            }
        }

        public void focusChanged(boolean bl) {
        }
    }
}

