/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseMod;
import gcewing.architecture.BaseModClient;
import gcewing.architecture.BlockPos;
import gcewing.architecture.EnumWorldBlockLayer;
import gcewing.architecture.IBlockState;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class BaseModelRenderer
implements BaseModClient.ICustomRenderer {
    public static boolean debugRenderModel = false;
    protected BaseModClient.IModel model;
    protected BaseModClient.ITexture[] textures;
    protected Vector3 origin;

    public BaseModelRenderer(BaseModClient.IModel iModel, BaseModClient.ITexture ... iTextureArray) {
        this(iModel, Vector3.zero, iTextureArray);
    }

    public BaseModelRenderer(BaseModClient.IModel iModel, Vector3 vector3, BaseModClient.ITexture ... iTextureArray) {
        this.model = iModel;
        this.textures = iTextureArray;
        this.origin = vector3;
    }

    @Override
    public void renderBlock(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, BaseModClient.IRenderTarget iRenderTarget, EnumWorldBlockLayer enumWorldBlockLayer, Trans3 trans3) {
        BaseMod.IBlock iBlock = (BaseMod.IBlock)iBlockState.getBlock();
        Trans3 trans32 = trans3.t(iBlock.localToGlobalTransformation(iBlockAccess, blockPos, iBlockState, Vector3.zero)).translate(this.origin);
        this.model.render(trans32, iRenderTarget, this.textures);
    }

    @Override
    public void renderItemStack(ItemStack itemStack, BaseModClient.IRenderTarget iRenderTarget, Trans3 trans3) {
        if (debugRenderModel) {
            System.out.printf("BaseModelRenderer.renderItemStack: %s\n", itemStack);
            System.out.printf("BaseModelRenderer.renderItemStack: model = %s\n", this.model);
            for (int i = 0; i < this.textures.length; ++i) {
                System.out.printf("BaseModelRenderer.renderItemStack: textures[%s] = %s\n", i, this.textures[i]);
            }
        }
        this.model.render(trans3.translate(this.origin), iRenderTarget, this.textures);
    }
}

