/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseMod;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.BlockPos;
import gcewing.architecture.IBlockState;
import gcewing.architecture.ITickable;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;

public class BaseTileEntity
extends TileEntity
implements BaseMod.ITileEntity {
    public byte side;
    public byte turn;
    public ForgeChunkManager.Ticket chunkTicket;
    protected static Method getOrCreateChunkWatcher = BaseUtils.getMethodDef(PlayerManager.class, "getOrCreateChunkWatcher", "func_72690_a", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
    protected static Field flagsYAreasToUpdate = BaseUtils.getFieldDef(BaseUtils.classForName("net.minecraft.server.management.PlayerManager$PlayerInstance"), "flagsYAreasToUpdate", "field_73260_f");

    public BlockPos getPos() {
        return new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getX() {
        return this.field_145851_c;
    }

    public int getY() {
        return this.field_145848_d;
    }

    public int getZ() {
        return this.field_145849_e;
    }

    public void setSide(int n) {
        this.side = (byte)n;
    }

    public void setTurn(int n) {
        this.turn = (byte)n;
    }

    public Trans3 localToGlobalRotation() {
        return this.localToGlobalTransformation(Vector3.zero);
    }

    public Trans3 localToGlobalTransformation() {
        return this.localToGlobalTransformation(Vector3.blockCenter(this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    public Trans3 localToGlobalTransformation(Vector3 vector3) {
        BlockPos blockPos = this.getPos();
        IBlockState iBlockState = BaseBlockUtils.getWorldBlockState((IBlockAccess)this.field_145850_b, blockPos);
        Block block = iBlockState.getBlock();
        if (block instanceof BaseMod.IBlock) {
            return ((BaseMod.IBlock)block).localToGlobalTransformation((IBlockAccess)this.field_145850_b, blockPos, iBlockState, vector3);
        }
        System.out.printf("BaseTileEntity.localToGlobalTransformation: Wrong block type at %s\n", blockPos);
        return new Trans3(vector3);
    }

    public Packet func_145844_m() {
        if (this.syncWithClient()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            this.func_145841_b(nBTTagCompound);
            return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nBTTagCompound);
        }
        return null;
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity s35PacketUpdateTileEntity) {
        this.func_145839_a(s35PacketUpdateTileEntity.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    boolean syncWithClient() {
        return true;
    }

    public void markBlockForUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void markForClientUpdate() {
        PlayerManager playerManager = ((WorldServer)this.field_145850_b).func_73040_p();
        Object object = BaseUtils.invokeMethod(playerManager, getOrCreateChunkWatcher, this.field_145851_c >> 4, this.field_145849_e >> 4, false);
        if (object != null) {
            int n = BaseUtils.getIntField(object, flagsYAreasToUpdate);
            this.markBlockForUpdate();
            BaseUtils.setIntField(object, flagsYAreasToUpdate, n);
        } else {
            this.markBlockForUpdate();
        }
    }

    public void markForUpdate() {
        this.func_70296_d();
        this.markForClientUpdate();
    }

    public void playSoundEffect(String string, float f, float f2) {
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, string, f, f2);
    }

    @Override
    public void onAddedToWorld() {
    }

    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.side = nBTTagCompound.func_74771_c("side");
        this.turn = nBTTagCompound.func_74771_c("turn");
        this.readContentsFromNBT(nBTTagCompound);
    }

    public void readFromItemStack(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound != null) {
            this.readFromItemStackNBT(nBTTagCompound);
        }
    }

    public void readFromItemStackNBT(NBTTagCompound nBTTagCompound) {
        this.readContentsFromNBT(nBTTagCompound);
    }

    public void readContentsFromNBT(NBTTagCompound nBTTagCompound) {
    }

    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        if (this.side != 0) {
            nBTTagCompound.func_74774_a("side", this.side);
        }
        if (this.turn != 0) {
            nBTTagCompound.func_74774_a("turn", this.turn);
        }
        this.writeContentsToNBT(nBTTagCompound);
    }

    public void writeToItemStackNBT(NBTTagCompound nBTTagCompound) {
        this.writeContentsToNBT(nBTTagCompound);
    }

    public void writeContentsToNBT(NBTTagCompound nBTTagCompound) {
    }

    public void markChanged() {
        this.func_70296_d();
        this.markBlockForUpdate();
    }

    public void func_145843_s() {
        this.releaseChunkTicket();
        super.func_145843_s();
    }

    public void releaseChunkTicket() {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            this.chunkTicket = null;
        }
    }

    public static ItemStack blockStackWithTileEntity(Block block, int n, BaseTileEntity baseTileEntity) {
        return BaseTileEntity.blockStackWithTileEntity(block, n, 0, baseTileEntity);
    }

    public static ItemStack blockStackWithTileEntity(Block block, int n, int n2, BaseTileEntity baseTileEntity) {
        ItemStack itemStack = new ItemStack(block, n, n2);
        if (baseTileEntity != null) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            baseTileEntity.writeToItemStackNBT(nBTTagCompound);
            itemStack.func_77982_d(nBTTagCompound);
        }
        return itemStack;
    }

    public ItemStack newItemStack(int n) {
        return BaseTileEntity.blockStackWithTileEntity(this.func_145838_q(), n, this);
    }

    public boolean canUpdate() {
        return this instanceof ITickable;
    }

    public void func_145845_h() {
        ((ITickable)((Object)this)).update();
    }
}

