/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseTileEntity;
import gcewing.architecture.BlockPos;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapStorage;

public class BaseUtils {
    public static EnumFacing[] facings = EnumFacing.values();
    public static EnumFacing[] horizontalFacings = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.EAST};

    public static int abs(int n) {
        return n >= 0 ? n : -n;
    }

    public static int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static double min(double d, double d2) {
        return d < d2 ? d : d2;
    }

    public static double max(double d, double d2) {
        return d > d2 ? d : d2;
    }

    public static int clampIndex(int n, int n2) {
        return BaseUtils.max(0, BaseUtils.min(n, n2 - 1));
    }

    public static int ifloor(double d) {
        return (int)Math.floor(d);
    }

    public static int iround(double d) {
        return (int)Math.round(d);
    }

    public static int iceil(double d) {
        return (int)Math.ceil(d);
    }

    public static Object[] arrayOf(Collection collection) {
        int n = collection.size();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        for (Object e : collection) {
            objectArray[n2++] = e;
        }
        return objectArray;
    }

    public static Class classForName(String string) {
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Field getFieldDef(Class clazz, String string, String string2) {
        try {
            Field field;
            try {
                field = clazz.getDeclaredField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                field = clazz.getDeclaredField(string2);
            }
            field.setAccessible(true);
            return field;
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Cannot find field %s or %s of %s", string, string2, clazz.getName()), exception);
        }
    }

    public static Object getField(Object object, String string, String string2) {
        Field field = BaseUtils.getFieldDef(object.getClass(), string, string2);
        return BaseUtils.getField(object, field);
    }

    public static Object getField(Object object, Field field) {
        try {
            return field.get(object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static int getIntField(Object object, Field field) {
        try {
            return field.getInt(object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void setField(Object object, String string, String string2, Object object2) {
        Field field = BaseUtils.getFieldDef(object.getClass(), string, string2);
        BaseUtils.setField(object, field, object2);
    }

    public static void setField(Object object, Field field, Object object2) {
        try {
            field.set(object, object2);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void setIntField(Object object, Field field, int n) {
        try {
            field.setInt(object, n);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Method getMethodDef(Class clazz, String string, String string2, Class ... classArray) {
        try {
            Method method;
            try {
                method = clazz.getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = clazz.getDeclaredMethod(string2, classArray);
            }
            method.setAccessible(true);
            return method;
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Cannot find method %s or %s of %s", string, string2, clazz.getName()), exception);
        }
    }

    public static Object invokeMethod(Object object, Method method, Object ... objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static int packedColor(double d, double d2, double d3) {
        return (int)(d * 255.0) << 16 | (int)(d2 * 255.0) << 8 | (int)(d3 * 255.0);
    }

    public static int turnToFace(EnumFacing enumFacing, EnumFacing enumFacing2) {
        return BaseUtils.turnToFaceEast(enumFacing) - BaseUtils.turnToFaceEast(enumFacing2) & 3;
    }

    public static int turnToFaceEast(EnumFacing enumFacing) {
        switch (enumFacing) {
            case SOUTH: {
                return 1;
            }
            case WEST: {
                return 2;
            }
            case NORTH: {
                return 3;
            }
        }
        return 0;
    }

    public static ItemStack blockStackWithTileEntity(Block block, int n, BaseTileEntity baseTileEntity) {
        ItemStack itemStack = new ItemStack(block, n);
        if (baseTileEntity != null) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            baseTileEntity.writeToItemStackNBT(nBTTagCompound);
            itemStack.func_77982_d(nBTTagCompound);
        }
        return itemStack;
    }

    public static BlockPos readBlockPos(DataInput dataInput) {
        try {
            int n = dataInput.readInt();
            int n2 = dataInput.readInt();
            int n3 = dataInput.readInt();
            return new BlockPos(n, n2, n3);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void writeBlockPos(DataOutput dataOutput, BlockPos blockPos) {
        try {
            dataOutput.writeInt(blockPos.getX());
            dataOutput.writeInt(blockPos.getY());
            dataOutput.writeInt(blockPos.getZ());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static int getWorldDimensionId(World world) {
        return world.field_73011_w.field_76574_g;
    }

    public static EnumDifficulty getWorldDifficulty(World world) {
        return world.field_73013_u;
    }

    public static World getChunkWorld(Chunk chunk) {
        return chunk.field_76637_e;
    }

    public static Map getChunkTileEntityMap(Chunk chunk) {
        return chunk.field_150816_i;
    }

    public static AxisAlignedBB newAxisAlignedBB(double d, double d2, double d3, double d4, double d5, double d6) {
        return AxisAlignedBB.func_72330_a((double)d, (double)d2, (double)d3, (double)d4, (double)d5, (double)d6);
    }

    public static boolean getGameRuleBoolean(GameRules gameRules, String string) {
        return gameRules.func_82766_b(string);
    }

    public static void scmPreparePlayer(ServerConfigurationManager serverConfigurationManager, EntityPlayerMP entityPlayerMP, WorldServer worldServer) {
        serverConfigurationManager.func_72375_a(entityPlayerMP, worldServer);
    }

    public static void setBoundingBoxOfEntity(Entity entity, AxisAlignedBB axisAlignedBB) {
        entity.field_70121_D.func_72324_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c, axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f);
    }

    public static String getEntityName(Entity entity) {
        return entity.func_70005_c_();
    }

    public static MapStorage getPerWorldStorage(World world) {
        return world.perWorldStorage;
    }

    public static EnumFacing oppositeFacing(EnumFacing enumFacing) {
        return facings[enumFacing.ordinal() ^ 1];
    }

    public static boolean facingAxesEqual(EnumFacing enumFacing, EnumFacing enumFacing2) {
        return (enumFacing.ordinal() & 6) == (enumFacing2.ordinal() & 6);
    }

    public static int getStackMetadata(ItemStack itemStack) {
        return itemStack.func_77973_b().func_77647_b(itemStack.func_77960_j());
    }

    public static MovingObjectPosition newMovingObjectPosition(Vec3 vec3, int n, BlockPos blockPos) {
        return new MovingObjectPosition(blockPos.x, blockPos.y, blockPos.z, n, vec3, true);
    }

    public static AxisAlignedBB boxUnion(AxisAlignedBB axisAlignedBB, AxisAlignedBB axisAlignedBB2) {
        return axisAlignedBB.func_111270_a(axisAlignedBB2);
    }

    public static MinecraftServer getMinecraftServer() {
        return MinecraftServer.func_71276_C();
    }

    public static WorldServer getWorldForDimension(int n) {
        return BaseUtils.getMinecraftServer().func_71218_a(n);
    }

    public static <T extends WorldSavedData> T getWorldData(World world, Class<T> clazz, String string) {
        MapStorage mapStorage = world.perWorldStorage;
        WorldSavedData worldSavedData = mapStorage.func_75742_a(clazz, string);
        if (worldSavedData == null) {
            try {
                worldSavedData = (WorldSavedData)clazz.getConstructor(String.class).newInstance(string);
                mapStorage.func_75745_a(string, worldSavedData);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return (T)worldSavedData;
    }
}

