/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import gcewing.architecture.IBlockState;
import gcewing.architecture.IProperty;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;

public abstract class BlockStateBase
implements IBlockState {
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    private static final Function<Map.Entry<IProperty, Comparable>, String> MAP_ENTRY_TO_STRING = new Function<Map.Entry<IProperty, Comparable>, String>(){

        public String apply(Map.Entry<IProperty, Comparable> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            IProperty iProperty = entry.getKey();
            return iProperty.getName() + "=" + iProperty.getName(entry.getValue());
        }
    };

    @Override
    public <T extends Comparable<T>> IBlockState cycleProperty(IProperty<T> iProperty) {
        return this.withProperty(iProperty, (Comparable)BlockStateBase.cyclePropertyValue(iProperty.getAllowedValues(), this.getValue(iProperty)));
    }

    protected static <T> T cyclePropertyValue(Collection<T> collection, T t) {
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(t)) continue;
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return collection.iterator().next();
        }
        return iterator.next();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Block.field_149771_c.func_148750_c((Object)this.getBlock()));
        if (!this.getProperties().isEmpty()) {
            stringBuilder.append("[");
            COMMA_JOINER.appendTo(stringBuilder, Iterables.transform((Iterable)this.getProperties().entrySet(), MAP_ENTRY_TO_STRING));
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public ImmutableTable<IProperty, Comparable, IBlockState> getPropertyValueTable() {
        return null;
    }
}

