/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import cofh.api.energy.IEnergyReceiver;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.metatileentity.IMetaTileEntityCable;
import gregtech.api.interfaces.tileentity.IColoredTileEntity;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Client;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaPipeEntity_Cable
extends MetaPipeEntity
implements IMetaTileEntityCable {
    public final float mThickNess;
    public final Materials mMaterial;
    public final long mCableLossPerMeter;
    public final long mAmperage;
    public final long mVoltage;
    public final boolean mInsulated;
    public final boolean mCanShock;
    public long mTransferredAmperage = 0L;
    public long mTransferredAmperageLast20 = 0L;
    public long mTransferredVoltageLast20 = 0L;
    public long mRestRF;
    public short mOverheat;

    public GT_MetaPipeEntity_Cable(int aID, String aName, String aNameRegional, float aThickNess, Materials aMaterial, long aCableLossPerMeter, long aAmperage, long aVoltage, boolean aInsulated, boolean aCanShock) {
        super(aID, aName, aNameRegional, 0);
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mAmperage = aAmperage;
        this.mVoltage = aVoltage;
        this.mInsulated = aInsulated;
        this.mCanShock = aCanShock;
        this.mCableLossPerMeter = aCableLossPerMeter;
    }

    public GT_MetaPipeEntity_Cable(String aName, float aThickNess, Materials aMaterial, long aCableLossPerMeter, long aAmperage, long aVoltage, boolean aInsulated, boolean aCanShock) {
        super(aName, 0);
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mAmperage = aAmperage;
        this.mVoltage = aVoltage;
        this.mInsulated = aInsulated;
        this.mCanShock = aCanShock;
        this.mCableLossPerMeter = aCableLossPerMeter;
    }

    @Override
    public byte getTileEntityBaseType() {
        return (byte)(this.mInsulated ? 9 : 8);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaPipeEntity_Cable(this.mName, this.mThickNess, this.mMaterial, this.mCableLossPerMeter, this.mAmperage, this.mVoltage, this.mInsulated, this.mCanShock);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aConnections, byte aColorIndex, boolean aConnected, boolean aRedstone) {
        if (!this.mInsulated) {
            return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
        }
        if (aConnected) {
            float tThickNess = this.getThickNess();
            if (tThickNess < 0.124f) {
                return new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.INSULATION_FULL, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.374f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_TINY, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.499f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_SMALL, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.624f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_MEDIUM, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.749f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_MEDIUM_PLUS, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.874f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_LARGE, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_HUGE, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
        }
        return new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.INSULATION_FULL, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
    }

    @Override
    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity aEntity) {
        if (this.mCanShock && (((BaseMetaPipeEntity)this.getBaseMetaTileEntity()).mConnections & 0xFFFFFF80) == 0 && aEntity instanceof EntityLivingBase && !this.isCoverOnSide((BaseMetaPipeEntity)this.getBaseMetaTileEntity(), (EntityLivingBase)aEntity)) {
            GT_Utility.applyElectricityDamage((EntityLivingBase)aEntity, this.mTransferredVoltageLast20, this.mTransferredAmperageLast20);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        byte tConn;
        float tSpace;
        float tSide0 = tSpace = (1.0f - this.mThickNess) / 2.0f;
        float tSide1 = 1.0f - tSpace;
        float tSide2 = tSpace;
        float tSide3 = 1.0f - tSpace;
        float tSide4 = tSpace;
        float tSide5 = 1.0f - tSpace;
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)0) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)1) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)2) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)3) != 0) {
            tSide4 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)4) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)5) != 0) {
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (((tConn = ((BaseMetaPipeEntity)this.getBaseMetaTileEntity()).mConnections) & 1 << ForgeDirection.DOWN.ordinal()) != 0) {
            tSide0 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.UP.ordinal()) != 0) {
            tSide1 = 1.0f;
        }
        if ((tConn & 1 << ForgeDirection.NORTH.ordinal()) != 0) {
            tSide2 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.SOUTH.ordinal()) != 0) {
            tSide3 = 1.0f;
        }
        if ((tConn & 1 << ForgeDirection.WEST.ordinal()) != 0) {
            tSide4 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.EAST.ordinal()) != 0) {
            tSide5 = 1.0f;
        }
        return AxisAlignedBB.func_72330_a((double)((float)aX + tSide4), (double)((float)aY + tSide0), (double)((float)aZ + tSide2), (double)((float)aX + tSide5), (double)((float)aY + tSide1), (double)((float)aZ + tSide3));
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public final boolean renderInside(byte aSide) {
        return false;
    }

    @Override
    public int getProgresstime() {
        return (int)this.mTransferredAmperage * 64;
    }

    @Override
    public int maxProgresstime() {
        return (int)this.mAmperage * 64;
    }

    @Override
    public long injectEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        if (!this.getBaseMetaTileEntity().getCoverBehaviorAtSide(aSide).letsEnergyIn(aSide, this.getBaseMetaTileEntity().getCoverIDAtSide(aSide), this.getBaseMetaTileEntity().getCoverDataAtSide(aSide), this.getBaseMetaTileEntity())) {
            return 0L;
        }
        return this.transferElectricity(aSide, aVoltage, aAmperage, new ArrayList<TileEntity>(Arrays.asList((TileEntity)this.getBaseMetaTileEntity())));
    }

    @Override
    public long transferElectricity(byte aSide, long aVoltage, long aAmperage, ArrayList<TileEntity> aAlreadyPassedTileEntityList) {
        long rUsedAmperes = 0L;
        if ((aVoltage -= this.mCableLossPerMeter) > 0L) {
            for (byte i = 0; i < 6 && aAmperage > rUsedAmperes; i = (byte)(i + 1)) {
                int rfOut;
                TileEntity tTileEntity;
                if (i == aSide || (this.mConnections & 1 << i) == 0 || !this.getBaseMetaTileEntity().getCoverBehaviorAtSide(i).letsEnergyOut(i, this.getBaseMetaTileEntity().getCoverIDAtSide(i), this.getBaseMetaTileEntity().getCoverDataAtSide(i), this.getBaseMetaTileEntity()) || aAlreadyPassedTileEntityList.contains(tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(i))) continue;
                aAlreadyPassedTileEntityList.add(tTileEntity);
                if (tTileEntity instanceof IEnergyConnected) {
                    byte tColor;
                    if (this.getBaseMetaTileEntity().getColorization() >= 0 && (tColor = ((IEnergyConnected)tTileEntity).getColorization()) >= 0 && tColor != this.getBaseMetaTileEntity().getColorization()) continue;
                    if (tTileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)tTileEntity).getMetaTileEntity() instanceof IMetaTileEntityCable && ((IGregTechTileEntity)tTileEntity).getCoverBehaviorAtSide(GT_Utility.getOppositeSide(i)).letsEnergyIn(GT_Utility.getOppositeSide(i), ((IGregTechTileEntity)tTileEntity).getCoverIDAtSide(GT_Utility.getOppositeSide(i)), ((IGregTechTileEntity)tTileEntity).getCoverDataAtSide(GT_Utility.getOppositeSide(i)), (IGregTechTileEntity)tTileEntity)) {
                        if (((IGregTechTileEntity)tTileEntity).getTimer() <= 50L) continue;
                        rUsedAmperes += ((IMetaTileEntityCable)((IGregTechTileEntity)tTileEntity).getMetaTileEntity()).transferElectricity(GT_Utility.getOppositeSide(i), aVoltage, aAmperage - rUsedAmperes, aAlreadyPassedTileEntityList);
                        continue;
                    }
                    rUsedAmperes += ((IEnergyConnected)tTileEntity).injectEnergyUnits(GT_Utility.getOppositeSide(i), aVoltage, aAmperage - rUsedAmperes);
                    continue;
                }
                if (tTileEntity instanceof IEnergySink) {
                    ForgeDirection tDirection = ForgeDirection.getOrientation((int)i).getOpposite();
                    if (!((IEnergySink)tTileEntity).acceptsEnergyFrom((TileEntity)this.getBaseMetaTileEntity(), tDirection) || !(((IEnergySink)tTileEntity).getDemandedEnergy() > 0.0) || !(((IEnergySink)tTileEntity).injectEnergy(tDirection, (double)aVoltage, (double)aVoltage) < (double)aVoltage)) continue;
                    ++rUsedAmperes;
                    continue;
                }
                if (!GregTech_API.mOutputRF || !(tTileEntity instanceof IEnergyReceiver)) continue;
                ForgeDirection tDirection = ForgeDirection.getOrientation((int)i).getOpposite();
                if (((IEnergyReceiver)tTileEntity).receiveEnergy(tDirection, rfOut = (int)(aVoltage * (long)GregTech_API.mEUtoRF / 100L), true) == rfOut) {
                    ((IEnergyReceiver)tTileEntity).receiveEnergy(tDirection, rfOut, false);
                    ++rUsedAmperes;
                } else if (((IEnergyReceiver)tTileEntity).receiveEnergy(tDirection, rfOut, true) > 0) {
                    int RFtrans;
                    if (this.mRestRF == 0L) {
                        RFtrans = ((IEnergyReceiver)tTileEntity).receiveEnergy(tDirection, rfOut, false);
                        ++rUsedAmperes;
                        this.mRestRF = rfOut - RFtrans;
                    } else {
                        RFtrans = ((IEnergyReceiver)tTileEntity).receiveEnergy(tDirection, (int)this.mRestRF, false);
                        this.mRestRF -= (long)RFtrans;
                    }
                }
                if (!GregTech_API.mRFExplosions || ((IEnergyReceiver)tTileEntity).getMaxEnergyStored(tDirection) >= rfOut * 600 || rfOut <= 32 * GregTech_API.mEUtoRF / 100) continue;
                this.doExplosion(rfOut);
            }
        }
        this.mTransferredAmperage += rUsedAmperes;
        this.mTransferredVoltageLast20 = Math.max(this.mTransferredVoltageLast20, aVoltage);
        this.mTransferredAmperageLast20 = Math.max(this.mTransferredAmperageLast20, this.mTransferredAmperage);
        if (aVoltage > this.mVoltage || this.mTransferredAmperage > this.mAmperage) {
            if (this.mOverheat > GT_Mod.gregtechproxy.mWireHeatingTicks * 100) {
                this.getBaseMetaTileEntity().setToFire();
            } else {
                this.mOverheat = (short)(this.mOverheat + 100);
            }
            return aAmperage;
        }
        return rUsedAmperes;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.mTransferredAmperage = 0L;
            if (this.mOverheat > 0) {
                this.mOverheat = (short)(this.mOverheat - 1);
            }
            if (aTick % 20L == 0L) {
                this.mTransferredVoltageLast20 = 0L;
                this.mTransferredAmperageLast20 = 0L;
                this.mConnections = 0;
                byte j = 0;
                for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                    byte tColor;
                    TileEntity tTileEntity;
                    j = GT_Utility.getOppositeSide(i);
                    if (!aBaseMetaTileEntity.getCoverBehaviorAtSide(i).alwaysLookConnected(i, aBaseMetaTileEntity.getCoverIDAtSide(i), aBaseMetaTileEntity.getCoverDataAtSide(i), aBaseMetaTileEntity) && !aBaseMetaTileEntity.getCoverBehaviorAtSide(i).letsEnergyIn(i, aBaseMetaTileEntity.getCoverIDAtSide(i), aBaseMetaTileEntity.getCoverDataAtSide(i), aBaseMetaTileEntity) && !aBaseMetaTileEntity.getCoverBehaviorAtSide(i).letsEnergyOut(i, aBaseMetaTileEntity.getCoverIDAtSide(i), aBaseMetaTileEntity.getCoverDataAtSide(i), aBaseMetaTileEntity) || (tTileEntity = aBaseMetaTileEntity.getTileEntityAtSide(i)) instanceof IColoredTileEntity && aBaseMetaTileEntity.getColorization() >= 0 && (tColor = ((IColoredTileEntity)tTileEntity).getColorization()) >= 0 && tColor != aBaseMetaTileEntity.getColorization()) continue;
                    if (tTileEntity instanceof IEnergyConnected && (((IEnergyConnected)tTileEntity).inputEnergyFrom(j) || ((IEnergyConnected)tTileEntity).outputsEnergyTo(j))) {
                        this.mConnections = (byte)(this.mConnections | 1 << i);
                        continue;
                    }
                    if (tTileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)tTileEntity).getMetaTileEntity() instanceof IMetaTileEntityCable && (((IGregTechTileEntity)tTileEntity).getCoverBehaviorAtSide(j).alwaysLookConnected(j, ((IGregTechTileEntity)tTileEntity).getCoverIDAtSide(j), ((IGregTechTileEntity)tTileEntity).getCoverDataAtSide(j), (IGregTechTileEntity)tTileEntity) || ((IGregTechTileEntity)tTileEntity).getCoverBehaviorAtSide(j).letsEnergyIn(j, ((IGregTechTileEntity)tTileEntity).getCoverIDAtSide(j), ((IGregTechTileEntity)tTileEntity).getCoverDataAtSide(j), (IGregTechTileEntity)tTileEntity) || ((IGregTechTileEntity)tTileEntity).getCoverBehaviorAtSide(j).letsEnergyOut(j, ((IGregTechTileEntity)tTileEntity).getCoverIDAtSide(j), ((IGregTechTileEntity)tTileEntity).getCoverDataAtSide(j), (IGregTechTileEntity)tTileEntity))) {
                        this.mConnections = (byte)(this.mConnections | 1 << i);
                        continue;
                    }
                    if (tTileEntity instanceof IEnergySink && ((IEnergySink)tTileEntity).acceptsEnergyFrom((TileEntity)aBaseMetaTileEntity, ForgeDirection.getOrientation((int)j))) {
                        this.mConnections = (byte)(this.mConnections | 1 << i);
                        continue;
                    }
                    if (!GregTech_API.mOutputRF || !(tTileEntity instanceof IEnergyReceiver) || !((IEnergyReceiver)tTileEntity).canConnectEnergy(ForgeDirection.getOrientation((int)j))) continue;
                    this.mConnections = (byte)(this.mConnections | 1 << i);
                }
            }
        } else if (aBaseMetaTileEntity.isClientSide() && GT_Client.changeDetected == 4) {
            aBaseMetaTileEntity.issueTextureUpdate();
        }
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Max Voltage: %%%" + EnumChatFormatting.GREEN + this.mVoltage + " (" + GT_Values.VN[GT_Utility.getTier(this.mVoltage)] + ")" + EnumChatFormatting.GRAY, "Max Amperage: %%%" + EnumChatFormatting.YELLOW + this.mAmperage + EnumChatFormatting.GRAY, "Loss/Meter/Ampere: %%%" + EnumChatFormatting.RED + this.mCableLossPerMeter + EnumChatFormatting.GRAY + "%%% EU-Volt"};
    }

    @Override
    public float getThickNess() {
        if (GT_Mod.instance.isClientSide() && GT_Client.hideValue == 1) {
            return 0.0625f;
        }
        return this.mThickNess;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
    }
}

