/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import net.minecraft.nbt.NBTTagCompound;

public abstract class GT_MetaTileEntity_Hatch
extends GT_MetaTileEntity_BasicTank {
    @Deprecated
    public byte mMachineBlock = 0;
    private byte mTexturePage = 0;
    private byte actualTexture = 0;

    public GT_MetaTileEntity_Hatch(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Hatch(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String[] aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Hatch(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Hatch(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public static int getSlots(int aTier) {
        return aTier < 1 ? 1 : (aTier == 1 ? 4 : (aTier == 2 ? 9 : 16));
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    public abstract ITexture[] getTexturesActive(ITexture var1);

    public abstract ITexture[] getTexturesInactive(ITexture var1);

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        int textureIndex = this.actualTexture | this.mTexturePage << 7;
        byte texturePointer = (byte)(this.actualTexture & 0x7F);
        if (aSide != aFacing) {
            if (textureIndex > 0) {
                ITexture[] iTextureArray2 = new ITexture[1];
                iTextureArray = iTextureArray2;
                iTextureArray2[0] = Textures.BlockIcons.casingTexturePages[this.mTexturePage][texturePointer];
            } else {
                ITexture[] iTextureArray3 = new ITexture[1];
                iTextureArray = iTextureArray3;
                iTextureArray3[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
            }
        } else {
            iTextureArray = textureIndex > 0 ? (aActive ? this.getTexturesActive(Textures.BlockIcons.casingTexturePages[this.mTexturePage][texturePointer]) : this.getTexturesInactive(Textures.BlockIcons.casingTexturePages[this.mTexturePage][texturePointer])) : (aActive ? this.getTexturesActive(Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1]) : this.getTexturesInactive(Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1]));
        }
        return iTextureArray;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("mMachineBlock", this.actualTexture);
        aNBT.func_74774_a("mTexturePage", this.mTexturePage);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.actualTexture = aNBT.func_74771_c("mMachineBlock");
        this.mTexturePage = aNBT.func_74771_c("mTexturePage");
        if (this.mTexturePage != 0 && GT_Values.GT.isServerSide()) {
            this.actualTexture = (byte)(this.actualTexture | 0x80);
        }
        this.mMachineBlock = this.actualTexture;
    }

    public final void updateTexture(int textureIndex) {
        this.onValueUpdate((byte)textureIndex);
        this.onTexturePageUpdate((byte)(textureIndex >> 7));
    }

    public final void updateTexture(byte texturePage, byte machineBlock) {
        this.onValueUpdate(machineBlock);
        this.onTexturePageUpdate(texturePage);
    }

    @Override
    public final void onValueUpdate(byte aValue) {
        this.mMachineBlock = this.actualTexture = (byte)(aValue & 0x7F);
        this.mTexturePage = 0;
    }

    @Override
    public final byte getUpdateData() {
        return (byte)(this.actualTexture & 0x7F);
    }

    public final void onTexturePageUpdate(byte aValue) {
        this.mTexturePage = (byte)(aValue & 0x7F);
        if (this.mTexturePage != 0 && this.getBaseMetaTileEntity().isServerSide()) {
            this.actualTexture = this.mMachineBlock = (byte)(this.mMachineBlock | 0x80);
        }
    }

    public final byte getTexturePage() {
        return (byte)(this.mTexturePage & 0x7F);
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return false;
    }

    @Override
    public boolean canTankBeEmptied() {
        return false;
    }

    @Override
    public boolean displaysItemStack() {
        return false;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.actualTexture != this.mMachineBlock) {
            this.mMachineBlock = this.actualTexture = (byte)(this.mMachineBlock & 0x7F);
            this.mTexturePage = 0;
        }
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }
}

