/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ProgressManager;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OreDictNames;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TC_Aspects;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.IProjectileItem;
import gregtech.api.interfaces.internal.IGT_Mod;
import gregtech.api.interfaces.internal.IThaumcraftCompat;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Item;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.net.GT_Packet_Pollution;
import gregtech.api.objects.GT_Fluid;
import gregtech.api.objects.GT_FluidStack;
import gregtech.api.objects.GT_UO_DimensionList;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeRegistrator;
import gregtech.api.util.GT_Shaped_Recipe;
import gregtech.api.util.GT_Shapeless_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_PlayerActivityLogger;
import gregtech.common.GT_Pollution;
import gregtech.common.entities.GT_Entity_Arrow;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gregtech.common.items.armor.ModularArmor_Item;
import gregtech.common.items.armor.gui.ContainerBasicArmor;
import gregtech.common.items.armor.gui.ContainerElectricArmor1;
import gregtech.common.items.armor.gui.GuiElectricArmor1;
import gregtech.common.items.armor.gui.GuiModularArmor;
import gregtech.common.items.armor.gui.InventoryArmor;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public abstract class GT_Proxy
implements IGT_Mod,
IGuiHandler,
IFuelHandler {
    private static final EnumSet<OreGenEvent.GenerateMinable.EventType> PREVENTED_ORES = EnumSet.of(OreGenEvent.GenerateMinable.EventType.COAL, new OreGenEvent.GenerateMinable.EventType[]{OreGenEvent.GenerateMinable.EventType.IRON, OreGenEvent.GenerateMinable.EventType.GOLD, OreGenEvent.GenerateMinable.EventType.DIAMOND, OreGenEvent.GenerateMinable.EventType.REDSTONE, OreGenEvent.GenerateMinable.EventType.LAPIS, OreGenEvent.GenerateMinable.EventType.QUARTZ});
    public final HashSet<ItemStack> mRegisteredOres = new HashSet(10000);
    public final ArrayList<String> mSoundNames = new ArrayList();
    public final ArrayList<ItemStack> mSoundItems = new ArrayList();
    public final ArrayList<Integer> mSoundCounts = new ArrayList();
    private final Collection<OreDictEventContainer> mEvents = new HashSet<OreDictEventContainer>();
    private final Collection<String> mIgnoredItems = new HashSet<String>(Arrays.asList("itemGhastTear", "itemFlint", "itemClay", "itemBucketSaltWater", "itemBucketFreshWater", "itemBucketWater", "itemRock", "itemReed", "itemArrow", "itemSaw", "itemKnife", "itemHammer", "itemChisel", "itemRubber", "itemEssence", "itemIlluminatedPanel", "itemSkull", "itemRawRubber", "itemBacon", "itemJetpackAccelerator", "itemLazurite", "itemIridium", "itemTear", "itemClaw", "itemFertilizer", "itemTar", "itemSlimeball", "itemCoke", "itemBeeswax", "itemBeeQueen", "itemForcicium", "itemForcillium", "itemRoyalJelly", "itemHoneydew", "itemHoney", "itemPollen", "itemReedTypha", "itemSulfuricAcid", "itemPotash", "itemCompressedCarbon", "itemBitumen", "itemBioFuel", "itemCokeSugar", "itemCokeCactus", "itemCharcoalSugar", "itemCharcoalCactus", "itemSludge", "itemEnrichedAlloy", "itemQuicksilver", "itemMercury", "itemOsmium", "itemUltimateCircuit", "itemEnergizedStar", "itemAntimatterMolecule", "itemAntimatterGlob", "itemCoal", "itemBoat", "itemHerbalMedicineCake", "itemCakeSponge", "itemFishandPumpkinCakeSponge", "itemSoulCleaver", "itemInstantCake", "itemWhippingCream", "itemGlisteningWhippingCream", "itemCleaver", "itemHerbalMedicineWhippingCream", "itemStrangeWhippingCream", "itemBlazeCleaver", "itemBakedCakeSponge", "itemMagmaCake", "itemGlisteningCake", "itemOgreCleaver", "itemFishandPumpkinCake", "itemMagmaWhippingCream", "itemMultimeter", "itemSuperconductor"));
    private final Collection<String> mIgnoredNames = new HashSet<String>(Arrays.asList("grubBee", "chainLink", "candyCane", "bRedString", "bVial", "bFlask", "anorthositeSmooth", "migmatiteSmooth", "slateSmooth", "travertineSmooth", "limestoneSmooth", "orthogneissSmooth", "marbleSmooth", "honeyDrop", "lumpClay", "honeyEqualssugar", "flourEqualswheat", "bluestoneInsulated", "blockWaterstone", "blockSand", "blockTorch", "blockPumpkin", "blockClothRock", "blockStainedHardenedClay", "blockQuartzPillar", "blockQuartzChiselled", "blockSpawner", "blockCloth", "mobHead", "mobEgg", "enderFlower", "enderChest", "clayHardened", "dayGemMaterial", "nightGemMaterial", "snowLayer", "bPlaceholder", "hardenedClay", "eternalLifeEssence", "sandstone", "wheatRice", "transdimBlock", "bambooBasket", "lexicaBotania", "livingwoodTwig", "redstoneCrystal", "pestleAndMortar", "glowstone", "whiteStone", "stoneSlab", "transdimBlock", "clayBowl", "clayPlate", "ceramicBowl", "ceramicPlate", "ovenRack", "clayCup", "ceramicCup", "batteryBox", "transmutationStone", "torchRedstoneActive", "coal", "charcoal", "cloth", "cobblestoneSlab", "stoneBrickSlab", "cobblestoneWall", "stoneBrickWall", "cobblestoneStair", "stoneBrickStair", "blockCloud", "blockDirt", "blockTyrian", "blockCarpet", "blockFft", "blockLavastone", "blockHolystone", "blockConcrete", "sunnariumPart", "brSmallMachineCyaniteProcessor", "meteoriteCoal", "blockCobble", "pressOreProcessor", "crusherOreProcessor", "grinderOreProcessor", "blockRubber", "blockHoney", "blockHoneydew", "blockPeat", "blockRadioactive", "blockSlime", "blockCocoa", "blockSugarCane", "blockLeather", "blockClayBrick", "solarPanelHV", "cableRedNet", "stoneBowl", "crafterWood", "taintedSoil", "brickXyEngineering", "breederUranium", "wireMill", "chunkLazurite", "aluminumNatural", "aluminiumNatural", "naturalAluminum", "naturalAluminium", "antimatterMilligram", "antimatterGram", "strangeMatter", "coalGenerator", "electricFurnace", "unfinishedTank", "valvePart", "aquaRegia", "leatherSeal", "leatherSlimeSeal", "hambone", "slimeball", "clay", "enrichedUranium", "camoPaste", "antiBlock", "burntQuartz", "salmonRaw", "blockHopper", "blockEnderObsidian", "blockIcestone", "blockMagicWood", "blockEnderCore", "blockHeeEndium", "oreHeeEndPowder", "oreHeeStardust", "oreHeeIgneousRock", "oreHeeInstabilityOrb", "crystalPureFluix", "shardNether", "gemFluorite", "stickObsidian", "caveCrystal", "shardCrystal", "dyeCrystal", "shardFire", "shardWater", "shardAir", "shardEarth", "ingotRefinedIron", "blockMarble", "ingotUnstable"));
    private final Collection<String> mInvalidNames = new HashSet<String>(Arrays.asList("diamondShard", "redstoneRoot", "obsidianStick", "bloodstoneOre", "universalCable", "bronzeTube", "ironTube", "netherTube", "obbyTube", "infiniteBattery", "eliteBattery", "advancedBattery", "10kEUStore", "blueDye", "MonazitOre", "quartzCrystal", "whiteLuminiteCrystal", "darkStoneIngot", "invisiumIngot", "demoniteOrb", "enderGem", "starconiumGem", "osmoniumIngot", "tapaziteGem", "zectiumIngot", "foolsRubyGem", "rubyGem", "meteoriteGem", "adamiteShard", "sapphireGem", "copperIngot", "ironStick", "goldStick", "diamondStick", "reinforcedStick", "draconicStick", "emeraldStick", "copperStick", "tinStick", "silverStick", "bronzeStick", "steelStick", "leadStick", "manyullynStick", "arditeStick", "cobaltStick", "aluminiumStick", "alumiteStick", "oilsandsOre", "copperWire", "superconductorWire", "sulfuricAcid", "conveyorBelt", "ironWire", "aluminumWire", "aluminiumWire", "silverWire", "tinWire", "dustSiliconSmall", "AluminumOre", "plateHeavyT2", "blockWool", "alloyPlateEnergizedHardened", "gasWood", "alloyPlateEnergized", "SilverOre", "LeadOre", "TinOre", "CopperOre", "silverOre", "leadOre", "tinOre", "copperOre", "bauxiteOre", "HSLivingmetalIngot", "oilMoving", "oilStill", "oilBucket", "petroleumOre", "dieselFuel", "diamondNugget", "planks", "wood", "stick", "sticks", "naquadah", "obsidianRod", "stoneRod", "thaumiumRod", "steelRod", "netherrackRod", "woodRod", "ironRod", "cactusRod", "flintRod", "copperRod", "cobaltRod", "alumiteRod", "blueslimeRod", "arditeRod", "manyullynRod", "bronzeRod", "boneRod", "slimeRod", "redalloyBundled", "bluestoneBundled", "infusedteslatiteInsulated", "redalloyInsulated", "infusedteslatiteBundled"));
    private final DateFormat mDateFormat = DateFormat.getInstance();
    public ArrayList<String> mBufferedPlayerActivity = new ArrayList();
    public boolean mHardcoreCables = false;
    public boolean mDisableVanillaOres = true;
    public boolean mNerfDustCrafting = true;
    public boolean mSortToTheEnd = true;
    public boolean mCraftingUnification = true;
    public boolean mInventoryUnification = true;
    public boolean mIncreaseDungeonLoot = true;
    public boolean mAxeWhenAdventure = true;
    public boolean mSurvivalIntoAdventure = false;
    public boolean mNerfedWoodPlank = true;
    public boolean mNerfedVanillaTools = true;
    public boolean mHardRock = false;
    public boolean mHungerEffect = true;
    public boolean mOnline = true;
    public boolean mIgnoreTcon = true;
    public boolean mDisableIC2Cables = false;
    public boolean mAchievements = true;
    public boolean mAE2Integration = true;
    public boolean mAE2Tunnel = true;
    public boolean mArcSmeltIntoAnnealed = true;
    public boolean mMagneticraftRecipes = true;
    public boolean mImmersiveEngineeringRecipes = true;
    private boolean isFirstServerWorldTick = true;
    private boolean mOreDictActivated = false;
    public boolean mChangeHarvestLevels = false;
    public boolean mNerfedCombs = true;
    public boolean mNerfedCrops = true;
    public boolean mGTBees = true;
    public boolean mHideUnusedOres = true;
    public boolean mHideRecyclingRecipes = true;
    public boolean mPollution = true;
    public boolean mExplosionItemDrop = false;
    public int mSkeletonsShootGTArrows = 16;
    public int mMaxEqualEntitiesAtOneSpot = 3;
    public int mFlintChance = 30;
    public int mItemDespawnTime = 6000;
    public int mUpgradeCount = 4;
    public int[] mHarvestLevel = new int[1000];
    public int mGraniteHavestLevel = 3;
    public int mMaxHarvestLevel = 7;
    public int mWireHeatingTicks = 4;
    public int mPollutionSmogLimit = 500000;
    public int mPollutionPoisonLimit = 750000;
    public int mPollutionVegetationLimit = 1000000;
    public int mPollutionSourRainLimit = 2000000;
    public final GT_UO_DimensionList mUndergroundOil = new GT_UO_DimensionList();
    public int mTicksUntilNextCraftSound = 0;
    public double mMagneticraftBonusOutputPercent = 100.0;
    private World mUniverse = null;
    private final String aTextThermalExpansion = "ThermalExpansion";
    private final String aTextRailcraft = "Railcraft";
    private final String aTextTwilightForest = "TwilightForest";
    private final String aTextForestry = "Forestry";
    private final String aTextArsmagica2 = "arsmagica2";
    public boolean mTEMachineRecipes = false;
    public boolean mEnableAllMaterials = false;
    public boolean mEnableAllComponents = false;
    public boolean mAddGTRecipesToIC2Machines = true;
    public boolean mEnableCleanroom = true;
    public boolean mLowGravProcessing = false;
    public boolean mAprilFool = false;
    public boolean mCropNeedBlock = true;
    public boolean mDisableOldChemicalRecipes = false;
    public boolean mAMHInteraction = true;
    public boolean mForceFreeFace = false;
    public boolean mEasierIVPlusCables = false;
    public boolean mBrickedBlastFurnace = true;
    public boolean mMixedOreOnlyYieldsTwoThirdsOfPureOre = false;
    public boolean enableBlackGraniteOres = true;
    public boolean enableRedGraniteOres = true;
    public boolean enableMarbleOres = true;
    public boolean enableBasaltOres = true;
    public boolean enableGCOres = true;
    public boolean enableUBOres = true;
    public static long tBits = GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED | GT_ModHandler.RecipeBits.ONLY_ADD_IF_RESULT_IS_NOT_NULL | GT_ModHandler.RecipeBits.NOT_REMOVABLE;
    public static final HashMap<Integer, HashMap<ChunkCoordIntPair, int[]>> dimensionWiseChunkData = new HashMap(16);
    public static final HashMap<Integer, GT_Pollution> dimensionWisePollution = new HashMap(16);
    public static final byte GTOIL = 3;
    public static final byte GTOILFLUID = 2;
    public static final byte GTPOLLUTION = 1;
    public static final byte GTMETADATA = 0;
    public static final byte NOT_LOADED = 0;
    public static final byte LOADED = 1;
    private static final byte oilVer = 20;

    public GT_Proxy() {
        GameRegistry.registerFuelHandler((IFuelHandler)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.ORE_GEN_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        GregTech_API.sThaumcraftCompat = (IThaumcraftCompat)GT_Utility.callConstructor("gregtech.common.GT_ThaumcraftCompat", 0, null, GT_Values.D1, new Object[0]);
        for (FluidContainerRegistry.FluidContainerData fluidContainerData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            this.onFluidContainerRegistration(new FluidContainerRegistry.FluidContainerRegisterEvent(fluidContainerData));
        }
        try {
            for (String string : OreDictionary.getOreNames()) {
                for (ItemStack tOreStack : OreDictionary.getOres((String)string)) {
                    this.registerOre(new OreDictionary.OreRegisterEvent(string, tOreStack));
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(GT_Log.err);
        }
    }

    private static final void registerRecipes(OreDictEventContainer aOre) {
        if (aOre.mEvent.Ore == null || aOre.mEvent.Ore.func_77973_b() == null) {
            return;
        }
        if (aOre.mEvent.Ore.field_77994_a != 1) {
            aOre.mEvent.Ore.field_77994_a = 1;
        }
        if (aOre.mPrefix != null && !aOre.mPrefix.isIgnored(aOre.mMaterial)) {
            aOre.mPrefix.processOre(aOre.mMaterial == null ? Materials._NULL : aOre.mMaterial, aOre.mEvent.Name, aOre.mModID, GT_Utility.copyAmount(1L, aOre.mEvent.Ore));
        }
    }

    public void onPreLoad() {
        GT_Log.out.println("GT_Mod: Preload-Phase started!");
        GT_Log.ore.println("GT_Mod: Preload-Phase started!");
        GregTech_API.sPreloadStarted = true;
        this.mIgnoreTcon = GregTech_API.sOPStuff.get((Object)ConfigCategories.general, "ignoreTConstruct", true);
        this.mWireHeatingTicks = GregTech_API.sOPStuff.get((Object)ConfigCategories.general, "WireHeatingTicks", 4);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)GT_Values.GT, (IGuiHandler)this);
        for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (tData.filledContainer.func_77973_b() != Items.field_151068_bn || tData.filledContainer.func_77960_j() != 0) continue;
            tData.fluid.amount = 0;
            break;
        }
        GT_Log.out.println("GT_Mod: Getting required Items of other Mods.");
        ItemList.TE_Slag.set(GT_ModHandler.getModItem("ThermalExpansion", "slag", 1L));
        ItemList.TE_Slag_Rich.set(GT_ModHandler.getModItem("ThermalExpansion", "slagRich", 1L));
        ItemList.TE_Rockwool.set(GT_ModHandler.getModItem("ThermalExpansion", "rockwool", 1L));
        ItemList.TE_Hardened_Glass.set(GT_ModHandler.getModItem("ThermalExpansion", "glassHardened", 1L));
        ItemList.RC_ShuntingWire.set(GT_ModHandler.getModItem("Railcraft", "tile.railcraft.machine.delta", 1L, 0));
        ItemList.RC_ShuntingWireFrame.set(GT_ModHandler.getModItem("Railcraft", "tile.railcraft.frame", 1L, 0));
        ItemList.RC_Rail_Standard.set(GT_ModHandler.getModItem("Railcraft", "part.rail", 1L, 0));
        ItemList.RC_Rail_Adv.set(GT_ModHandler.getModItem("Railcraft", "part.rail", 1L, 1));
        ItemList.RC_Rail_Wooden.set(GT_ModHandler.getModItem("Railcraft", "part.rail", 1L, 2));
        ItemList.RC_Rail_HS.set(GT_ModHandler.getModItem("Railcraft", "part.rail", 1L, 3));
        ItemList.RC_Rail_Reinforced.set(GT_ModHandler.getModItem("Railcraft", "part.rail", 1L, 4));
        ItemList.RC_Rail_Electric.set(GT_ModHandler.getModItem("Railcraft", "part.rail", 1L, 5));
        ItemList.RC_Tie_Wood.set(GT_ModHandler.getModItem("Railcraft", "part.tie", 1L, 0));
        ItemList.RC_Tie_Stone.set(GT_ModHandler.getModItem("Railcraft", "part.tie", 1L, 1));
        ItemList.RC_Bed_Wood.set(GT_ModHandler.getModItem("Railcraft", "part.railbed", 1L, 0));
        ItemList.RC_Bed_Stone.set(GT_ModHandler.getModItem("Railcraft", "part.railbed", 1L, 1));
        ItemList.RC_Rebar.set(GT_ModHandler.getModItem("Railcraft", "part.rebar", 1L));
        ItemList.Tool_Sword_Steel.set(GT_ModHandler.getModItem("Railcraft", "tool.steel.sword", 1L));
        ItemList.Tool_Pickaxe_Steel.set(GT_ModHandler.getModItem("Railcraft", "tool.steel.pickaxe", 1L));
        ItemList.Tool_Shovel_Steel.set(GT_ModHandler.getModItem("Railcraft", "tool.steel.shovel", 1L));
        ItemList.Tool_Axe_Steel.set(GT_ModHandler.getModItem("Railcraft", "tool.steel.axe", 1L));
        ItemList.Tool_Hoe_Steel.set(GT_ModHandler.getModItem("Railcraft", "tool.steel.hoe", 1L));
        ItemList.TF_LiveRoot.set(GT_ModHandler.getModItem("TwilightForest", "item.liveRoot", 1L, 0));
        ItemList.TF_Vial_FieryBlood.set(GT_ModHandler.getModItem("TwilightForest", "item.fieryBlood", 1L));
        ItemList.TF_Vial_FieryTears.set(GT_ModHandler.getModItem("TwilightForest", "item.fieryTears", 1L));
        ItemList.FR_Lemon.set(GT_ModHandler.getModItem("Forestry", "fruits", 1L, 3));
        ItemList.FR_Mulch.set(GT_ModHandler.getModItem("Forestry", "mulch", 1L));
        ItemList.FR_Fertilizer.set(GT_ModHandler.getModItem("Forestry", "fertilizerCompound", 1L));
        ItemList.FR_Compost.set(GT_ModHandler.getModItem("Forestry", "fertilizerBio", 1L));
        ItemList.FR_Silk.set(GT_ModHandler.getModItem("Forestry", "craftingMaterial", 1L, 2));
        ItemList.FR_Wax.set(GT_ModHandler.getModItem("Forestry", "beeswax", 1L));
        ItemList.FR_WaxCapsule.set(GT_ModHandler.getModItem("Forestry", "waxCapsule", 1L));
        ItemList.FR_RefractoryWax.set(GT_ModHandler.getModItem("Forestry", "refractoryWax", 1L));
        ItemList.FR_RefractoryCapsule.set(GT_ModHandler.getModItem("Forestry", "refractoryEmpty", 1L));
        ItemList.FR_Bee_Drone.set(GT_ModHandler.getModItem("Forestry", "beeDroneGE", 1L));
        ItemList.FR_Bee_Princess.set(GT_ModHandler.getModItem("Forestry", "beePrincessGE", 1L));
        ItemList.FR_Bee_Queen.set(GT_ModHandler.getModItem("Forestry", "beeQueenGE", 1L));
        ItemList.FR_Tree_Sapling.set(GT_ModHandler.getModItem("Forestry", "sapling", 1L, GT_ModHandler.getModItem("Forestry", "saplingGE", 1L)));
        ItemList.FR_Butterfly.set(GT_ModHandler.getModItem("Forestry", "butterflyGE", 1L));
        ItemList.FR_Larvae.set(GT_ModHandler.getModItem("Forestry", "beeLarvaeGE", 1L));
        ItemList.FR_Serum.set(GT_ModHandler.getModItem("Forestry", "serumGE", 1L));
        ItemList.FR_Caterpillar.set(GT_ModHandler.getModItem("Forestry", "caterpillarGE", 1L));
        ItemList.FR_PollenFertile.set(GT_ModHandler.getModItem("Forestry", "pollenFertile", 1L));
        ItemList.FR_Stick.set(GT_ModHandler.getModItem("Forestry", "oakStick", 1L));
        ItemList.FR_Casing_Impregnated.set(GT_ModHandler.getModItem("Forestry", "impregnatedCasing", 1L));
        ItemList.FR_Casing_Sturdy.set(GT_ModHandler.getModItem("Forestry", "sturdyMachine", 1L));
        ItemList.FR_Casing_Hardened.set(GT_ModHandler.getModItem("Forestry", "hardenedMachine", 1L));
        ItemList.Bottle_Empty.set(new ItemStack(Items.field_151069_bo, 1));
        ItemList.Cell_Universal_Fluid.set(GT_ModHandler.getIC2Item("FluidCell", 1L));
        ItemList.Cell_Empty.set(GT_ModHandler.getIC2Item("cell", 1L, GT_ModHandler.getIC2Item("cellEmpty", 1L, GT_ModHandler.getIC2Item("emptyCell", 1L))));
        ItemList.Cell_Water.set(GT_ModHandler.getIC2Item("waterCell", 1L, GT_ModHandler.getIC2Item("cellWater", 1L)));
        ItemList.Cell_Lava.set(GT_ModHandler.getIC2Item("lavaCell", 1L, GT_ModHandler.getIC2Item("cellLava", 1L)));
        ItemList.Cell_Air.set(GT_ModHandler.getIC2Item("airCell", 1L, GT_ModHandler.getIC2Item("cellAir", 1L, GT_ModHandler.getIC2Item("cellOxygen", 1L))));
        ItemList.IC2_Item_Casing_Iron.set(GT_ModHandler.getIC2Item("casingiron", 1L));
        ItemList.IC2_Item_Casing_Gold.set(GT_ModHandler.getIC2Item("casinggold", 1L));
        ItemList.IC2_Item_Casing_Bronze.set(GT_ModHandler.getIC2Item("casingbronze", 1L));
        ItemList.IC2_Item_Casing_Copper.set(GT_ModHandler.getIC2Item("casingcopper", 1L));
        ItemList.IC2_Item_Casing_Tin.set(GT_ModHandler.getIC2Item("casingtin", 1L));
        ItemList.IC2_Item_Casing_Lead.set(GT_ModHandler.getIC2Item("casinglead", 1L));
        ItemList.IC2_Item_Casing_Steel.set(GT_ModHandler.getIC2Item("casingadviron", 1L));
        ItemList.IC2_Spray_WeedEx.set(GT_ModHandler.getIC2Item("weedEx", 1L));
        ItemList.IC2_Fuel_Can_Empty.set(GT_ModHandler.getIC2Item("fuelCan", 1L, GT_ModHandler.getIC2Item("fuelCanEmpty", 1L, GT_ModHandler.getIC2Item("emptyFuelCan", 1L))));
        ItemList.IC2_Fuel_Can_Filled.set(GT_ModHandler.getIC2Item("filledFuelCan", 1L));
        ItemList.IC2_Mixed_Metal_Ingot.set(GT_ModHandler.getIC2Item("mixedMetalIngot", 1L));
        ItemList.IC2_Fertilizer.set(GT_ModHandler.getIC2Item("fertilizer", 1L));
        ItemList.IC2_CoffeeBeans.set(GT_ModHandler.getIC2Item("coffeeBeans", 1L));
        ItemList.IC2_CoffeePowder.set(GT_ModHandler.getIC2Item("coffeePowder", 1L));
        ItemList.IC2_Hops.set(GT_ModHandler.getIC2Item("hops", 1L));
        ItemList.IC2_Resin.set(GT_ModHandler.getIC2Item("resin", 1L));
        ItemList.IC2_Plantball.set(GT_ModHandler.getIC2Item("plantBall", 1L));
        ItemList.IC2_PlantballCompressed.set(GT_ModHandler.getIC2Item("compressedPlantBall", 1L, ItemList.IC2_Plantball.get(1L, new Object[0])));
        ItemList.IC2_Crop_Seeds.set(GT_ModHandler.getIC2Item("cropSeed", 1L));
        ItemList.IC2_Grin_Powder.set(GT_ModHandler.getIC2Item("grinPowder", 1L));
        ItemList.IC2_Energium_Dust.set(GT_ModHandler.getIC2Item("energiumDust", 1L));
        ItemList.IC2_Scrap.set(GT_ModHandler.getIC2Item("scrap", 1L));
        ItemList.IC2_Scrapbox.set(GT_ModHandler.getIC2Item("scrapBox", 1L));
        ItemList.IC2_Fuel_Rod_Empty.set(GT_ModHandler.getIC2Item("fuelRod", 1L));
        ItemList.IC2_Food_Can_Empty.set(GT_ModHandler.getIC2Item("tinCan", 1L));
        ItemList.IC2_Food_Can_Filled.set(GT_ModHandler.getIC2Item("filledTinCan", 1L, 0));
        ItemList.IC2_Food_Can_Spoiled.set(GT_ModHandler.getIC2Item("filledTinCan", 1L, 1));
        ItemList.IC2_Industrial_Diamond.set(GT_ModHandler.getIC2Item("industrialDiamond", 1L, new ItemStack(Items.field_151045_i, 1)));
        ItemList.IC2_Compressed_Coal_Ball.set(GT_ModHandler.getIC2Item("compressedCoalBall", 1L));
        ItemList.IC2_Compressed_Coal_Chunk.set(GT_ModHandler.getIC2Item("coalChunk", 1L));
        ItemList.IC2_ShaftIron.set(GT_ModHandler.getIC2Item("ironshaft", 1L));
        ItemList.IC2_ShaftSteel.set(GT_ModHandler.getIC2Item("steelshaft", 1L));
        ItemList.IC2_SuBattery.set(GT_ModHandler.getIC2Item("suBattery", 1L));
        ItemList.IC2_ReBattery.set(GT_ModHandler.getIC2Item("reBattery", 1L));
        ItemList.IC2_AdvBattery.set(GT_ModHandler.getIC2Item("advBattery", 1L));
        ItemList.IC2_EnergyCrystal.set(GT_ModHandler.getIC2Item("energyCrystal", 1L));
        ItemList.IC2_LapotronCrystal.set(GT_ModHandler.getIC2Item("lapotronCrystal", 1L));
        ItemList.IC2_LapotronCrystal.set(GT_ModHandler.getIC2Item("lapotronCrystal", 1L));
        ItemList.IC2_LapotronCrystal.set(GT_ModHandler.getIC2Item("lapotronCrystal", 1L));
        ItemList.IC2_LapotronCrystal.set(GT_ModHandler.getIC2Item("lapotronCrystal", 1L));
        ItemList.Tool_Sword_Bronze.set(GT_ModHandler.getIC2Item("bronzeSword", 1L));
        ItemList.Tool_Pickaxe_Bronze.set(GT_ModHandler.getIC2Item("bronzePickaxe", 1L));
        ItemList.Tool_Shovel_Bronze.set(GT_ModHandler.getIC2Item("bronzeShovel", 1L));
        ItemList.Tool_Axe_Bronze.set(GT_ModHandler.getIC2Item("bronzeAxe", 1L));
        ItemList.Tool_Hoe_Bronze.set(GT_ModHandler.getIC2Item("bronzeHoe", 1L));
        ItemList.IC2_ForgeHammer.set(GT_ModHandler.getIC2Item("ForgeHammer", 1L));
        ItemList.IC2_WireCutter.set(GT_ModHandler.getIC2Item("cutter", 1L));
        ItemList.Credit_Iron.set(GT_ModHandler.getIC2Item("coin", 1L));
        ItemList.Circuit_Basic.set(GT_ModHandler.getIC2Item("electronicCircuit", 1L));
        ItemList.Circuit_Advanced.set(GT_ModHandler.getIC2Item("advancedCircuit", 1L));
        ItemList.Upgrade_Overclocker.set(GT_ModHandler.getIC2Item("overclockerUpgrade", 1L));
        ItemList.Upgrade_Battery.set(GT_ModHandler.getIC2Item("energyStorageUpgrade", 1L));
        ItemList.Dye_Bonemeal.set(new ItemStack(Items.field_151100_aR, 1, 15));
        ItemList.Dye_SquidInk.set(new ItemStack(Items.field_151100_aR, 1, 0));
        ItemList.Dye_Cocoa.set(new ItemStack(Items.field_151100_aR, 1, 3));
        ItemList.Book_Written_00.set(new ItemStack(Items.field_151164_bB, 1, 0));
        ItemList.Food_Baked_Bread.set(new ItemStack(Items.field_151025_P, 1, 0));
        ItemList.Food_Raw_Potato.set(new ItemStack(Items.field_151174_bG, 1, 0));
        ItemList.Food_Baked_Potato.set(new ItemStack(Items.field_151168_bH, 1, 0));
        ItemList.Food_Poisonous_Potato.set(new ItemStack(Items.field_151170_bI, 1, 0));
        OrePrefixes.bottle.mContainerItem = ItemList.Bottle_Empty.get(1L, new Object[0]);
        OrePrefixes.bucket.mContainerItem = new ItemStack(Items.field_151133_ar, 1);
        OrePrefixes.cellPlasma.mContainerItem = ItemList.Cell_Empty.get(1L, new Object[0]);
        OrePrefixes.cell.mContainerItem = ItemList.Cell_Empty.get(1L, new Object[0]);
        GregTech_API.sFrostHazmatList.add(GT_ModHandler.getIC2Item("hazmatHelmet", 1L, Short.MAX_VALUE));
        GregTech_API.sFrostHazmatList.add(GT_ModHandler.getIC2Item("hazmatChestplate", 1L, Short.MAX_VALUE));
        GregTech_API.sFrostHazmatList.add(GT_ModHandler.getIC2Item("hazmatLeggings", 1L, Short.MAX_VALUE));
        GregTech_API.sFrostHazmatList.add(GT_ModHandler.getIC2Item("hazmatBoots", 1L, Short.MAX_VALUE));
        GregTech_API.sHeatHazmatList.add(GT_ModHandler.getIC2Item("hazmatHelmet", 1L, Short.MAX_VALUE));
        GregTech_API.sHeatHazmatList.add(GT_ModHandler.getIC2Item("hazmatChestplate", 1L, Short.MAX_VALUE));
        GregTech_API.sHeatHazmatList.add(GT_ModHandler.getIC2Item("hazmatLeggings", 1L, Short.MAX_VALUE));
        GregTech_API.sHeatHazmatList.add(GT_ModHandler.getIC2Item("hazmatBoots", 1L, Short.MAX_VALUE));
        GregTech_API.sBioHazmatList.add(GT_ModHandler.getIC2Item("hazmatHelmet", 1L, Short.MAX_VALUE));
        GregTech_API.sBioHazmatList.add(GT_ModHandler.getIC2Item("hazmatChestplate", 1L, Short.MAX_VALUE));
        GregTech_API.sBioHazmatList.add(GT_ModHandler.getIC2Item("hazmatLeggings", 1L, Short.MAX_VALUE));
        GregTech_API.sBioHazmatList.add(GT_ModHandler.getIC2Item("hazmatBoots", 1L, Short.MAX_VALUE));
        GregTech_API.sGasHazmatList.add(GT_ModHandler.getIC2Item("hazmatHelmet", 1L, Short.MAX_VALUE));
        GregTech_API.sGasHazmatList.add(GT_ModHandler.getIC2Item("hazmatChestplate", 1L, Short.MAX_VALUE));
        GregTech_API.sGasHazmatList.add(GT_ModHandler.getIC2Item("hazmatLeggings", 1L, Short.MAX_VALUE));
        GregTech_API.sGasHazmatList.add(GT_ModHandler.getIC2Item("hazmatBoots", 1L, Short.MAX_VALUE));
        GregTech_API.sRadioHazmatList.add(GT_ModHandler.getIC2Item("hazmatHelmet", 1L, Short.MAX_VALUE));
        GregTech_API.sRadioHazmatList.add(GT_ModHandler.getIC2Item("hazmatChestplate", 1L, Short.MAX_VALUE));
        GregTech_API.sRadioHazmatList.add(GT_ModHandler.getIC2Item("hazmatLeggings", 1L, Short.MAX_VALUE));
        GregTech_API.sRadioHazmatList.add(GT_ModHandler.getIC2Item("hazmatBoots", 1L, Short.MAX_VALUE));
        GregTech_API.sElectroHazmatList.add(GT_ModHandler.getIC2Item("hazmatHelmet", 1L, Short.MAX_VALUE));
        GregTech_API.sElectroHazmatList.add(GT_ModHandler.getIC2Item("hazmatChestplate", 1L, Short.MAX_VALUE));
        GregTech_API.sElectroHazmatList.add(GT_ModHandler.getIC2Item("hazmatLeggings", 1L, Short.MAX_VALUE));
        GregTech_API.sElectroHazmatList.add(GT_ModHandler.getIC2Item("hazmatBoots", 1L, Short.MAX_VALUE));
        GregTech_API.sElectroHazmatList.add(new ItemStack((Item)Items.field_151020_U, 1, Short.MAX_VALUE));
        GregTech_API.sElectroHazmatList.add(new ItemStack((Item)Items.field_151023_V, 1, Short.MAX_VALUE));
        GregTech_API.sElectroHazmatList.add(new ItemStack((Item)Items.field_151022_W, 1, Short.MAX_VALUE));
        GregTech_API.sElectroHazmatList.add(new ItemStack((Item)Items.field_151029_X, 1, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(new ItemStack((Item)Items.field_151031_f, 1, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(new ItemStack((Item)Items.field_151112_aM, 1, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(ItemList.IC2_ForgeHammer.getWithDamage(1L, 32767L, new Object[0]));
        GT_ModHandler.sNonReplaceableItems.add(ItemList.IC2_WireCutter.getWithDamage(1L, 32767L, new Object[0]));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("painter", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("blackPainter", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("redPainter", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("greenPainter", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("brownPainter", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("bluePainter", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("purplePainter", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("cyanPainter", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("lightGreyPainter", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("darkGreyPainter", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("pinkPainter", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("limePainter", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("yellowPainter", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("cloudPainter", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("magentaPainter", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("orangePainter", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("whitePainter", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("cfPack", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("jetpack", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("treetap", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("weedEx", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("staticBoots", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("compositeArmor", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("hazmatHelmet", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("hazmatChestplate", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("hazmatLeggings", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getIC2Item("hazmatBoots", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("Railcraft", "part.turbine.disk", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("Railcraft", "part.turbine.blade", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("Railcraft", "part.turbine.rotor", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("Railcraft", "borehead.diamond", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("Railcraft", "borehead.steel", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("Railcraft", "borehead.iron", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("TwilightForest", "item.plateNaga", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("TwilightForest", "item.legsNaga", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("TwilightForest", "item.arcticHelm", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("TwilightForest", "item.arcticPlate", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("TwilightForest", "item.arcticLegs", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("TwilightForest", "item.arcticBoots", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("TwilightForest", "item.yetiHelm", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("TwilightForest", "item.yetiPlate", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("TwilightForest", "item.yetiLegs", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("TwilightForest", "item.yetiBoots", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("appliedenergistics2", "item.ToolCertusQuartzCuttingKnife", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("appliedenergistics2", "item.ToolNetherQuartzCuttingKnife", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("Forestry", "apiaristHelmet", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("Forestry", "apiaristChest", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("Forestry", "apiaristLegs", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("Forestry", "apiaristBoots", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("Forestry", "frameUntreated", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("Forestry", "frameImpregnated", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("Forestry", "frameProven", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("Forestry", "waxCast", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("GalacticraftCore", "item.sensorGlasses", 1L, Short.MAX_VALUE));
        GT_ModHandler.sNonReplaceableItems.add(GT_ModHandler.getModItem("IC2NuclearControl", "ItemToolThermometer", 1L, Short.MAX_VALUE));
        RecipeSorter.register((String)"gregtech:shaped", GT_Shaped_Recipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped before:minecraft:shapeless");
        RecipeSorter.register((String)"gregtech:shapeless", GT_Shapeless_Recipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
    }

    public void onLoad() {
        GT_Log.out.println("GT_Mod: Beginning Load-Phase.");
        GT_Log.ore.println("GT_Mod: Beginning Load-Phase.");
        GT_OreDictUnificator.registerOre("cropChilipepper", GT_ModHandler.getModItem("magicalcrops", "magicalcrops_CropProduce", 1L, 2));
        GT_OreDictUnificator.registerOre("cropTomato", GT_ModHandler.getModItem("magicalcrops", "magicalcrops_CropProduce", 1L, 8));
        GT_OreDictUnificator.registerOre("cropGrape", GT_ModHandler.getModItem("magicalcrops", "magicalcrops_CropProduce", 1L, 4));
        GT_OreDictUnificator.registerOre("cropTea", GT_ModHandler.getModItem("ganyssurface", "teaLeaves", 1L, 0));
        GregTech_API.sLoadStarted = true;
        for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (tData.filledContainer.func_77973_b() != Items.field_151068_bn || tData.filledContainer.func_77960_j() != 0) continue;
            tData.fluid.amount = 0;
            break;
        }
        GT_LanguageManager.writePlaceholderStrings();
    }

    public void onPostLoad() {
        GT_Log.out.println("GT_Mod: Beginning PostLoad-Phase.");
        GT_Log.ore.println("GT_Mod: Beginning PostLoad-Phase.");
        if (GT_Log.pal != null) {
            new Thread(new GT_PlayerActivityLogger()).start();
        }
        GregTech_API.sPostloadStarted = true;
        GT_OreDictUnificator.addItemData(new ItemStack(Items.field_151139_aw, 1), new ItemData(Materials.Iron, 21772800L, new MaterialStack[0]));
        GT_OreDictUnificator.addItemData(new ItemStack(Items.field_151135_aq, 1, Short.MAX_VALUE), new ItemData(Materials.Wood, 21772800L, new MaterialStack[0]));
        for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (tData.filledContainer.func_77973_b() != Items.field_151068_bn || tData.filledContainer.func_77960_j() != 0) continue;
            tData.fluid.amount = 0;
            break;
        }
        GT_Log.out.println("GT_Mod: Adding Configs specific for MetaTileEntities");
        try {
            for (int i = 1; i < GregTech_API.METATILEENTITIES.length; ++i) {
                while (i < GregTech_API.METATILEENTITIES.length) {
                    if (GregTech_API.METATILEENTITIES[i] != null) {
                        GregTech_API.METATILEENTITIES[i].onConfigLoad(GregTech_API.sMachineFile);
                    }
                    ++i;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
        GT_Log.out.println("GT_Mod: Adding Tool Usage Crafting Recipes for OreDict Items.");
        for (Materials aMaterial : Materials.values()) {
            if (!aMaterial.mUnificatable || aMaterial.mMaterialInto != aMaterial) continue;
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial.mMacerateInto, 1L), tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.crushedCentrifuged.get(aMaterial)});
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial.mMacerateInto, 1L), tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.crystalline.get(aMaterial)});
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial.mMacerateInto, 1L), tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.crystal.get(aMaterial)});
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dustPure, aMaterial.mMacerateInto, 1L), tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.crushedPurified.get(aMaterial)});
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dustPure, aMaterial.mMacerateInto, 1L), tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.cleanGravel.get(aMaterial)});
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dustPure, aMaterial.mMacerateInto, 1L), tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.reduced.get(aMaterial)});
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dustImpure, aMaterial.mMacerateInto, 1L), tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.clump.get(aMaterial)});
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dustImpure, aMaterial.mMacerateInto, 1L), tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.shard.get(aMaterial)});
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dustImpure, aMaterial.mMacerateInto, 1L), tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.crushed.get(aMaterial)});
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dustImpure, aMaterial.mMacerateInto, 1L), tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.dirtyGravel.get(aMaterial)});
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 4L), tBits, new Object[]{" X", "  ", Character.valueOf('X'), OrePrefixes.dust.get(aMaterial)});
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, 9L), tBits, new Object[]{"X ", "  ", Character.valueOf('X'), OrePrefixes.dust.get(aMaterial)});
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L), tBits, new Object[]{"XX", "XX", Character.valueOf('X'), OrePrefixes.dustSmall.get(aMaterial)});
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L), tBits, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), OrePrefixes.dustTiny.get(aMaterial)});
        }
    }

    public void onServerStarting() {
        GT_Log.out.println("GT_Mod: ServerStarting-Phase started!");
        GT_Log.ore.println("GT_Mod: ServerStarting-Phase started!");
        this.mUniverse = null;
        this.isFirstServerWorldTick = true;
        for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (tData.filledContainer.func_77973_b() != Items.field_151068_bn || tData.filledContainer.func_77960_j() != 0) continue;
            tData.fluid.amount = 0;
            break;
        }
        try {
            for (int i = 1; i < GregTech_API.METATILEENTITIES.length; ++i) {
                while (i < GregTech_API.METATILEENTITIES.length) {
                    if (GregTech_API.METATILEENTITIES[i] != null) {
                        GregTech_API.METATILEENTITIES[i].onServerStart();
                    }
                    ++i;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
        dimensionWiseChunkData.clear();
        dimensionWisePollution.clear();
    }

    public void onServerStarted() {
        GregTech_API.sWirelessRedstone.clear();
        GT_FluidStack.fixAllThoseFuckingFluidIDs();
        GT_Log.out.println("GT_Mod: Cleaning up all OreDict Crafting Recipes, which have an empty List in them, since they are never meeting any Condition.");
        List tList = CraftingManager.func_77594_a().func_77592_b();
        block0: for (int i = 0; i < tList.size(); ++i) {
            if (tList.get(i) instanceof ShapedOreRecipe) {
                for (Object tObject : ((ShapedOreRecipe)tList.get(i)).getInput()) {
                    if (!(tObject instanceof List) || !((List)tObject).isEmpty()) continue;
                    tList.remove(i--);
                    continue block0;
                }
                continue;
            }
            if (!(tList.get(i) instanceof ShapelessOreRecipe)) continue;
            for (Object tObject : ((ShapelessOreRecipe)tList.get(i)).getInput()) {
                if (!(tObject instanceof List) || !((List)tObject).isEmpty()) continue;
                tList.remove(i--);
                continue block0;
            }
        }
    }

    public void onServerStopping() {
        File tSaveDirectory = this.getSaveDirectory();
        GregTech_API.sWirelessRedstone.clear();
        if (tSaveDirectory != null) {
            try {
                for (int i = 1; i < GregTech_API.METATILEENTITIES.length; ++i) {
                    while (i < GregTech_API.METATILEENTITIES.length) {
                        if (GregTech_API.METATILEENTITIES[i] != null) {
                            GregTech_API.METATILEENTITIES[i].onWorldSave(tSaveDirectory);
                        }
                        ++i;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
        }
        this.mUniverse = null;
    }

    @SubscribeEvent
    public void onClientConnectedToServerEvent(FMLNetworkEvent.ClientConnectedToServerEvent aEvent) {
    }

    @SubscribeEvent
    public void onArrowNockEvent(ArrowNockEvent aEvent) {
        if (!aEvent.isCanceled() && GT_Utility.isStackValid(aEvent.result) && GT_Utility.getProjectile(SubTag.PROJECTILE_ARROW, (IInventory)aEvent.entityPlayer.field_71071_by) != null) {
            aEvent.entityPlayer.func_71008_a(aEvent.result, aEvent.result.func_77973_b().func_77626_a(aEvent.result));
            aEvent.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onArrowLooseEvent(ArrowLooseEvent aEvent) {
        ItemStack aArrow = GT_Utility.getProjectile(SubTag.PROJECTILE_ARROW, (IInventory)aEvent.entityPlayer.field_71071_by);
        if (!aEvent.isCanceled() && GT_Utility.isStackValid(aEvent.bow) && aArrow != null && aEvent.bow.func_77973_b() instanceof ItemBow) {
            int tLevel;
            float tSpeed = (float)aEvent.charge / 20.0f;
            if ((double)(tSpeed = (tSpeed * tSpeed + tSpeed * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if ((double)tSpeed > 1.0) {
                tSpeed = 1.0f;
            }
            EntityArrow tArrowEntity = ((IProjectileItem)aArrow.func_77973_b()).getProjectile(SubTag.PROJECTILE_ARROW, aArrow, aEvent.entityPlayer.field_70170_p, (EntityLivingBase)aEvent.entityPlayer, tSpeed * 2.0f);
            if (tSpeed >= 1.0f) {
                tArrowEntity.func_70243_d(true);
            }
            if ((tLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)aEvent.bow)) > 0) {
                tArrowEntity.func_70239_b(tArrowEntity.func_70242_d() + (double)tLevel * 0.5 + 0.5);
            }
            if ((tLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)aEvent.bow)) > 0) {
                tArrowEntity.func_70240_a(tLevel);
            }
            if ((tLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)aEvent.bow)) > 0) {
                tArrowEntity.func_70015_d(tLevel * 100);
            }
            aEvent.bow.func_77972_a(1, (EntityLivingBase)aEvent.entityPlayer);
            aEvent.bow.func_77973_b();
            aEvent.entityPlayer.field_70170_p.func_72956_a((Entity)aEvent.entityPlayer, "random.bow", 1.0f, 0.6489396f + tSpeed * 0.5f);
            tArrowEntity.field_70251_a = 1;
            if (!aEvent.entityPlayer.field_71075_bZ.field_75098_d) {
                --aArrow.field_77994_a;
            }
            if (aArrow.field_77994_a == 0) {
                GT_Utility.removeNullStacksFromInventory((IInventory)aEvent.entityPlayer.field_71071_by);
            }
            if (!aEvent.entityPlayer.field_70170_p.field_72995_K) {
                aEvent.entityPlayer.field_70170_p.func_72838_d((Entity)tArrowEntity);
            }
            aEvent.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEndermanTeleportEvent(EnderTeleportEvent aEvent) {
        if (aEvent.entityLiving instanceof EntityEnderman && aEvent.entityLiving.func_70660_b(Potion.field_76437_t) != null) {
            aEvent.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntitySpawningEvent(EntityJoinWorldEvent aEvent) {
        if (aEvent.entity != null && !aEvent.entity.field_70170_p.field_72995_K) {
            if (aEvent.entity instanceof EntityItem) {
                ((EntityItem)aEvent.entity).func_92058_a(GT_OreDictUnificator.get(((EntityItem)aEvent.entity).func_92059_d()));
            }
            if (this.mSkeletonsShootGTArrows > 0 && aEvent.entity.getClass() == EntityArrow.class && aEvent.entity.field_70170_p.field_73012_v.nextInt(this.mSkeletonsShootGTArrows) == 0 && ((EntityArrow)aEvent.entity).field_70250_c instanceof EntitySkeleton) {
                aEvent.entity.field_70170_p.func_72838_d((Entity)new GT_Entity_Arrow((EntityArrow)aEvent.entity, OrePrefixes.arrowGtWood.mPrefixedItems.get(aEvent.entity.field_70170_p.field_73012_v.nextInt(OrePrefixes.arrowGtWood.mPrefixedItems.size()))));
                aEvent.entity.func_70106_y();
            }
        }
    }

    @SubscribeEvent
    public void onOreGenEvent(OreGenEvent.GenerateMinable aGenerator) {
        if (this.mDisableVanillaOres && aGenerator.generator instanceof WorldGenMinable && PREVENTED_ORES.contains(aGenerator.type)) {
            aGenerator.setResult(Event.Result.DENY);
        }
    }

    private String getDataAndTime() {
        return this.mDateFormat.format(new Date());
    }

    @SubscribeEvent
    public void onPlayerInteraction(PlayerInteractEvent aEvent) {
        ItemStack aStack;
        if (aEvent.entityPlayer == null || aEvent.entityPlayer.field_70170_p == null || aEvent.action == null || aEvent.world.field_73011_w == null) {
            return;
        }
        if (!aEvent.entityPlayer.field_70170_p.field_72995_K && aEvent.action != PlayerInteractEvent.Action.RIGHT_CLICK_AIR && GT_Log.pal != null) {
            this.mBufferedPlayerActivity.add(this.getDataAndTime() + ";" + aEvent.action.name() + ";" + aEvent.entityPlayer.getDisplayName() + ";DIM:" + aEvent.world.field_73011_w.field_76574_g + ";" + aEvent.x + ";" + aEvent.y + ";" + aEvent.z + ";|;" + aEvent.x / 10 + ";" + aEvent.y / 10 + ";" + aEvent.z / 10);
        }
        if ((aStack = aEvent.entityPlayer.func_71045_bC()) != null && aEvent.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && aStack.func_77973_b() == Items.field_151033_d) {
            if (!aEvent.world.field_72995_K && !aEvent.entityPlayer.field_71075_bZ.field_75098_d && aEvent.world.field_73012_v.nextInt(100) >= this.mFlintChance) {
                aEvent.setCanceled(true);
                aStack.func_77972_a(1, (EntityLivingBase)aEvent.entityPlayer);
                if (aStack.func_77960_j() >= aStack.func_77958_k()) {
                    --aStack.field_77994_a;
                }
                if (aStack.field_77994_a <= 0) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)aEvent.entityPlayer, (ItemStack)aStack);
                }
            }
            return;
        }
    }

    @SubscribeEvent
    public void onBlockHarvestingEvent(BlockEvent.HarvestDropsEvent aEvent) {
        if (aEvent.harvester != null) {
            ItemStack aStack;
            if (!aEvent.world.field_72995_K && GT_Log.pal != null) {
                this.mBufferedPlayerActivity.add(this.getDataAndTime() + ";HARVEST_BLOCK;" + aEvent.harvester.getDisplayName() + ";DIM:" + aEvent.world.field_73011_w.field_76574_g + ";" + aEvent.x + ";" + aEvent.y + ";" + aEvent.z + ";|;" + aEvent.x / 10 + ";" + aEvent.y / 10 + ";" + aEvent.z / 10);
            }
            if ((aStack = aEvent.harvester.func_71045_bC()) != null) {
                if (aStack.func_77973_b() instanceof GT_MetaGenerated_Tool) {
                    ((GT_MetaGenerated_Tool)aStack.func_77973_b()).onHarvestBlockEvent(aEvent.drops, aStack, aEvent.harvester, aEvent.block, aEvent.x, aEvent.y, aEvent.z, (byte)aEvent.blockMetadata, aEvent.fortuneLevel, aEvent.isSilkTouching, aEvent);
                }
                if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77334_n.field_77352_x, (ItemStack)aStack) > 2) {
                    try {
                        for (ItemStack tDrop : aEvent.drops) {
                            ItemStack tSmeltingOutput = GT_ModHandler.getSmeltingOutput(tDrop, false, null);
                            if (tSmeltingOutput == null) continue;
                            tDrop.field_77994_a *= tSmeltingOutput.field_77994_a;
                            tSmeltingOutput.field_77994_a = tDrop.field_77994_a;
                            GT_Utility.setStack(tDrop, tSmeltingOutput);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace(GT_Log.err);
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SubscribeEvent
    public void registerOre(OreDictionary.OreRegisterEvent aEvent) {
        int n;
        int n2;
        Dyes[] dyesArray;
        String tModToName;
        block112: {
            String aMod;
            ModContainer tContainer = Loader.instance().activeModContainer();
            String aOriginalMod = aMod = tContainer == null ? "UNKNOWN" : tContainer.getModId();
            if (GT_OreDictUnificator.isRegisteringOres()) {
                aMod = "gregtech";
            } else if (aMod.equals("gregtech")) {
                aMod = "UNKNOWN";
            }
            if (aEvent == null || aEvent.Ore == null || aEvent.Ore.func_77973_b() == null || aEvent.Name == null || aEvent.Name.isEmpty() || aEvent.Name.replaceAll("_", "").length() - aEvent.Name.length() == 9) {
                if (aOriginalMod.equals("gregtech")) {
                    aOriginalMod = "UNKNOWN";
                }
                GT_Log.ore.println(aOriginalMod + " did something very bad! The registration is too invalid to even be shown properly. This happens only if you register null, invalid Items, empty Strings or even nonexisting Events to the OreDict.");
                throw new IllegalArgumentException(aOriginalMod + " did something very bad! The registration is too invalid to even be shown properly. This happens only if you register null, invalid Items, empty Strings or even nonexisting Events to the OreDict.");
            }
            try {
                block118: {
                    Materials aMaterial;
                    OrePrefixes aPrefix;
                    block114: {
                        String tName;
                        block116: {
                            block115: {
                                block117: {
                                    block113: {
                                        aEvent.Ore.field_77994_a = 1;
                                        if ((this.mIgnoreTcon || aEvent.Ore.func_77977_a().startsWith("item.oreberry")) && (aOriginalMod.toLowerCase(Locale.ENGLISH).contains("xycraft") || aOriginalMod.toLowerCase(Locale.ENGLISH).contains("tconstruct") || aOriginalMod.toLowerCase(Locale.ENGLISH).contains("natura") && !aOriginalMod.toLowerCase(Locale.ENGLISH).contains("natural"))) {
                                            if (!GT_Values.D1) return;
                                            GT_Log.ore.println(aMod + " -> " + aEvent.Name + " is getting ignored, because of racism. :P");
                                            return;
                                        }
                                        tModToName = aMod + " -> " + aEvent.Name;
                                        if (this.mOreDictActivated || GregTech_API.sPostloadStarted || this.mSortToTheEnd && GregTech_API.sLoadFinished) {
                                            tModToName = aOriginalMod + " --Late--> " + aEvent.Name;
                                        }
                                        if (aEvent.Ore.func_77973_b() instanceof ItemBlock || GT_Utility.getBlockFromStack(aEvent.Ore) != Blocks.field_150350_a) {
                                            GT_OreDictUnificator.addToBlacklist(aEvent.Ore);
                                        }
                                        this.mRegisteredOres.add(aEvent.Ore);
                                        if (this.mIgnoredItems.contains(aEvent.Name)) {
                                            if (aEvent.Name.startsWith("item")) {
                                                GT_Log.ore.println(tModToName);
                                                if (aEvent.Name.equals("itemCopperWire")) {
                                                    GT_OreDictUnificator.registerOre((Object)OreDictNames.craftingWireCopper, aEvent.Ore);
                                                }
                                                if (!aEvent.Name.equals("itemRubber")) return;
                                                GT_OreDictUnificator.registerOre(OrePrefixes.ingot, Materials.Rubber, aEvent.Ore);
                                                return;
                                            }
                                        } else {
                                            if (this.mIgnoredNames.contains(aEvent.Name)) {
                                                GT_Log.ore.println(tModToName + " is getting ignored via hardcode.");
                                                return;
                                            }
                                            if (aEvent.Name.equals("stone")) {
                                                GT_OreDictUnificator.registerOre("stoneSmooth", aEvent.Ore);
                                                return;
                                            }
                                            if (aEvent.Name.equals("cobblestone")) {
                                                GT_OreDictUnificator.registerOre("stoneCobble", aEvent.Ore);
                                                return;
                                            }
                                            if (aEvent.Name.contains("|") || aEvent.Name.contains("*") || aEvent.Name.contains(":") || aEvent.Name.contains(".") || aEvent.Name.contains("$")) {
                                                GT_Log.ore.println(tModToName + " is using a private Prefix and is therefor getting ignored properly.");
                                                return;
                                            }
                                            if (aEvent.Name.equals("copperWire")) {
                                                GT_OreDictUnificator.registerOre((Object)OreDictNames.craftingWireCopper, aEvent.Ore);
                                            } else if (aEvent.Name.equals("oreHeeEndrium")) {
                                                GT_OreDictUnificator.registerOre(OrePrefixes.ore, Materials.Endium, aEvent.Ore);
                                            } else if (aEvent.Name.equals("sheetPlastic")) {
                                                GT_OreDictUnificator.registerOre(OrePrefixes.plate, Materials.Plastic, aEvent.Ore);
                                            } else if (aEvent.Name.startsWith("shard")) {
                                                if (aEvent.Name.equals("shardAir")) {
                                                    GT_OreDictUnificator.registerOre(OrePrefixes.gem, Materials.InfusedAir, aEvent.Ore);
                                                    return;
                                                }
                                                if (aEvent.Name.equals("shardWater")) {
                                                    GT_OreDictUnificator.registerOre(OrePrefixes.gem, Materials.InfusedWater, aEvent.Ore);
                                                    return;
                                                }
                                                if (aEvent.Name.equals("shardFire")) {
                                                    GT_OreDictUnificator.registerOre(OrePrefixes.gem, Materials.InfusedFire, aEvent.Ore);
                                                    return;
                                                }
                                                if (aEvent.Name.equals("shardEarth")) {
                                                    GT_OreDictUnificator.registerOre(OrePrefixes.gem, Materials.InfusedEarth, aEvent.Ore);
                                                    return;
                                                }
                                                if (aEvent.Name.equals("shardOrder")) {
                                                    GT_OreDictUnificator.registerOre(OrePrefixes.gem, Materials.InfusedOrder, aEvent.Ore);
                                                    return;
                                                }
                                                if (aEvent.Name.equals("shardEntropy")) {
                                                    GT_OreDictUnificator.registerOre(OrePrefixes.gem, Materials.InfusedEntropy, aEvent.Ore);
                                                    return;
                                                }
                                            } else {
                                                if (aEvent.Name.equals("fieryIngot")) {
                                                    GT_OreDictUnificator.registerOre(OrePrefixes.ingot, Materials.FierySteel, aEvent.Ore);
                                                    return;
                                                }
                                                if (aEvent.Name.equals("ironwood")) {
                                                    GT_OreDictUnificator.registerOre(OrePrefixes.ingot, Materials.IronWood, aEvent.Ore);
                                                    return;
                                                }
                                                if (aEvent.Name.equals("steeleaf")) {
                                                    GT_OreDictUnificator.registerOre(OrePrefixes.ingot, Materials.Steeleaf, aEvent.Ore);
                                                    return;
                                                }
                                                if (aEvent.Name.equals("knightmetal")) {
                                                    GT_OreDictUnificator.registerOre(OrePrefixes.ingot, Materials.Knightmetal, aEvent.Ore);
                                                    return;
                                                }
                                                if (aEvent.Name.equals("compressedAluminum")) {
                                                    GT_OreDictUnificator.registerOre(OrePrefixes.compressed, Materials.Aluminium, aEvent.Ore);
                                                    return;
                                                }
                                                if (aEvent.Name.contains(" ")) {
                                                    GT_Log.ore.println(tModToName + " is getting re-registered because the OreDict Name containing invalid spaces.");
                                                    GT_OreDictUnificator.registerOre(aEvent.Name.replaceAll(" ", ""), GT_Utility.copyAmount(1L, aEvent.Ore));
                                                    aEvent.Ore.func_151001_c("Invalid OreDictionary Tag");
                                                    return;
                                                }
                                                if (this.mInvalidNames.contains(aEvent.Name)) {
                                                    GT_Log.ore.println(tModToName + " is wrongly registered and therefor getting ignored.");
                                                    return;
                                                }
                                            }
                                        }
                                        aPrefix = OrePrefixes.getOrePrefix(aEvent.Name);
                                        aMaterial = Materials._NULL;
                                        if (aPrefix == OrePrefixes.nugget && aMod.equals("Thaumcraft") && aEvent.Ore.func_77973_b().func_77658_a().contains("ItemResource")) {
                                            return;
                                        }
                                        if (aPrefix != null) break block113;
                                        if (aEvent.Name.toLowerCase().equals(aEvent.Name)) {
                                            GT_Log.ore.println(tModToName + " is invalid due to being solely lowercased.");
                                            return;
                                        }
                                        if (aEvent.Name.toUpperCase().equals(aEvent.Name)) {
                                            GT_Log.ore.println(tModToName + " is invalid due to being solely uppercased.");
                                            return;
                                        }
                                        if (Character.isUpperCase(aEvent.Name.charAt(0))) {
                                            GT_Log.ore.println(tModToName + " is invalid due to the first character being uppercased.");
                                        }
                                        break block114;
                                    }
                                    if (aPrefix.mDontUnificateActively) {
                                        GT_OreDictUnificator.addToBlacklist(aEvent.Ore);
                                    }
                                    if (aPrefix != aPrefix.mPrefixInto) {
                                        String tNewName = aEvent.Name.replaceFirst(aPrefix.toString(), aPrefix.mPrefixInto.toString());
                                        if (!GT_OreDictUnificator.isRegisteringOres()) {
                                            GT_Log.ore.println(tModToName + " uses a depricated Prefix, and is getting re-registered as " + tNewName);
                                        }
                                        GT_OreDictUnificator.registerOre(tNewName, aEvent.Ore);
                                        return;
                                    }
                                    tName = aEvent.Name.replaceFirst(aPrefix.toString(), "");
                                    if (tName.length() <= 0) break block115;
                                    char firstChar = tName.charAt(0);
                                    if (!Character.isUpperCase(firstChar) && !Character.isLowerCase(firstChar) && firstChar != '_') break block116;
                                    if (!aPrefix.mIsMaterialBased) break block117;
                                    aMaterial = Materials.get(tName);
                                    if (aMaterial != aMaterial.mMaterialInto) {
                                        GT_OreDictUnificator.registerOre(aPrefix, aMaterial.mMaterialInto, aEvent.Ore);
                                        if (GT_OreDictUnificator.isRegisteringOres()) return;
                                        GT_Log.ore.println(tModToName + " uses a deprecated Material and is getting re-registered as " + aPrefix.get(aMaterial.mMaterialInto));
                                        return;
                                    }
                                    if (!aPrefix.isIgnored(aMaterial)) {
                                        aPrefix.add(GT_Utility.copyAmount(1L, aEvent.Ore));
                                    }
                                    if (aMaterial == Materials._NULL) break block118;
                                    for (Materials tReRegisteredMaterial : aMaterial.mOreReRegistrations) {
                                        GT_OreDictUnificator.registerOre(aPrefix, tReRegisteredMaterial, aEvent.Ore);
                                    }
                                    aMaterial.add(GT_Utility.copyAmount(1L, aEvent.Ore));
                                    if (GregTech_API.sThaumcraftCompat != null && aPrefix.doGenerateItem(aMaterial) && !aPrefix.isIgnored(aMaterial)) {
                                        ArrayList<TC_Aspects.TC_AspectStack> tAspects = new ArrayList<TC_Aspects.TC_AspectStack>();
                                        for (TC_Aspects.TC_AspectStack tAspect : aPrefix.mAspects) {
                                            tAspect.addToAspectList(tAspects);
                                        }
                                        if (aPrefix.mMaterialAmount >= 3628800L || aPrefix.mMaterialAmount < 0L) {
                                            for (TC_Aspects.TC_AspectStack tAspect : aMaterial.mAspects) {
                                                tAspect.addToAspectList(tAspects);
                                            }
                                        }
                                        GregTech_API.sThaumcraftCompat.registerThaumcraftAspectsToItem(GT_Utility.copyAmount(1L, aEvent.Ore), tAspects, aEvent.Name);
                                    }
                                    switch (aPrefix) {
                                        case crystal: {
                                            if (aMaterial != Materials.CertusQuartz && aMaterial != Materials.NetherQuartz && aMaterial != Materials.Fluix) break;
                                            GT_OreDictUnificator.registerOre(OrePrefixes.gem, aMaterial, aEvent.Ore);
                                            break;
                                        }
                                        case gem: {
                                            if (aMaterial == Materials.Lapis || aMaterial == Materials.Sodalite) {
                                                GT_OreDictUnificator.registerOre(Dyes.dyeBlue, aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.Lazurite) {
                                                GT_OreDictUnificator.registerOre(Dyes.dyeCyan, aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.InfusedAir || aMaterial == Materials.InfusedWater || aMaterial == Materials.InfusedFire || aMaterial == Materials.InfusedEarth || aMaterial == Materials.InfusedOrder || aMaterial == Materials.InfusedEntropy) {
                                                GT_OreDictUnificator.registerOre(aMaterial.mName.replaceFirst("Infused", "shard"), aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.Chocolate) {
                                                GT_OreDictUnificator.registerOre(Dyes.dyeBrown, aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.CertusQuartz || aMaterial == Materials.NetherQuartz) {
                                                GT_OreDictUnificator.registerOre(OrePrefixes.item.get(aMaterial), aEvent.Ore);
                                                GT_OreDictUnificator.registerOre(OrePrefixes.crystal, aMaterial, aEvent.Ore);
                                                GT_OreDictUnificator.registerOre((Object)OreDictNames.craftingQuartz, aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial != Materials.Fluix && aMaterial != Materials.Quartz && aMaterial != Materials.Quartzite) break;
                                            GT_OreDictUnificator.registerOre(OrePrefixes.crystal, aMaterial, aEvent.Ore);
                                            GT_OreDictUnificator.registerOre((Object)OreDictNames.craftingQuartz, aEvent.Ore);
                                            break;
                                        }
                                        case cableGt01: {
                                            if (aMaterial == Materials.Tin) {
                                                GT_OreDictUnificator.registerOre((Object)OreDictNames.craftingWireTin, aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.AnyCopper) {
                                                GT_OreDictUnificator.registerOre((Object)OreDictNames.craftingWireCopper, aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.Gold) {
                                                GT_OreDictUnificator.registerOre((Object)OreDictNames.craftingWireGold, aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial != Materials.AnyIron) break;
                                            GT_OreDictUnificator.registerOre((Object)OreDictNames.craftingWireIron, aEvent.Ore);
                                            break;
                                        }
                                        case lens: {
                                            if (!aMaterial.contains(SubTag.TRANSPARENT) || aMaterial.mColor == Dyes._NULL) break;
                                            GT_OreDictUnificator.registerOre("craftingLens" + aMaterial.mColor.toString().replaceFirst("dye", ""), aEvent.Ore);
                                            break;
                                        }
                                        case plate: {
                                            if (aMaterial == Materials.Plastic || aMaterial == Materials.Rubber) {
                                                GT_OreDictUnificator.registerOre(OrePrefixes.sheet, aMaterial, aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.Silicon) {
                                                GT_OreDictUnificator.registerOre(OrePrefixes.item, aMaterial, aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial != Materials.Wood) break;
                                            GT_OreDictUnificator.addToBlacklist(aEvent.Ore);
                                            GT_OreDictUnificator.registerOre(OrePrefixes.plank, aMaterial, aEvent.Ore);
                                            break;
                                        }
                                        case cell: {
                                            if (aMaterial != Materials.Empty) break;
                                            GT_OreDictUnificator.addToBlacklist(aEvent.Ore);
                                            break;
                                        }
                                        case gearGt: {
                                            GT_OreDictUnificator.registerOre(OrePrefixes.gear, aMaterial, aEvent.Ore);
                                            break;
                                        }
                                        case stick: {
                                            if (!GT_RecipeRegistrator.sRodMaterialList.contains(aMaterial)) {
                                                GT_RecipeRegistrator.sRodMaterialList.add(aMaterial);
                                                break;
                                            }
                                            if (aMaterial == Materials.Wood) {
                                                GT_OreDictUnificator.addToBlacklist(aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial != Materials.Tin && aMaterial != Materials.Lead && aMaterial != Materials.SolderingAlloy) break;
                                            GT_OreDictUnificator.registerOre((Object)ToolDictNames.craftingToolSolderingMetal, aEvent.Ore);
                                            break;
                                        }
                                        case dust: {
                                            if (aMaterial == Materials.Salt) {
                                                GT_OreDictUnificator.registerOre("itemSalt", aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.Wood) {
                                                GT_OreDictUnificator.registerOre("pulpWood", aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.Wheat) {
                                                GT_OreDictUnificator.registerOre("foodFlour", aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.Lapis) {
                                                GT_OreDictUnificator.registerOre(Dyes.dyeBlue, aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.Lazurite) {
                                                GT_OreDictUnificator.registerOre(Dyes.dyeCyan, aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.Sodalite) {
                                                GT_OreDictUnificator.registerOre(Dyes.dyeBlue, aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.Cocoa) {
                                                GT_OreDictUnificator.registerOre(Dyes.dyeBrown, aEvent.Ore);
                                                GT_OreDictUnificator.registerOre("foodCocoapowder", aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.Coffee) {
                                                GT_OreDictUnificator.registerOre(Dyes.dyeBrown, aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.BrownLimonite) {
                                                GT_OreDictUnificator.registerOre(Dyes.dyeBrown, aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial != Materials.YellowLimonite) break;
                                            GT_OreDictUnificator.registerOre(Dyes.dyeYellow, aEvent.Ore);
                                            break;
                                        }
                                        case ingot: {
                                            if (aMaterial == Materials.Rubber) {
                                                GT_OreDictUnificator.registerOre("itemRubber", aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.FierySteel) {
                                                GT_OreDictUnificator.registerOre("fieryIngot", aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.IronWood) {
                                                GT_OreDictUnificator.registerOre("ironwood", aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.Steeleaf) {
                                                GT_OreDictUnificator.registerOre("steeleaf", aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial == Materials.Knightmetal) {
                                                GT_OreDictUnificator.registerOre("knightmetal", aEvent.Ore);
                                                break;
                                            }
                                            if (aMaterial != Materials.Brass || aEvent.Ore.func_77960_j() != 2 || !aEvent.Ore.func_77977_a().equals("item.ingotBrass") || !new ItemStack(aEvent.Ore.func_77973_b(), 1, 0).func_77977_a().contains("red")) break;
                                            GT_OreDictUnificator.set(OrePrefixes.ingot, Materials.RedAlloy, new ItemStack(aEvent.Ore.func_77973_b(), 1, 0));
                                            GT_OreDictUnificator.set(OrePrefixes.ingot, Materials.BlueAlloy, new ItemStack(aEvent.Ore.func_77973_b(), 1, 1));
                                            GT_OreDictUnificator.set(OrePrefixes.ingot, Materials.Brass, new ItemStack(aEvent.Ore.func_77973_b(), 1, 2));
                                            if (!this.mDisableIC2Cables) {
                                                GT_Values.RA.addWiremillRecipe(GT_ModHandler.getIC2Item("copperCableItem", 3L), new ItemStack(aEvent.Ore.func_77973_b(), 1, 8), 400, 1);
                                                GT_Values.RA.addWiremillRecipe(GT_ModHandler.getIC2Item("ironCableItem", 6L), new ItemStack(aEvent.Ore.func_77973_b(), 1, 9), 400, 2);
                                            }
                                            GT_Values.RA.addCutterRecipe(new ItemStack(aEvent.Ore.func_77973_b(), 1, 3), new ItemStack(aEvent.Ore.func_77973_b(), 16, 4), null, 400, 8);
                                            break;
                                        }
                                    }
                                    if (aPrefix.mIsUnificatable && !aMaterial.mUnificatable) {
                                        return;
                                    }
                                    break block116;
                                }
                                aPrefix.add(GT_Utility.copyAmount(1L, aEvent.Ore));
                                break block116;
                            }
                            if (!aPrefix.mIsSelfReferencing) {
                                GT_Log.ore.println(tModToName + " uses a Prefix as full OreDict Name, and is therefor invalid.");
                                aEvent.Ore.func_151001_c("Invalid OreDictionary Tag");
                                return;
                            }
                            aPrefix.add(GT_Utility.copyAmount(1L, aEvent.Ore));
                        }
                        switch (aPrefix) {
                            case dye: {
                                if (!GT_Utility.isStringValid(tName)) break;
                                GT_OreDictUnificator.registerOre((Object)OrePrefixes.dye, aEvent.Ore);
                                break;
                            }
                            case stoneSmooth: {
                                GT_OreDictUnificator.registerOre("stone", aEvent.Ore);
                                break;
                            }
                            case stoneCobble: {
                                GT_OreDictUnificator.registerOre("cobblestone", aEvent.Ore);
                                break;
                            }
                            case plank: {
                                if (!tName.equals("Wood")) break;
                                GT_OreDictUnificator.addItemData(aEvent.Ore, new ItemData(Materials.Wood, 3628800L, new MaterialStack[0]));
                                break;
                            }
                            case slab: {
                                if (!tName.equals("Wood")) break;
                                GT_OreDictUnificator.addItemData(aEvent.Ore, new ItemData(Materials.Wood, 1814400L, new MaterialStack[0]));
                                break;
                            }
                            case sheet: {
                                if (tName.equals("Plastic")) {
                                    GT_OreDictUnificator.registerOre(OrePrefixes.plate, Materials.Plastic, aEvent.Ore);
                                    break;
                                }
                                if (!tName.equals("Rubber")) break;
                                GT_OreDictUnificator.registerOre(OrePrefixes.plate, Materials.Rubber, aEvent.Ore);
                                break;
                            }
                            case crafting: {
                                if (tName.equals("ToolSolderingMetal")) {
                                    GregTech_API.registerSolderingMetal(aEvent.Ore);
                                    break;
                                }
                                if (tName.equals("IndustrialDiamond")) {
                                    GT_OreDictUnificator.addToBlacklist(aEvent.Ore);
                                    break;
                                }
                                if (!tName.equals("WireCopper")) break;
                                GT_OreDictUnificator.registerOre(OrePrefixes.wire, Materials.Copper, aEvent.Ore);
                                break;
                            }
                            case wood: {
                                if (!tName.equals("Rubber")) break;
                                GT_OreDictUnificator.registerOre("logRubber", aEvent.Ore);
                                break;
                            }
                            case food: {
                                if (!tName.equals("Cocoapowder")) break;
                                GT_OreDictUnificator.registerOre(OrePrefixes.dust, Materials.Cocoa, aEvent.Ore);
                                break;
                            }
                        }
                    }
                    GT_Log.ore.println(tModToName);
                    OreDictEventContainer tOre = new OreDictEventContainer(aEvent, aPrefix, aMaterial, aMod);
                    if (!this.mOreDictActivated || !GregTech_API.sUnificationEntriesRegistered) {
                        this.mEvents.add(tOre);
                    } else {
                        this.mEvents.clear();
                    }
                    if (!this.mOreDictActivated) return;
                    GT_Proxy.registerRecipes(tOre);
                    return;
                }
                dyesArray = Dyes.VALUES;
                n2 = dyesArray.length;
                n = 0;
                break block112;
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
            return;
        }
        while (n < n2) {
            Dyes tDye = dyesArray[n];
            if (aEvent.Name.endsWith(tDye.name().replaceFirst("dye", ""))) {
                GT_OreDictUnificator.addToBlacklist(aEvent.Ore);
                GT_Log.ore.println(tModToName + " Oh man, why the fuck would anyone need a OreDictified Color for this, that is even too much for GregTech... do not report this, this is just a random Comment about how ridiculous this is.");
                return;
            }
            ++n;
        }
    }

    @SubscribeEvent
    public void onFluidContainerRegistration(FluidContainerRegistry.FluidContainerRegisterEvent aFluidEvent) {
        if (aFluidEvent.data.filledContainer.func_77973_b() == Items.field_151068_bn && aFluidEvent.data.filledContainer.func_77960_j() == 0) {
            aFluidEvent.data.fluid.amount = 0;
        }
        GT_OreDictUnificator.addToBlacklist(aFluidEvent.data.emptyContainer);
        GT_OreDictUnificator.addToBlacklist(aFluidEvent.data.filledContainer);
        GT_Utility.addFluidContainerData(aFluidEvent.data);
    }

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent aEvent) {
    }

    @SubscribeEvent
    public void onWorldTickEvent(TickEvent.WorldTickEvent aEvent) {
        if (aEvent.world.field_73011_w.field_76574_g == 0) {
            --this.mTicksUntilNextCraftSound;
        }
        if (aEvent.side.isServer()) {
            File tSaveDiretory;
            if (this.mUniverse == null) {
                this.mUniverse = aEvent.world;
            }
            if (this.isFirstServerWorldTick && (tSaveDiretory = this.getSaveDirectory()) != null) {
                this.isFirstServerWorldTick = false;
                try {
                    for (IMetaTileEntity tMetaTileEntity : GregTech_API.METATILEENTITIES) {
                        if (tMetaTileEntity == null) continue;
                        tMetaTileEntity.onWorldLoad(tSaveDiretory);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace(GT_Log.err);
                }
            }
            if (aEvent.world.func_82737_E() % 100L == 0L && (this.mItemDespawnTime != 6000 || this.mMaxEqualEntitiesAtOneSpot > 0)) {
                for (int i = 0; i < aEvent.world.field_72996_f.size(); ++i) {
                    if (!(aEvent.world.field_72996_f.get(i) instanceof Entity)) continue;
                    Entity tEntity = (Entity)aEvent.world.field_72996_f.get(i);
                    if (tEntity instanceof EntityItem && this.mItemDespawnTime != 6000 && ((EntityItem)tEntity).lifespan == 6000) {
                        ((EntityItem)tEntity).lifespan = this.mItemDespawnTime;
                        continue;
                    }
                    if (!(tEntity instanceof EntityLivingBase) || this.mMaxEqualEntitiesAtOneSpot <= 0 || tEntity instanceof EntityPlayer || !((EntityLivingBase)tEntity).func_70104_M() || !(((EntityLivingBase)tEntity).func_110143_aJ() > 0.0f)) continue;
                    List tList = tEntity.field_70170_p.func_72839_b(tEntity, tEntity.field_70121_D.func_72314_b((double)0.2f, 0.0, (double)0.2f));
                    Class<?> tClass = tEntity.getClass();
                    int tEntityCount = 1;
                    if (tList != null) {
                        for (int j = 0; j < tList.size(); ++j) {
                            if (tList.get(j) == null || tList.get(j).getClass() != tClass) continue;
                            ++tEntityCount;
                        }
                    }
                    if (tEntityCount <= this.mMaxEqualEntitiesAtOneSpot) continue;
                    tEntity.func_70097_a(DamageSource.field_76368_d, (float)(tEntityCount - this.mMaxEqualEntitiesAtOneSpot));
                }
            }
            GT_Pollution.onWorldTick(aEvent);
        }
    }

    @SubscribeEvent
    public void onPlayerTickEventServer(TickEvent.PlayerTickEvent aEvent) {
        if (aEvent.side.isServer() && aEvent.phase == TickEvent.Phase.END && !aEvent.player.field_70128_L) {
            boolean tHungerEffect;
            if (aEvent.player.field_70173_aa % 200 == 0 && aEvent.player.field_71075_bZ.field_75099_e && !aEvent.player.field_71075_bZ.field_75098_d && this.mSurvivalIntoAdventure) {
                aEvent.player.func_71033_a(WorldSettings.GameType.ADVENTURE);
                aEvent.player.field_71075_bZ.field_75099_e = false;
                if (this.mAxeWhenAdventure) {
                    GT_Utility.sendChatToPlayer(aEvent.player, GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_097", "It's dangerous to go alone! Take this.", false));
                    aEvent.player.field_70170_p.func_72838_d((Entity)new EntityItem(aEvent.player.field_70170_p, aEvent.player.field_70165_t, aEvent.player.field_70163_u, aEvent.player.field_70161_v, GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(6, 1, Materials.Flint, Materials.Wood, null)));
                }
            }
            boolean bl = tHungerEffect = this.mHungerEffect && aEvent.player.field_70173_aa % 2400 == 1200;
            if (aEvent.player.field_70173_aa % 120 == 0) {
                float tHeat;
                ItemStack tStack;
                int i;
                int tCount = 64;
                for (i = 0; i < 36; ++i) {
                    tStack = aEvent.player.field_71071_by.func_70301_a(i);
                    if (tStack == null) continue;
                    if (!aEvent.player.field_71075_bZ.field_75098_d) {
                        GT_Utility.applyRadioactivity((EntityLivingBase)aEvent.player, GT_Utility.getRadioactivityLevel(tStack), tStack.field_77994_a);
                        tHeat = GT_Utility.getHeatDamageFromItem(tStack);
                        if (tHeat != 0.0f) {
                            if (tHeat > 0.0f) {
                                GT_Utility.applyHeatDamage((EntityLivingBase)aEvent.player, tHeat);
                            } else {
                                GT_Utility.applyFrostDamage((EntityLivingBase)aEvent.player, -tHeat);
                            }
                        }
                    }
                    if (tHungerEffect) {
                        tCount += tStack.field_77994_a * 64 / Math.max(1, tStack.func_77976_d());
                    }
                    if (!this.mInventoryUnification) continue;
                    GT_OreDictUnificator.setStack(true, tStack);
                }
                for (i = 0; i < 4; ++i) {
                    tStack = aEvent.player.field_71071_by.field_70460_b[i];
                    if (tStack == null) continue;
                    if (!aEvent.player.field_71075_bZ.field_75098_d) {
                        GT_Utility.applyRadioactivity((EntityLivingBase)aEvent.player, GT_Utility.getRadioactivityLevel(tStack), tStack.field_77994_a);
                        tHeat = GT_Utility.getHeatDamageFromItem(tStack);
                        if (tHeat != 0.0f) {
                            if (tHeat > 0.0f) {
                                GT_Utility.applyHeatDamage((EntityLivingBase)aEvent.player, tHeat);
                            } else {
                                GT_Utility.applyFrostDamage((EntityLivingBase)aEvent.player, -tHeat);
                            }
                        }
                    }
                    if (!tHungerEffect) continue;
                    tCount += 256;
                }
                if (tHungerEffect) {
                    aEvent.player.func_71020_j(Math.max(1.0f, (float)tCount / 666.6f));
                }
            }
            if (aEvent.player.field_70173_aa % 10 == 0) {
                int tPollution = 0;
                tPollution = GT_Pollution.getPollution(new ChunkCoordIntPair(aEvent.player.field_70176_ah, aEvent.player.field_70164_aj), aEvent.player.field_71093_bK);
                if (aEvent.player instanceof EntityPlayerMP) {
                    GT_Values.NW.sendToPlayer(new GT_Packet_Pollution(tPollution), (EntityPlayerMP)aEvent.player);
                }
            }
        }
    }

    public Object getServerGuiElement(int aID, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        IMetaTileEntity tMetaTileEntity;
        if (aID >= 1000) {
            int ID = aID - 1000;
            switch (ID) {
                case 0: {
                    return new ContainerBasicArmor(aPlayer, new InventoryArmor(ModularArmor_Item.class, aPlayer.func_71045_bC()));
                }
                case 1: {
                    return new ContainerElectricArmor1(aPlayer, new InventoryArmor(ModularArmor_Item.class, aPlayer.func_71045_bC()));
                }
                case 2: {
                    return new ContainerElectricArmor1(aPlayer, new InventoryArmor(ModularArmor_Item.class, aPlayer.func_71045_bC()));
                }
            }
            return this.getRightItem(aPlayer, ID);
        }
        if (aID >= 100) {
            int tSlot = aID / 100;
            int ID = aID % 100;
            switch (ID) {
                case 0: {
                    return new ContainerBasicArmor(aPlayer, new InventoryArmor(ModularArmor_Item.class, aPlayer.func_71124_b(tSlot)));
                }
                case 1: {
                    return new ContainerElectricArmor1(aPlayer, new InventoryArmor(ModularArmor_Item.class, aPlayer.func_71124_b(tSlot)));
                }
                case 2: {
                    return new ContainerElectricArmor1(aPlayer, new InventoryArmor(ModularArmor_Item.class, aPlayer.func_71124_b(tSlot)));
                }
            }
            return this.getRightItem(aPlayer, ID);
        }
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && (tMetaTileEntity = ((IGregTechTileEntity)tTileEntity).getMetaTileEntity()) != null) {
            return tMetaTileEntity.getServerGUI(aID, aPlayer.field_71071_by, (IGregTechTileEntity)tTileEntity);
        }
        return null;
    }

    public Object getRightItem(EntityPlayer player, int ID) {
        ItemStack mStack = player.func_71124_b(ID / 100);
        if (mStack == null || !(mStack.func_77973_b() instanceof ModularArmor_Item)) {
            return null;
        }
        switch (ID % 100) {
            case 0: {
                return new ContainerBasicArmor(player, new InventoryArmor(ModularArmor_Item.class, mStack));
            }
            case 1: {
                return new ContainerElectricArmor1(player, new InventoryArmor(ModularArmor_Item.class, mStack));
            }
            case 2: {
                return new ContainerElectricArmor1(player, new InventoryArmor(ModularArmor_Item.class, mStack));
            }
        }
        return null;
    }

    public Object getClientGuiElement(int aID, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        IMetaTileEntity tMetaTileEntity;
        if (aID >= 1000) {
            int ID = aID - 1000;
            switch (ID) {
                case 0: {
                    return new GuiModularArmor(new ContainerBasicArmor(aPlayer, new InventoryArmor(ModularArmor_Item.class, aPlayer.func_71045_bC())), aPlayer);
                }
                case 1: {
                    return new GuiElectricArmor1(new ContainerElectricArmor1(aPlayer, new InventoryArmor(ModularArmor_Item.class, aPlayer.func_71045_bC())), aPlayer);
                }
                case 2: {
                    return new GuiElectricArmor1(new ContainerElectricArmor1(aPlayer, new InventoryArmor(ModularArmor_Item.class, aPlayer.func_71045_bC())), aPlayer);
                }
            }
            return this.getRightItemGui(aPlayer, ID);
        }
        if (aID >= 100) {
            int tSlot = aID / 100;
            int ID = aID % 100;
            switch (ID) {
                case 0: {
                    return new GuiModularArmor(new ContainerBasicArmor(aPlayer, new InventoryArmor(ModularArmor_Item.class, aPlayer.func_71124_b(tSlot))), aPlayer);
                }
                case 1: {
                    return new GuiElectricArmor1(new ContainerElectricArmor1(aPlayer, new InventoryArmor(ModularArmor_Item.class, aPlayer.func_71124_b(tSlot))), aPlayer);
                }
                case 2: {
                    return new GuiElectricArmor1(new ContainerElectricArmor1(aPlayer, new InventoryArmor(ModularArmor_Item.class, aPlayer.func_71124_b(tSlot))), aPlayer);
                }
            }
            return this.getRightItem(aPlayer, ID);
        }
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && (tMetaTileEntity = ((IGregTechTileEntity)tTileEntity).getMetaTileEntity()) != null) {
            return tMetaTileEntity.getClientGUI(aID, aPlayer.field_71071_by, (IGregTechTileEntity)tTileEntity);
        }
        return null;
    }

    public Object getRightItemGui(EntityPlayer player, int ID) {
        ItemStack mStack = player.func_71124_b(ID / 100);
        if (mStack == null || !(mStack.func_77973_b() instanceof ModularArmor_Item)) {
            return null;
        }
        switch (ID % 100) {
            case 0: {
                return new GuiModularArmor(new ContainerBasicArmor(player, new InventoryArmor(ModularArmor_Item.class, mStack)), player);
            }
            case 1: {
                return new GuiElectricArmor1(new ContainerElectricArmor1(player, new InventoryArmor(ModularArmor_Item.class, mStack)), player);
            }
            case 2: {
                return new GuiElectricArmor1(new ContainerElectricArmor1(player, new InventoryArmor(ModularArmor_Item.class, mStack)), player);
            }
        }
        return null;
    }

    public int getBurnTime(ItemStack aFuel) {
        NBTTagCompound tNBT;
        Short tFuelValue;
        if (aFuel == null || aFuel.func_77973_b() == null) {
            return 0;
        }
        int rFuelValue = 0;
        if (aFuel.func_77973_b() instanceof GT_MetaGenerated_Item && (tFuelValue = ((GT_MetaGenerated_Item)aFuel.func_77973_b()).mBurnValues.get((short)aFuel.func_77960_j())) != null) {
            rFuelValue = Math.max(rFuelValue, tFuelValue.shortValue());
        }
        if ((tNBT = aFuel.func_77978_p()) != null) {
            short tValue = tNBT.func_74765_d("GT.ItemFuelValue");
            rFuelValue = Math.max(rFuelValue, tValue);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "gemSodium")) {
            rFuelValue = Math.max(rFuelValue, 4000);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "crushedSodium")) {
            rFuelValue = Math.max(rFuelValue, 4000);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustImpureSodium")) {
            rFuelValue = Math.max(rFuelValue, 4000);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustSodium")) {
            rFuelValue = Math.max(rFuelValue, 400);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustSmallSodium")) {
            rFuelValue = Math.max(rFuelValue, 100);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustTinySodium")) {
            rFuelValue = Math.max(rFuelValue, 44);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustSulfur")) {
            rFuelValue = Math.max(rFuelValue, 1600);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "gemLithium")) {
            rFuelValue = Math.max(rFuelValue, 6000);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "crushedLithium")) {
            rFuelValue = Math.max(rFuelValue, 6000);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustImpureLithium")) {
            rFuelValue = Math.max(rFuelValue, 6000);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustLithium")) {
            rFuelValue = Math.max(rFuelValue, 6000);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustSmallLithium")) {
            rFuelValue = Math.max(rFuelValue, 2000);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustTinyLithium")) {
            rFuelValue = Math.max(rFuelValue, 888);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "gemCaesium")) {
            rFuelValue = Math.max(rFuelValue, 6000);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "crushedCaesium")) {
            rFuelValue = Math.max(rFuelValue, 6000);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustImpureCaesium")) {
            rFuelValue = Math.max(rFuelValue, 6000);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustCaesium")) {
            rFuelValue = Math.max(rFuelValue, 6000);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustSmallCaesium")) {
            rFuelValue = Math.max(rFuelValue, 2000);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustTinyCaesium")) {
            rFuelValue = Math.max(rFuelValue, 888);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "gemLignite")) {
            rFuelValue = Math.max(rFuelValue, 1200);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "crushedLignite")) {
            rFuelValue = Math.max(rFuelValue, 1200);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustImpureLignite")) {
            rFuelValue = Math.max(rFuelValue, 1200);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustLignite")) {
            rFuelValue = Math.max(rFuelValue, 1200);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustSmallLignite")) {
            rFuelValue = Math.max(rFuelValue, 375);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustTinyLignite")) {
            rFuelValue = Math.max(rFuelValue, 166);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "gemCoal")) {
            rFuelValue = Math.max(rFuelValue, 1600);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "crushedCoal")) {
            rFuelValue = Math.max(rFuelValue, 1600);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustImpureCoal")) {
            rFuelValue = Math.max(rFuelValue, 1600);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustCoal")) {
            rFuelValue = Math.max(rFuelValue, 1600);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustSmallCoal")) {
            rFuelValue = Math.max(rFuelValue, 400);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustTinyCoal")) {
            rFuelValue = Math.max(rFuelValue, 177);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "gemCharcoal")) {
            rFuelValue = Math.max(rFuelValue, 1600);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "crushedCharcoal")) {
            rFuelValue = Math.max(rFuelValue, 1600);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustImpureCharcoal")) {
            rFuelValue = Math.max(rFuelValue, 1600);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustCharcoal")) {
            rFuelValue = Math.max(rFuelValue, 1600);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustSmallCharcoal")) {
            rFuelValue = Math.max(rFuelValue, 400);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustTinyCharcoal")) {
            rFuelValue = Math.max(rFuelValue, 177);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustWood")) {
            rFuelValue = Math.max(rFuelValue, 100);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustSmallWood")) {
            rFuelValue = Math.max(rFuelValue, 25);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "dustTinyWood")) {
            rFuelValue = Math.max(rFuelValue, 11);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "plateWood")) {
            rFuelValue = Math.min(rFuelValue, 300);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "blockLignite")) {
            rFuelValue = Math.max(rFuelValue, 12000);
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(aFuel, "blockCharcoal")) {
            rFuelValue = Math.max(rFuelValue, 16000);
        } else if (GT_Utility.areStacksEqual(aFuel, new ItemStack(Blocks.field_150471_bO, 1))) {
            rFuelValue = Math.max(rFuelValue, 150);
        } else if (GT_Utility.areStacksEqual(aFuel, new ItemStack(Blocks.field_150468_ap, 1))) {
            rFuelValue = Math.max(rFuelValue, 100);
        } else if (GT_Utility.areStacksEqual(aFuel, new ItemStack(Items.field_151155_ap, 1))) {
            rFuelValue = Math.max(rFuelValue, 600);
        } else if (GT_Utility.areStacksEqual(aFuel, new ItemStack(Items.field_151135_aq, 1))) {
            rFuelValue = Math.max(rFuelValue, 600);
        } else if (GT_Utility.areStacksEqual(aFuel, ItemList.Block_MSSFUEL.get(1L, new Object[0]))) {
            rFuelValue = Math.max(rFuelValue, 150000);
        }
        if (GT_Utility.areStacksEqual(aFuel, ItemList.Block_SSFUEL.get(1L, new Object[0]))) {
            rFuelValue = Math.max(rFuelValue, 100000);
        }
        return rFuelValue;
    }

    public Fluid addAutoGeneratedCorrespondingFluid(Materials aMaterial) {
        return this.addFluid(aMaterial.mName.toLowerCase(Locale.ENGLISH), "molten.autogenerated", aMaterial.mDefaultLocalName, aMaterial, aMaterial.mRGBa, 1, aMaterial.getLiquidTemperature(), GT_OreDictUnificator.get(OrePrefixes.cell, aMaterial, 1L), ItemList.Cell_Empty.get(1L, new Object[0]), 1000);
    }

    public Fluid addAutoGeneratedCorrespondingGas(Materials aMaterial) {
        return this.addFluid(aMaterial.mName.toLowerCase(Locale.ENGLISH), "molten.autogenerated", aMaterial.mDefaultLocalName, aMaterial, aMaterial.mRGBa, 2, aMaterial.getGasTemperature(), GT_OreDictUnificator.get(OrePrefixes.cell, aMaterial, 1L), ItemList.Cell_Empty.get(1L, new Object[0]), 1000);
    }

    public Fluid addAutogeneratedMoltenFluid(Materials aMaterial) {
        return this.addFluid("molten." + aMaterial.mName.toLowerCase(Locale.ENGLISH), "molten.autogenerated", "Molten " + aMaterial.mDefaultLocalName, aMaterial, aMaterial.mMoltenRGBa, 4, aMaterial.mMeltingPoint <= 0 ? 1000 : (int)aMaterial.mMeltingPoint, null, null, 0);
    }

    public Fluid addAutogeneratedPlasmaFluid(Materials aMaterial) {
        return this.addFluid("plasma." + aMaterial.mName.toLowerCase(Locale.ENGLISH), "plasma.autogenerated", aMaterial.mDefaultLocalName + " Plasma", aMaterial, aMaterial.mMoltenRGBa, 3, 10000, GT_OreDictUnificator.get(OrePrefixes.cellPlasma, aMaterial, 1L), ItemList.Cell_Empty.get(1L, new Object[0]), 1000);
    }

    public void addAutoGeneratedHydroCrackedFluids(Materials aMaterial) {
        Fluid[] crackedFluids = new Fluid[3];
        String[] prefixes = new String[]{"lightlyhydrocracked.", "moderatelyhydrocracked.", "severelyhydrocracked."};
        String[] localPrefixes = new String[]{"Lightly Hydro-Cracked ", "Moderately Hydro-Cracked ", "Severely Hydro-Cracked "};
        GT_Fluid uncrackedFluid = null;
        if (aMaterial.mFluid != null) {
            uncrackedFluid = (GT_Fluid)aMaterial.mFluid;
        } else if (aMaterial.mGas != null) {
            uncrackedFluid = (GT_Fluid)aMaterial.mGas;
        }
        for (int i = 0; i < 3; ++i) {
            crackedFluids[i] = this.addFluid(prefixes[i] + aMaterial.mName.toLowerCase(Locale.ENGLISH), uncrackedFluid.mTextureName, localPrefixes[i] + aMaterial.mDefaultLocalName, null, aMaterial.mRGBa, 2, 775, null, null, 0);
            int hydrogenAmount = 2 * i + 2;
            GT_Values.RA.addCrackingRecipe(i + 1, new FluidStack((Fluid)uncrackedFluid, 1000), Materials.Hydrogen.getGas(hydrogenAmount * 1000), new FluidStack(crackedFluids[i], 1000), 40 + 20 * i, 120 + 60 * i);
            GT_Values.RA.addChemicalRecipe(Materials.Hydrogen.getCells(hydrogenAmount), GT_Utility.getIntegratedCircuit(i + 1), new FluidStack((Fluid)uncrackedFluid, 1000), new FluidStack(crackedFluids[i], 800), Materials.Empty.getCells(hydrogenAmount), 160 + 80 * i, 30);
            GT_Values.RA.addChemicalRecipe(aMaterial.getCells(1), GT_Utility.getIntegratedCircuit(i + 1), Materials.Hydrogen.getGas(hydrogenAmount * 1000), new FluidStack(crackedFluids[i], 800), Materials.Empty.getCells(1), 160 + 80 * i, 30);
        }
        aMaterial.setHydroCrackedFluids(crackedFluids);
    }

    public void addAutoGeneratedSteamCrackedFluids(Materials aMaterial) {
        Fluid[] crackedFluids = new Fluid[3];
        String[] prefixes = new String[]{"lightlysteamcracked.", "moderatelysteamcracked.", "severelysteamcracked."};
        String[] localPrefixes = new String[]{"Lightly Steam-Cracked ", "Moderately Steam-Cracked ", "Severely Steam-Cracked "};
        GT_Fluid uncrackedFluid = null;
        if (aMaterial.mFluid != null) {
            uncrackedFluid = (GT_Fluid)aMaterial.mFluid;
        } else if (aMaterial.mGas != null) {
            uncrackedFluid = (GT_Fluid)aMaterial.mGas;
        }
        for (int i = 0; i < 3; ++i) {
            crackedFluids[i] = this.addFluid(prefixes[i] + aMaterial.mName.toLowerCase(Locale.ENGLISH), uncrackedFluid.mTextureName, localPrefixes[i] + aMaterial.mDefaultLocalName, null, aMaterial.mRGBa, 2, 775, null, null, 0);
            GT_Values.RA.addCrackingRecipe(i + 1, new FluidStack((Fluid)uncrackedFluid, 1000), GT_ModHandler.getSteam(1000L), new FluidStack(crackedFluids[i], 1000), 40 + 20 * i, 240 + 120 * i);
            GT_Values.RA.addChemicalRecipe(GT_ModHandler.getIC2Item("steamCell", 1L), GT_Utility.getIntegratedCircuit(i + 1), new FluidStack((Fluid)uncrackedFluid, 1000), new FluidStack(crackedFluids[i], 800), Materials.Empty.getCells(1), 160 + 80 * i, 30);
            GT_Values.RA.addChemicalRecipe(aMaterial.getCells(1), GT_Utility.getIntegratedCircuit(i + 1), GT_ModHandler.getSteam(1000L), new FluidStack(crackedFluids[i], 800), Materials.Empty.getCells(1), 160 + 80 * i, 30);
        }
        aMaterial.setSteamCrackedFluids(crackedFluids);
    }

    public Fluid addFluid(String aName, String aLocalized, Materials aMaterial, int aState, int aTemperatureK) {
        return this.addFluid(aName, aLocalized, aMaterial, aState, aTemperatureK, null, null, 0);
    }

    public Fluid addFluid(String aName, String aLocalized, Materials aMaterial, int aState, int aTemperatureK, ItemStack aFullContainer, ItemStack aEmptyContainer, int aFluidAmount) {
        return this.addFluid(aName, aName.toLowerCase(Locale.ENGLISH), aLocalized, aMaterial, null, aState, aTemperatureK, aFullContainer, aEmptyContainer, aFluidAmount);
    }

    public Fluid addFluid(String aName, String aTexture, String aLocalized, Materials aMaterial, short[] aRGBa, int aState, int aTemperatureK, ItemStack aFullContainer, ItemStack aEmptyContainer, int aFluidAmount) {
        aName = aName.toLowerCase(Locale.ENGLISH);
        GT_Fluid rFluid = new GT_Fluid(aName, aTexture, aRGBa != null ? aRGBa : Dyes._NULL.getRGBA());
        GT_LanguageManager.addStringLocalization(rFluid.getUnlocalizedName(), aLocalized == null ? aName : aLocalized);
        if (FluidRegistry.registerFluid((Fluid)rFluid)) {
            switch (aState) {
                case 0: {
                    rFluid.setGaseous(false);
                    rFluid.setViscosity(10000);
                    break;
                }
                case 1: 
                case 4: {
                    rFluid.setGaseous(false);
                    rFluid.setViscosity(1000);
                    break;
                }
                case 2: {
                    rFluid.setGaseous(true);
                    rFluid.setDensity(-100);
                    rFluid.setViscosity(200);
                    break;
                }
                case 3: {
                    rFluid.setGaseous(true);
                    rFluid.setDensity(55536);
                    rFluid.setViscosity(10);
                    rFluid.setLuminosity(15);
                }
            }
        } else {
            rFluid = FluidRegistry.getFluid((String)aName);
        }
        if (rFluid.getTemperature() == new Fluid("test").getTemperature()) {
            rFluid.setTemperature(aTemperatureK);
        }
        if (aMaterial != null) {
            switch (aState) {
                case 0: {
                    aMaterial.mSolid = rFluid;
                    break;
                }
                case 1: {
                    aMaterial.mFluid = rFluid;
                    break;
                }
                case 2: {
                    aMaterial.mGas = rFluid;
                    break;
                }
                case 3: {
                    aMaterial.mPlasma = rFluid;
                    break;
                }
                case 4: {
                    aMaterial.mStandardMoltenFluid = rFluid;
                }
            }
        }
        if (aFullContainer != null && aEmptyContainer != null && !FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack((Fluid)rFluid, aFluidAmount), (ItemStack)aFullContainer, (ItemStack)aEmptyContainer)) {
            GT_Values.RA.addFluidCannerRecipe(aFullContainer, GT_Utility.getContainerItem(aFullContainer, false), null, new FluidStack((Fluid)rFluid, aFluidAmount));
        }
        return rFluid;
    }

    public File getSaveDirectory() {
        return this.mUniverse == null ? null : this.mUniverse.func_72860_G().func_75765_b();
    }

    public void registerUnificationEntries() {
        GregTech_API.sUnification.mConfig.save();
        GregTech_API.sUnification.mConfig.load();
        GT_OreDictUnificator.resetUnificationEntries();
        for (OreDictEventContainer tOre : this.mEvents) {
            boolean chkmi;
            if (tOre.mEvent.Ore.func_77973_b() instanceof GT_MetaGenerated_Item || tOre.mPrefix == null || !tOre.mPrefix.mIsUnificatable || tOre.mMaterial == null) continue;
            boolean bl = chkmi = tOre.mModID != null;
            if (chkmi) {
                if (tOre.mModID.equalsIgnoreCase("enderio") && tOre.mPrefix == OrePrefixes.ingot && tOre.mMaterial == Materials.DarkSteel) {
                    GT_OreDictUnificator.addAssociation(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, false);
                    GT_OreDictUnificator.set(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, GregTech_API.sUnification.get((Object)((Object)((Object)ConfigCategories.specialunificationtargets) + "." + tOre.mModID), tOre.mEvent.Name, true), true);
                    continue;
                }
                if (tOre.mModID.equalsIgnoreCase("thermalfoundation") && tOre.mPrefix == OrePrefixes.dust && tOre.mMaterial == Materials.Blizz) {
                    GT_OreDictUnificator.addAssociation(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, false);
                    GT_OreDictUnificator.set(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, GregTech_API.sUnification.get((Object)((Object)((Object)ConfigCategories.specialunificationtargets) + "." + tOre.mModID), tOre.mEvent.Name, true), true);
                    continue;
                }
                if (tOre.mModID.equalsIgnoreCase("thermalfoundation") && tOre.mPrefix == OrePrefixes.dust && tOre.mMaterial == Materials.Pyrotheum) {
                    GT_OreDictUnificator.addAssociation(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, false);
                    GT_OreDictUnificator.set(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, GregTech_API.sUnification.get((Object)((Object)((Object)ConfigCategories.specialunificationtargets) + "." + tOre.mModID), tOre.mEvent.Name, true), true);
                    continue;
                }
                if (tOre.mModID.equalsIgnoreCase("arsmagica2") && tOre.mPrefix == OrePrefixes.dust && tOre.mMaterial == Materials.Vinteum) {
                    GT_OreDictUnificator.addAssociation(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, false);
                    GT_OreDictUnificator.set(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, GregTech_API.sUnification.get((Object)((Object)((Object)ConfigCategories.specialunificationtargets) + "." + tOre.mModID), tOre.mEvent.Name, true), true);
                    continue;
                }
                if (tOre.mModID.equalsIgnoreCase("arsmagica2") && tOre.mPrefix == OrePrefixes.gem && tOre.mMaterial == Materials.BlueTopaz) {
                    GT_OreDictUnificator.addAssociation(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, false);
                    GT_OreDictUnificator.set(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, GregTech_API.sUnification.get((Object)((Object)((Object)ConfigCategories.specialunificationtargets) + "." + tOre.mModID), tOre.mEvent.Name, true), true);
                    continue;
                }
                if (tOre.mModID.equalsIgnoreCase("arsmagica2") && tOre.mPrefix == OrePrefixes.gem && tOre.mMaterial == Materials.Chimerite) {
                    GT_OreDictUnificator.addAssociation(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, false);
                    GT_OreDictUnificator.set(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, GregTech_API.sUnification.get((Object)((Object)((Object)ConfigCategories.specialunificationtargets) + "." + tOre.mModID), tOre.mEvent.Name, true), true);
                    continue;
                }
                if (tOre.mModID.equalsIgnoreCase("arsmagica2") && tOre.mPrefix == OrePrefixes.gem && tOre.mMaterial == Materials.Moonstone) {
                    GT_OreDictUnificator.addAssociation(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, false);
                    GT_OreDictUnificator.set(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, GregTech_API.sUnification.get((Object)((Object)((Object)ConfigCategories.specialunificationtargets) + "." + tOre.mModID), tOre.mEvent.Name, true), true);
                    continue;
                }
                if (tOre.mModID.equalsIgnoreCase("arsmagica2") && tOre.mPrefix == OrePrefixes.gem && tOre.mMaterial == Materials.Sunstone) {
                    GT_OreDictUnificator.addAssociation(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, false);
                    GT_OreDictUnificator.set(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, GregTech_API.sUnification.get((Object)((Object)((Object)ConfigCategories.specialunificationtargets) + "." + tOre.mModID), tOre.mEvent.Name, true), true);
                    continue;
                }
                if (tOre.mModID.equalsIgnoreCase("rotarycraft") && tOre.mPrefix == OrePrefixes.ingot && tOre.mMaterial == Materials.HSLA) {
                    GT_OreDictUnificator.addAssociation(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, false);
                    GT_OreDictUnificator.set(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, GregTech_API.sUnification.get((Object)((Object)((Object)ConfigCategories.specialunificationtargets) + "." + tOre.mModID), tOre.mEvent.Name, true), true);
                    continue;
                }
                if (tOre.mModID.equalsIgnoreCase("appliedenergistics2") && tOre.mPrefix == OrePrefixes.gem && tOre.mMaterial == Materials.CertusQuartz) {
                    GT_OreDictUnificator.addAssociation(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, false);
                    GT_OreDictUnificator.set(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, GregTech_API.sUnification.get((Object)((Object)((Object)ConfigCategories.specialunificationtargets) + "." + tOre.mModID), tOre.mEvent.Name, true), true);
                    continue;
                }
                if (tOre.mModID.equalsIgnoreCase("appliedenergistics2") && tOre.mPrefix == OrePrefixes.dust && tOre.mMaterial == Materials.CertusQuartz) {
                    GT_OreDictUnificator.addAssociation(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, false);
                    GT_OreDictUnificator.set(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, GregTech_API.sUnification.get((Object)((Object)((Object)ConfigCategories.specialunificationtargets) + "." + tOre.mModID), tOre.mEvent.Name, true), true);
                    continue;
                }
            }
            if (GT_OreDictUnificator.isBlacklisted(tOre.mEvent.Ore)) {
                GT_OreDictUnificator.addAssociation(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, true);
                continue;
            }
            GT_OreDictUnificator.addAssociation(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, false);
            GT_OreDictUnificator.set(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, chkmi && GregTech_API.sUnification.get((Object)((Object)((Object)ConfigCategories.specialunificationtargets) + "." + tOre.mModID), tOre.mEvent.Name, false), true);
        }
        for (OreDictEventContainer tOre : this.mEvents) {
            if (!(tOre.mEvent.Ore.func_77973_b() instanceof GT_MetaGenerated_Item) || tOre.mPrefix == null || !tOre.mPrefix.mIsUnificatable || tOre.mMaterial == null) continue;
            if (GT_OreDictUnificator.isBlacklisted(tOre.mEvent.Ore)) {
                GT_OreDictUnificator.addAssociation(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, true);
                continue;
            }
            GT_OreDictUnificator.addAssociation(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, false);
            GT_OreDictUnificator.set(tOre.mPrefix, tOre.mMaterial, tOre.mEvent.Ore, tOre.mModID != null && GregTech_API.sUnification.get((Object)new StringBuilder().append((Object)ConfigCategories.specialunificationtargets).append(".").append(tOre.mModID), tOre.mEvent.Name, false), true);
        }
        GregTech_API.sUnificationEntriesRegistered = true;
        GregTech_API.sUnification.mConfig.save();
        GT_Recipe.reInit();
    }

    public void activateOreDictHandler() {
        this.mOreDictActivated = true;
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Register materials", (int)this.mEvents.size());
        for (OreDictEventContainer tEvent : this.mEvents) {
            progressBar.step(tEvent.mMaterial == null ? "" : tEvent.mMaterial.toString());
            GT_Proxy.registerRecipes(tEvent);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    public static int[] getDefaultChunkDataOnCreation() {
        return new int[]{0, 0, -1, -1};
    }

    public static int[] getDefaultChunkDataOnLoad() {
        return new int[]{1, 0, -1, -1};
    }

    @SubscribeEvent
    public void handleChunkSaveEvent(ChunkDataEvent.Save event) {
        HashMap<ChunkCoordIntPair, int[]> chunkData = dimensionWiseChunkData.get(event.world.field_73011_w.field_76574_g);
        if (chunkData == null) {
            return;
        }
        int[] tInts = chunkData.get(event.getChunk().func_76632_l());
        if (tInts == null) {
            return;
        }
        if (tInts[3] >= 0) {
            event.getData().func_74768_a("GTOIL", tInts[3]);
        } else {
            event.getData().func_82580_o("GTOIL");
        }
        if (tInts[2] >= 0) {
            event.getData().func_74768_a("GTOILFLUID", tInts[2]);
        } else {
            event.getData().func_82580_o("GTOILFLUID");
        }
        if (tInts[1] > 0) {
            event.getData().func_74768_a("GTPOLLUTION", tInts[1]);
        } else {
            event.getData().func_82580_o("GTPOLLUTION");
        }
        event.getData().func_74774_a("GTOILVER", (byte)20);
    }

    @SubscribeEvent
    public void handleChunkLoadEvent(ChunkDataEvent.Load event) {
        int[] tInts;
        int worldID = event.world.field_73011_w.field_76574_g;
        HashMap<Object, Object> chunkData = dimensionWiseChunkData.get(worldID);
        if (chunkData == null) {
            chunkData = new HashMap(1024);
            dimensionWiseChunkData.put(worldID, chunkData);
        }
        if (dimensionWisePollution.get(worldID) == null) {
            dimensionWisePollution.put(worldID, new GT_Pollution(event.world));
        }
        if ((tInts = (int[])chunkData.get(event.getChunk().func_76632_l())) == null) {
            tInts = GT_Proxy.getDefaultChunkDataOnLoad();
            if (event.getData().func_74771_c("GTOILVER") == 20) {
                if (event.getData().func_74764_b("GTOIL")) {
                    tInts[3] = event.getData().func_74762_e("GTOIL");
                }
                if (event.getData().func_74764_b("GTOILFLUID")) {
                    tInts[2] = event.getData().func_74762_e("GTOILFLUID");
                }
            }
            tInts[1] = event.getData().func_74762_e("GTPOLLUTION");
            if (tInts[1] > 0 || tInts[3] >= 0 || tInts[2] >= 0) {
                chunkData.put(event.getChunk().func_76632_l(), tInts);
            }
        } else if (tInts[0] == 0) {
            if (event.getData().func_74771_c("GTOILVER") == 20) {
                if (tInts[3] < 0 && event.getData().func_74764_b("GTOIL")) {
                    tInts[3] = event.getData().func_74762_e("GTOIL");
                }
                if (tInts[2] < 0 && event.getData().func_74764_b("GTOILFLUID")) {
                    tInts[2] = event.getData().func_74762_e("GTOILFLUID");
                }
            } else {
                tInts[3] = -1;
                tInts[2] = -1;
            }
            tInts[1] = tInts[1] + event.getData().func_74762_e("GTPOLLUTION");
            tInts[0] = 1;
            chunkData.put(event.getChunk().func_76632_l(), tInts);
        }
    }

    @SubscribeEvent
    public void onBlockBreakSpeedEvent(PlayerEvent.BreakSpeed aEvent) {
        ItemStack aStack;
        if (aEvent.newSpeed > 0.0f && aEvent.entityPlayer != null && (aStack = aEvent.entityPlayer.func_71045_bC()) != null && aStack.func_77973_b() instanceof GT_MetaGenerated_Tool) {
            aEvent.newSpeed = ((GT_MetaGenerated_Tool)aStack.func_77973_b()).onBlockBreakSpeedEvent(aEvent.newSpeed, aStack, aEvent.entityPlayer, aEvent.block, aEvent.x, aEvent.y, aEvent.z, (byte)aEvent.metadata, aEvent);
        }
    }

    public static class OreDictEventContainer {
        public final OreDictionary.OreRegisterEvent mEvent;
        public final OrePrefixes mPrefix;
        public final Materials mMaterial;
        public final String mModID;

        public OreDictEventContainer(OreDictionary.OreRegisterEvent aEvent, OrePrefixes aPrefix, Materials aMaterial, String aModID) {
            this.mEvent = aEvent;
            this.mPrefix = aPrefix;
            this.mMaterial = aMaterial;
            this.mModID = aModID == null || aModID.equals("UNKNOWN") ? null : aModID;
        }
    }
}

