/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import gregtech.GT_Mod;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_UO_Fluid;
import gregtech.api.objects.XSTR;
import gregtech.common.GT_Proxy;
import java.util.HashMap;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_UndergroundOil {
    public static final short DIVIDER = 5000;
    private static final XSTR random = new XSTR();

    public static FluidStack undergroundOilReadInformation(IGregTechTileEntity te) {
        return GT_UndergroundOil.undergroundOil(te.getWorld().func_72938_d(te.getXCoord(), te.getZCoord()), -1.0f);
    }

    public static FluidStack undergroundOilReadInformation(Chunk chunk) {
        return GT_UndergroundOil.undergroundOil(chunk, -1.0f);
    }

    public static FluidStack undergroundOil(IGregTechTileEntity te, float readOrDrainCoefficient) {
        return GT_UndergroundOil.undergroundOil(te.getWorld().func_72938_d(te.getXCoord(), te.getZCoord()), readOrDrainCoefficient);
    }

    public static FluidStack undergroundOil(Chunk chunk, float readOrDrainCoefficient) {
        FluidStack fluidInChunk;
        int[] tInts;
        if (GT_Mod.gregtechproxy.mUndergroundOil.CheckBlackList(chunk.field_76637_e.field_73011_w.field_76574_g)) {
            return null;
        }
        World aWorld = chunk.field_76637_e;
        HashMap<Object, Object> chunkData = GT_Proxy.dimensionWiseChunkData.get(aWorld.field_73011_w.field_76574_g);
        if (chunkData == null) {
            chunkData = new HashMap(1024);
            GT_Proxy.dimensionWiseChunkData.put(aWorld.field_73011_w.field_76574_g, chunkData);
        }
        if ((tInts = chunkData.get(chunk.func_76632_l())) == null) {
            tInts = GT_Proxy.getDefaultChunkDataOnCreation();
        } else if (tInts[3] == 0) {
            return readOrDrainCoefficient >= 0.0f ? null : new FluidStack(FluidRegistry.getFluid((int)tInts[2]), 0);
        }
        XSTR tRandom = new XSTR(aWorld.func_72905_C() + (long)(aWorld.field_73011_w.field_76574_g * 2) + (long)(chunk.func_76632_l().field_77276_a >> 3) + (long)(8267 * (chunk.func_76632_l().field_77275_b >> 3)));
        GT_UO_Fluid uoFluid = GT_Mod.gregtechproxy.mUndergroundOil.GetDimension(aWorld.field_73011_w.field_76574_g).getRandomFluid(tRandom);
        if (uoFluid == null || uoFluid.getFluid() == null) {
            tInts[2] = Integer.MAX_VALUE;
            tInts[3] = 0;
            chunkData.put(chunk.func_76632_l(), tInts);
            return null;
        }
        if (tInts[2] == uoFluid.getFluid().getID()) {
            fluidInChunk = new FluidStack(uoFluid.getFluid(), tInts[3]);
        } else {
            fluidInChunk = new FluidStack(uoFluid.getFluid(), uoFluid.getRandomAmount(tRandom));
            fluidInChunk.amount = (int)((float)fluidInChunk.amount * (0.75f + random.nextFloat() / 2.0f));
        }
        tInts[3] = fluidInChunk.amount;
        tInts[2] = fluidInChunk.getFluidID();
        if (readOrDrainCoefficient >= 0.0f) {
            int fluidExtracted = (int)Math.floor((double)fluidInChunk.amount * (double)readOrDrainCoefficient / 5000.0);
            double averageDecrease = (double)uoFluid.DecreasePerOperationAmount * (double)readOrDrainCoefficient;
            int decrease = (int)Math.ceil(averageDecrease);
            if (fluidExtracted <= 0 || fluidInChunk.amount <= decrease) {
                fluidInChunk = null;
                tInts[3] = 0;
            } else {
                fluidInChunk.amount = fluidExtracted;
                if ((double)random.nextFloat() < (double)decrease - averageDecrease) {
                    --decrease;
                }
                tInts[3] = tInts[3] - decrease;
            }
        } else if (fluidInChunk.amount <= 5000) {
            fluidInChunk.amount = 0;
            tInts[3] = 0;
        } else {
            fluidInChunk.amount /= 5000;
        }
        chunkData.put(chunk.func_76632_l(), tInts);
        return fluidInChunk;
    }
}

