/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicBatteryBuffer;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_EUMeter
extends GT_CoverBehavior {
    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        long tScale = 0L;
        if (aCoverVariable < 2) {
            tScale = aTileEntity.getUniversalEnergyCapacity() / 15L;
            if (tScale > 0L) {
                aTileEntity.setOutputRedstoneSignal(aSide, aCoverVariable % 2 == 0 ? (byte)(aTileEntity.getUniversalEnergyStored() / tScale) : (byte)(15L - aTileEntity.getUniversalEnergyStored() / tScale));
            } else {
                aTileEntity.setOutputRedstoneSignal(aSide, (byte)(aCoverVariable % 2 == 0 ? 0 : 15));
            }
        } else if (aCoverVariable < 4) {
            tScale = aTileEntity.getEUCapacity() / 15L;
            if (tScale > 0L) {
                aTileEntity.setOutputRedstoneSignal(aSide, aCoverVariable % 2 == 0 ? (byte)(aTileEntity.getStoredEU() / tScale) : (byte)(15L - aTileEntity.getStoredEU() / tScale));
            } else {
                aTileEntity.setOutputRedstoneSignal(aSide, (byte)(aCoverVariable % 2 == 0 ? 0 : 15));
            }
        } else if (aCoverVariable < 6) {
            tScale = aTileEntity.getSteamCapacity() / 15L;
            if (tScale > 0L) {
                aTileEntity.setOutputRedstoneSignal(aSide, aCoverVariable % 2 == 0 ? (byte)(aTileEntity.getStoredSteam() / tScale) : (byte)(15L - aTileEntity.getStoredSteam() / tScale));
            } else {
                aTileEntity.setOutputRedstoneSignal(aSide, (byte)(aCoverVariable % 2 == 0 ? 0 : 15));
            }
        } else if (aCoverVariable < 8) {
            tScale = aTileEntity.getInputVoltage() * aTileEntity.getInputAmperage() / 15L;
            if (tScale > 0L) {
                aTileEntity.setOutputRedstoneSignal(aSide, aCoverVariable % 2 == 0 ? (byte)(aTileEntity.getAverageElectricInput() / tScale) : (byte)(15L - aTileEntity.getAverageElectricInput() / tScale));
            } else {
                aTileEntity.setOutputRedstoneSignal(aSide, (byte)(aCoverVariable % 2 == 0 ? 0 : 15));
            }
        } else if (aCoverVariable < 10) {
            tScale = aTileEntity.getOutputVoltage() * aTileEntity.getOutputAmperage() / 15L;
            if (tScale > 0L) {
                aTileEntity.setOutputRedstoneSignal(aSide, aCoverVariable % 2 == 0 ? (byte)(aTileEntity.getAverageElectricOutput() / tScale) : (byte)(15L - aTileEntity.getAverageElectricOutput() / tScale));
            } else {
                aTileEntity.setOutputRedstoneSignal(aSide, (byte)(aCoverVariable % 2 == 0 ? 0 : 15));
            }
        } else if (aCoverVariable < 12) {
            IGregTechTileEntity tTileEntity;
            IMetaTileEntity mTileEntity;
            tScale = aTileEntity.getEUCapacity();
            long tStored = aTileEntity.getStoredEU();
            if (aTileEntity instanceof IGregTechTileEntity && (mTileEntity = (tTileEntity = (IGregTechTileEntity)aTileEntity).getMetaTileEntity()) instanceof GT_MetaTileEntity_BasicBatteryBuffer) {
                GT_MetaTileEntity_BasicBatteryBuffer buffer = (GT_MetaTileEntity_BasicBatteryBuffer)mTileEntity;
                if (buffer.mInventory != null) {
                    for (ItemStack aStack : buffer.mInventory) {
                        if (!GT_ModHandler.isElectricItem(aStack)) continue;
                        if (aStack.func_77973_b() instanceof GT_MetaBase_Item) {
                            Long[] stats = ((GT_MetaBase_Item)aStack.func_77973_b()).getElectricStats(aStack);
                            if (stats == null) continue;
                            tScale += stats[0].longValue();
                            tStored += ((GT_MetaBase_Item)aStack.func_77973_b()).getRealCharge(aStack);
                            continue;
                        }
                        if (!(aStack.func_77973_b() instanceof IElectricItem)) continue;
                        tStored += (long)ElectricItem.manager.getCharge(aStack);
                        tScale += (long)((IElectricItem)aStack.func_77973_b()).getMaxCharge(aStack);
                    }
                }
            }
            if ((tScale /= 15L) > 0L) {
                aTileEntity.setOutputRedstoneSignal(aSide, aCoverVariable % 2 == 0 ? (byte)(tStored / tScale) : (byte)(15L - tStored / tScale));
            } else {
                aTileEntity.setOutputRedstoneSignal(aSide, (byte)(aCoverVariable % 2 == 0 ? 0 : 15));
            }
        }
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((aCoverVariable = (aCoverVariable + (aPlayer.func_70093_af() ? -1 : 1)) % 12) < 0) {
            aCoverVariable = 11;
        }
        switch (aCoverVariable) {
            case 0: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("031", "Normal Universal Storage"));
                break;
            }
            case 1: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("032", "Inverted Universal Storage"));
                break;
            }
            case 2: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("033", "Normal Electricity Storage"));
                break;
            }
            case 3: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("034", "Inverted Electricity Storage"));
                break;
            }
            case 4: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("035", "Normal Steam Storage"));
                break;
            }
            case 5: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("036", "Inverted Steam Storage"));
                break;
            }
            case 6: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("037", "Normal Average Electric Input"));
                break;
            }
            case 7: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("038", "Inverted Average Electric Input"));
                break;
            }
            case 8: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("039", "Normal Average Electric Output"));
                break;
            }
            case 9: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("040", "Inverted Average Electric Output"));
                break;
            }
            case 10: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("041", "Normal Electricity Storage(Including Batteries)"));
                break;
            }
            case 11: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("042", "Inverted Electricity Storage(Including Batteries)"));
            }
        }
        return aCoverVariable;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 20;
    }
}

