/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Cover_FluidRegulator
extends GT_CoverBehavior {
    public final int mTransferRate;

    public GT_Cover_FluidRegulator(int aTransferRate) {
        this.mTransferRate = aTransferRate;
    }

    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aCoverVariable == 0) {
            return aCoverVariable;
        }
        if (aTileEntity instanceof IFluidHandler) {
            FluidStack tLiquid;
            ForgeDirection directionTo;
            ForgeDirection directionFrom;
            IFluidHandler tTank1;
            IFluidHandler tTank2;
            if (aCoverVariable > 0) {
                tTank2 = aTileEntity.getITankContainerAtSide(aSide);
                tTank1 = (IFluidHandler)aTileEntity;
                directionFrom = ForgeDirection.UNKNOWN;
                directionTo = ForgeDirection.getOrientation((int)aSide).getOpposite();
            } else {
                tTank1 = aTileEntity.getITankContainerAtSide(aSide);
                tTank2 = (IFluidHandler)aTileEntity;
                directionFrom = ForgeDirection.getOrientation((int)aSide).getOpposite();
                directionTo = ForgeDirection.UNKNOWN;
            }
            if (tTank1 != null && tTank2 != null && (tLiquid = tTank1.drain(directionFrom, Math.abs(aCoverVariable), false)) != null) {
                tLiquid = tLiquid.copy();
                tLiquid.amount = tTank2.fill(directionTo, tLiquid, false);
                if (tLiquid.amount > 0) {
                    if (aTileEntity.getUniversalEnergyCapacity() >= (long)Math.min(1, tLiquid.amount / 10)) {
                        if (aTileEntity.isUniversalEnergyStored(Math.min(1, tLiquid.amount / 10))) {
                            aTileEntity.decreaseStoredEnergyUnits(Math.min(1, tLiquid.amount / 10), true);
                            tTank2.fill(directionTo, tTank1.drain(directionFrom, tLiquid.amount, true), true);
                        }
                    } else {
                        tTank2.fill(directionTo, tTank1.drain(directionFrom, tLiquid.amount, true), true);
                    }
                }
            }
        }
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aCoverVariable = GT_Utility.getClickedFacingCoords(aSide, aX, aY, aZ)[0] >= 0.5f ? (aCoverVariable += aPlayer.func_70093_af() ? 256 : 16) : (aCoverVariable -= aPlayer.func_70093_af() ? 256 : 16);
        if (aCoverVariable > this.mTransferRate) {
            aCoverVariable = this.mTransferRate;
        }
        if (aCoverVariable < 0 - this.mTransferRate) {
            aCoverVariable = 0 - this.mTransferRate;
        }
        GT_Utility.sendChatToPlayer(aPlayer, this.trans("048", "Pump speed: ") + aCoverVariable + this.trans("049", "L/tick ") + aCoverVariable * 20 + this.trans("050", "L/sec"));
        return aCoverVariable;
    }

    @Override
    public boolean onCoverRightclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aCoverVariable = GT_Utility.getClickedFacingCoords(aSide, aX, aY, aZ)[0] >= 0.5f ? ++aCoverVariable : --aCoverVariable;
        if (aCoverVariable > this.mTransferRate) {
            aCoverVariable = this.mTransferRate;
        }
        if (aCoverVariable < 0 - this.mTransferRate) {
            aCoverVariable = 0 - this.mTransferRate;
        }
        GT_Utility.sendChatToPlayer(aPlayer, this.trans("048", "Pump speed: ") + aCoverVariable + this.trans("049", "L/tick ") + aCoverVariable * 20 + this.trans("050", "L/sec"));
        aTileEntity.setCoverDataAtSide(aSide, aCoverVariable);
        return true;
    }

    @Override
    public boolean letsRedstoneGoIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    @Override
    public boolean alwaysLookConnected(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }
}

