/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.armor.gui;

import gregtech.common.items.armor.ArmorData;
import gregtech.common.items.armor.ModularArmor_Item;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryArmor
implements IInventory {
    public ItemStack[] parts = new ItemStack[16];
    public ItemStack parent;
    public int maxCharge;
    public int charge;
    public ArmorData data;

    public InventoryArmor(Class<ModularArmor_Item> class1, ItemStack currentEquippedItem) {
        this.parent = currentEquippedItem;
        this.setUID(false);
        this.readFromNBT(currentEquippedItem.func_77978_p());
        if (currentEquippedItem.func_77973_b() instanceof ModularArmor_Item) {
            this.data = ((ModularArmor_Item)currentEquippedItem.func_77973_b()).data;
        }
    }

    public int func_70302_i_() {
        return this.parts.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.parts[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.parts[i] == null) {
            return null;
        }
        if (this.parts[i].field_77994_a <= j) {
            ItemStack product = this.parts[i];
            this.parts[i] = null;
            this.data.calculateArmor(this.parts);
            return product;
        }
        ItemStack product = this.parts[i].func_77979_a(j);
        if (this.parts[i].field_77994_a == 0) {
            this.parts[i] = null;
        }
        this.data.calculateArmor(this.parts);
        return product;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.parts[slot] == null) {
            return null;
        }
        ItemStack toReturn = this.parts[slot];
        this.parts[slot] = null;
        return toReturn;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.parts[i] = itemstack;
        this.data.calculateArmor(this.parts);
    }

    public String func_145825_b() {
        return "container.armor";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    public void onGuiSaved(EntityPlayer entityplayer) {
        this.parent = this.findParentInInventory(entityplayer);
        if (this.parent != null) {
            this.save();
        }
    }

    public void save() {
        NBTTagCompound nbt = this.parent.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        this.writeToNBT(nbt);
        ModularArmor_Item tmp = (ModularArmor_Item)this.parent.func_77973_b();
        tmp.data.calculateArmor(this.parts);
        this.parent.func_77982_d(nbt);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.parts[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public ItemStack findParentInInventory(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!InventoryArmor.isIdenticalItem(stack, this.parent)) continue;
            return stack;
        }
        return this.parent;
    }

    public static boolean isIdenticalItem(ItemStack lhs, ItemStack rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.func_77973_b() != rhs.func_77973_b()) {
            return false;
        }
        if (lhs.func_77960_j() != Short.MAX_VALUE && lhs.func_77960_j() != rhs.func_77960_j()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)lhs, (ItemStack)rhs);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        if (nbt.func_74764_b("Items")) {
            NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
            this.parts = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                byte byte0 = nbttagcompound1.func_74771_c("Slot");
                if (byte0 < 0 || byte0 >= this.parts.length) continue;
                this.parts[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
            }
        }
    }

    protected void setUID(boolean override) {
        if (this.parent.func_77978_p() == null) {
            this.parent.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = this.parent.func_77978_p();
        if (override || !nbt.func_74764_b("UID")) {
            nbt.func_74768_a("UID", new Random().nextInt());
        }
    }

    public static int getOccupiedSlotCount(ItemStack itemStack) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt == null) {
            return 0;
        }
        int count = 0;
        if (nbt.func_74764_b("Items")) {
            NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                ItemStack itemStack1 = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
                if (itemStack1 == null || itemStack1.field_77994_a <= 0) continue;
                ++count;
            }
        }
        return count;
    }
}

