/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_UndergroundOil;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import ic2.core.Ic2Items;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_AdvSeismicProspector
extends GT_MetaTileEntity_BasicMachine {
    boolean ready = false;
    int radius;
    int near;
    int middle;
    int step;

    public GT_MetaTileEntity_AdvSeismicProspector(int aID, String aName, String aNameRegional, int aTier, int aRadius, int aStep) {
        super(aID, aName, aNameRegional, aTier, 1, "Place, activate with explosives (8 Glyceryl, 32 TNT or 16 ITNT), use Data Stick", 1, 1, "Default.png", "", new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_SIDE_ROCK_BREAKER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_SIDE_ROCK_BREAKER), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TOP_ROCK_BREAKER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TOP_ROCK_BREAKER), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_BOTTOM_ROCK_BREAKER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_BOTTOM_ROCK_BREAKER));
        this.radius = aRadius;
        this.near = this.radius / 3;
        this.near += this.near % 2;
        this.middle = this.near * 2;
        this.step = aStep;
    }

    protected GT_MetaTileEntity_AdvSeismicProspector(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName, int aNear, int aMiddle, int aRadius, int aStep) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
        this.radius = aRadius;
        this.near = aNear;
        this.middle = aMiddle;
        this.step = aStep;
    }

    protected GT_MetaTileEntity_AdvSeismicProspector(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName, int aNear, int aMiddle, int aRadius, int aStep) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
        this.radius = aRadius;
        this.near = aNear;
        this.middle = aMiddle;
        this.step = aStep;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_AdvSeismicProspector(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName, this.near, this.middle, this.radius, this.step);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isServerSide()) {
            ItemStack aStack = aPlayer.func_71045_bC();
            if (!this.ready && (GT_Utility.consumeItems(aPlayer, aStack, Item.func_150898_a((Block)Blocks.field_150335_W), 32) || GT_Utility.consumeItems(aPlayer, aStack, Ic2Items.industrialTnt.func_77973_b(), 16) || GT_Utility.consumeItems(aPlayer, aStack, Materials.Glyceryl, 8))) {
                this.ready = true;
                this.mMaxProgresstime = aPlayer.field_71075_bZ.field_75098_d ? 20 : 800;
            } else if (this.ready && this.mMaxProgresstime == 0 && aStack != null && aStack.field_77994_a == 1 && aStack.func_77973_b() == ItemList.Tool_DataStick.getItem()) {
                this.ready = false;
                HashMap<String, Integer> tNearOres = new HashMap<String, Integer>();
                HashMap<String, Integer> tMiddleOres = new HashMap<String, Integer>();
                HashMap<String, Integer> tFarOres = new HashMap<String, Integer>();
                this.prospectOres(tNearOres, tMiddleOres, tFarOres);
                HashMap<String, Integer> tOils = new HashMap<String, Integer>();
                this.prospectOils(tOils);
                GT_Utility.ItemNBT.setAdvancedProspectionData(this.mTier, aStack, this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g, GT_Utility.sortByValueToList(tOils), GT_Utility.sortByValueToList(tNearOres), GT_Utility.sortByValueToList(tMiddleOres), GT_Utility.sortByValueToList(tFarOres), this.near, this.middle, this.radius);
            }
        }
        return true;
    }

    private void prospectOils(HashMap<String, Integer> aOils) {
        int tLeftXBound = GT_Utility.getScaleCoordinates(this.getBaseMetaTileEntity().getXCoord() - this.radius, 16);
        int tRightXBound = GT_Utility.getScaleCoordinates(this.getBaseMetaTileEntity().getXCoord() + this.radius, 16);
        int tLeftZBound = GT_Utility.getScaleCoordinates(this.getBaseMetaTileEntity().getZCoord() - this.radius, 16);
        int tRightZBound = GT_Utility.getScaleCoordinates(this.getBaseMetaTileEntity().getZCoord() + this.radius, 16);
        HashMap<ChunkCoordIntPair, FluidStack> tFluids = new HashMap<ChunkCoordIntPair, FluidStack>();
        try {
            for (int x = tLeftXBound; x <= tRightXBound; ++x) {
                for (int z = tLeftZBound; z <= tRightZBound; ++z) {
                    ChunkPosition tPos = new ChunkPosition(GT_Utility.getScaleCoordinates(x * 16, 96), 0, GT_Utility.getScaleCoordinates(z * 16, 96));
                    ChunkCoordIntPair cInts = this.getBaseMetaTileEntity().getWorld().func_72964_e(tPos.field_151329_a, tPos.field_151328_c).func_76632_l();
                    FluidStack tFluid = GT_UndergroundOil.undergroundOilReadInformation(this.getBaseMetaTileEntity().getWorld().func_72964_e(tPos.field_151329_a, tPos.field_151328_c));
                    if (tFluid == null) continue;
                    if (tFluids.containsKey(cInts)) {
                        if (((FluidStack)tFluids.get((Object)cInts)).amount >= tFluid.amount) continue;
                        ((FluidStack)tFluids.get((Object)cInts)).amount = tFluid.amount;
                        continue;
                    }
                    tFluids.put(cInts, tFluid);
                }
            }
            for (Map.Entry fl : tFluids.entrySet()) {
                aOils.put(((ChunkCoordIntPair)fl.getKey()).field_77276_a + "," + ((ChunkCoordIntPair)fl.getKey()).field_77275_b + "," + ((FluidStack)fl.getValue()).amount + "," + ((FluidStack)fl.getValue()).getLocalizedName(), ((FluidStack)fl.getValue()).amount);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void prospectOres(Map<String, Integer> aNearOres, Map<String, Integer> aMiddleOres, Map<String, Integer> aFarOres) {
        int tLeftXBound = this.getBaseMetaTileEntity().getXCoord() - this.radius;
        int tRightXBound = tLeftXBound + 2 * this.radius;
        int tLeftZBound = this.getBaseMetaTileEntity().getZCoord() - this.radius;
        int tRightZBound = tLeftZBound + 2 * this.radius;
        for (int i = tLeftXBound; i <= tRightXBound; i += this.step) {
            for (int k = tLeftZBound; k <= tRightZBound; k += this.step) {
                int di = Math.abs(i - this.getBaseMetaTileEntity().getXCoord());
                int dk = Math.abs(k - this.getBaseMetaTileEntity().getZCoord());
                if (di <= this.near && dk <= this.near) {
                    this.prospectHole(i, k, aNearOres);
                    continue;
                }
                if (di <= this.middle && dk <= this.middle) {
                    this.prospectHole(i, k, aMiddleOres);
                    continue;
                }
                this.prospectHole(i, k, aFarOres);
            }
        }
    }

    private void prospectHole(int i, int k, Map<String, Integer> aOres) {
        String tFoundOre = null;
        for (int j = this.getBaseMetaTileEntity().getYCoord(); j > 0; --j) {
            tFoundOre = this.checkForOre(i, j, k);
            if (tFoundOre == null) continue;
            GT_MetaTileEntity_AdvSeismicProspector.countOre(aOres, tFoundOre);
        }
    }

    private String checkForOre(int x, int y, int z) {
        Block tBlock = this.getBaseMetaTileEntity().getBlock(x, y, z);
        if (tBlock instanceof GT_Block_Ores_Abstract) {
            Materials tMaterial;
            TileEntity tTileEntity = this.getBaseMetaTileEntity().getWorld().func_147438_o(x, y, z);
            if (tTileEntity instanceof GT_TileEntity_Ores && ((GT_TileEntity_Ores)tTileEntity).mMetaData < 16000 && (tMaterial = GregTech_API.sGeneratedMaterials[((GT_TileEntity_Ores)tTileEntity).mMetaData % 1000]) != null && tMaterial != Materials._NULL) {
                return tMaterial.mDefaultLocalName;
            }
        } else {
            int tMetaID = this.getBaseMetaTileEntity().getWorld().func_72805_g(x, y, z);
            ItemData tAssotiation = GT_OreDictUnificator.getAssociation(new ItemStack(tBlock, 1, tMetaID));
            if (tAssotiation != null && tAssotiation.mPrefix.toString().startsWith("ore")) {
                return tAssotiation.mMaterial.mMaterial.mDefaultLocalName;
            }
        }
        return null;
    }

    private static void countOre(Map<String, Integer> map, String ore) {
        Integer oldCount = map.get(ore);
        oldCount = oldCount == null ? 0 : oldCount;
        map.put(ore, oldCount + 1);
    }
}

