/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.GT_Container_MicrowaveEnergyTransmitter;
import gregtech.common.gui.GT_GUIContainer_MicrowaveEnergyTransmitter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_MicrowaveEnergyTransmitter
extends GT_MetaTileEntity_BasicTank {
    public static boolean sInterDimensionalTeleportAllowed = true;
    public int mTargetX = 0;
    public int mTargetY = 0;
    public int mTargetZ = 0;
    public int mTargetD = 0;
    public boolean mDebug = false;
    public boolean hasEgg = false;
    public int mMaxLoss = 50;
    public int mMaxLossDistance = 10000;
    public boolean mPassiveEnergyUse = true;
    public int tTargetX = 0;
    public int tTargetY = 0;
    public int tTargetZ = 0;
    public int tTargetD = 0;
    public TileEntity tTile = null;

    public GT_MetaTileEntity_MicrowaveEnergyTransmitter(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, new String[]{"Transmits Energy Wirelessly", "Use a Dragon Egg or Nitrogen Plasma", "for Inter-dimensional transmission", "0.004EU Loss per 100 Blocks"}, new ITexture[0]);
    }

    public GT_MetaTileEntity_MicrowaveEnergyTransmitter(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public GT_MetaTileEntity_MicrowaveEnergyTransmitter(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        this.hasEgg = this.checkForEgg();
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_MicrowaveEnergyTransmitter(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MicrowaveEnergyTransmitter(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_MicrowaveEnergyTransmitter(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public String[] getInfoData() {
        return new String[]{"Coordinates:", "X: " + this.mTargetX, "Y: " + this.mTargetY, "Z: " + this.mTargetZ, "Dimension: " + this.mTargetD};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], aSide == 0 ? null : (aActive ? new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TELEPORTER_ACTIVE) : new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TELEPORTER))};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        if (this.mFluid != null) {
            aNBT.func_74782_a("mFluid", (NBTBase)this.mFluid.writeToNBT(new NBTTagCompound()));
        }
        aNBT.func_74768_a("mTargetX", this.mTargetX);
        aNBT.func_74768_a("mTargetY", this.mTargetY);
        aNBT.func_74768_a("mTargetZ", this.mTargetZ);
        aNBT.func_74768_a("mTargetD", this.mTargetD);
        aNBT.func_74757_a("mDebug", this.mDebug);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluid"));
        this.mTargetX = aNBT.func_74762_e("mTargetX");
        this.mTargetY = aNBT.func_74762_e("mTargetY");
        this.mTargetZ = aNBT.func_74762_e("mTargetZ");
        this.mTargetD = aNBT.func_74762_e("mTargetD");
        this.mDebug = aNBT.func_74767_n("mDebug");
    }

    @Override
    public void onConfigLoad(GT_Config aConfig) {
        sInterDimensionalTeleportAllowed = aConfig.get((Object)ConfigCategories.machineconfig, "Teleporter.Interdimensional", true);
        this.mMaxLoss = Math.max(aConfig.get((Object)ConfigCategories.machineconfig, "MicrowaveTransmitter.MaxLoss", 50), 11);
        this.mMaxLossDistance = aConfig.get((Object)ConfigCategories.machineconfig, "MicrowaveTransmitter.MaxLossDistance", 10000);
        this.mPassiveEnergyUse = aConfig.get((Object)ConfigCategories.machineconfig, "MicrowaveTransmitter.PassiveEnergy", true);
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.mTargetX == 0 && this.mTargetY == 0 && this.mTargetZ == 0 && this.mTargetD == 0) {
                this.mTargetX = this.getBaseMetaTileEntity().getXCoord();
                this.mTargetY = this.getBaseMetaTileEntity().getYCoord();
                this.mTargetZ = this.getBaseMetaTileEntity().getZCoord();
                this.mTargetD = this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g;
            }
            this.hasEgg = this.checkForEgg();
        }
    }

    public boolean checkForEgg() {
        for (int i = -5; i <= 5; i = (int)((byte)(i + 1))) {
            for (int j = -5; j <= 5; j = (int)((byte)(j + 1))) {
                for (int k = -5; k <= 5; k = (int)((byte)(k + 1))) {
                    if (this.getBaseMetaTileEntity().getBlockOffset(i, j, k) != Blocks.field_150380_bt) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasDimensionalTeleportCapability() {
        return this.mDebug || this.hasEgg || this.mFluid != null && this.mFluid.isFluidEqual(Materials.Nitrogen.getPlasma(1L)) && this.mFluid.amount >= 1000;
    }

    public boolean isDimensionalTeleportAvailable() {
        return this.mDebug || this.hasDimensionalTeleportCapability() && GT_Utility.isRealDimension(this.mTargetD) && GT_Utility.isRealDimension(this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mFluid == null) {
            this.mFluid = Materials.Nitrogen.getPlasma(0L);
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.getBaseMetaTileEntity().getTimer() % 100L == 50L) {
                this.hasEgg = this.checkForEgg();
            }
            if (this.getBaseMetaTileEntity().isAllowedToWork() && this.getBaseMetaTileEntity().getRedstone()) {
                if (this.getBaseMetaTileEntity().getStoredEU() > GT_Values.V[this.mTier] * 16L) {
                    if (this.mPassiveEnergyUse) {
                        this.getBaseMetaTileEntity().decreaseStoredEnergyUnits((long)Math.pow(2.0, this.mTier), false);
                    }
                    if (this.hasDimensionalTeleportCapability() && this.mTargetD != this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g && this.mFluid.isFluidEqual(Materials.Nitrogen.getPlasma(1L))) {
                        --this.mFluid.amount;
                        if (this.mFluid.amount < 1) {
                            this.mFluid = null;
                        }
                    }
                    if (this.tTargetD != this.mTargetD || this.tTargetX != this.mTargetX || this.tTargetY != this.mTargetY || this.tTargetZ != this.mTargetZ) {
                        this.tTargetD = this.mTargetD;
                        this.tTargetX = this.mTargetX;
                        this.tTargetY = this.mTargetY;
                        this.tTargetZ = this.mTargetZ;
                        if (this.mTargetD == this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g) {
                            this.tTile = this.getBaseMetaTileEntity().getTileEntity(this.mTargetX, this.mTargetY, this.mTargetZ);
                        } else {
                            WorldServer tWorld = DimensionManager.getWorld((int)this.mTargetD);
                            if (tWorld != null) {
                                this.tTile = tWorld.func_147438_o(this.mTargetX, this.mTargetY, this.mTargetZ);
                            }
                        }
                    }
                    int tDistance = this.distanceCalculation();
                    long tEnergyTrans = Math.min(GT_Values.V[this.mTier], this.getBaseMetaTileEntity().getStoredEU());
                    if (this.tTile != null && this.tTile instanceof IEnergyConnected && ((IEnergyConnected)this.tTile).injectEnergyUnits((byte)6, GT_Values.V[this.mTier], 1L) > 0L) {
                        int tLoss = 1;
                        if (this.mMaxLossDistance != 0) {
                            tLoss = 10 + tDistance * (this.mMaxLoss - 10) / this.mMaxLossDistance;
                        }
                        this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(GT_Values.V[this.mTier] + GT_Values.V[this.mTier] * (long)tLoss / 100L, false);
                    }
                }
                this.getBaseMetaTileEntity().setActive(true);
            } else {
                this.getBaseMetaTileEntity().setActive(false);
            }
        }
    }

    private int distanceCalculation() {
        return Math.abs((this.mTargetD != this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g && this.isDimensionalTeleportAvailable() ? 100 : 1) * (int)Math.sqrt(Math.pow(this.getBaseMetaTileEntity().getXCoord() - this.mTargetX, 2.0) + Math.pow(this.getBaseMetaTileEntity().getYCoord() - this.mTargetY, 2.0) + Math.pow(this.getBaseMetaTileEntity().getZCoord() - this.mTargetZ, 2.0)));
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isOverclockerUpgradable() {
        return false;
    }

    @Override
    public boolean isTransformerUpgradable() {
        return false;
    }

    @Override
    public boolean isElectric() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isInputFacing(byte aSide) {
        return true;
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return false;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier] * 16L;
    }

    @Override
    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 256L;
    }

    @Override
    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    @Override
    public long maxSteamStore() {
        return this.maxEUStore();
    }

    @Override
    public long maxAmperesIn() {
        return 3L;
    }

    @Override
    public int getStackDisplaySlot() {
        return 2;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public int getInputSlot() {
        return 0;
    }

    @Override
    public int getOutputSlot() {
        return 0;
    }

    @Override
    public int getCapacity() {
        return 64000;
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public boolean displaysItemStack() {
        return false;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }
}

