/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.GT_Container_Teleporter;
import gregtech.common.gui.GT_GUIContainer_Teleporter;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.effect.EntityWeatherEffect;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_Teleporter
extends GT_MetaTileEntity_BasicTank {
    public static boolean sInterDimensionalTeleportAllowed = true;
    public static int sPassiveEnergyDrain = 2048;
    public static int sPowerMultiplyer = 100;
    public static double sFPowerMultiplyer = 1.0;
    public int mTargetX = 0;
    public int mTargetY = 0;
    public int mTargetZ = 0;
    public int mTargetD = 0;
    public boolean mDebug = false;
    public boolean hasEgg = false;

    public GT_MetaTileEntity_Teleporter(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, new String[]{"Teleport long distances with this little device.", "Use a Dragon Egg or Nitrogen Plasma", "for Inter-dimensional transmission"}, new ITexture[0]);
    }

    public GT_MetaTileEntity_Teleporter(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Teleporter(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    private static float weightCalculation(Entity aEntity) {
        try {
            if (aEntity instanceof EntityFX) {
                return -1.0f;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (aEntity instanceof EntityFishHook) {
            return -1.0f;
        }
        if (aEntity instanceof EntityDragonPart) {
            return -1.0f;
        }
        if (aEntity instanceof EntityWeatherEffect) {
            return -1.0f;
        }
        if (aEntity instanceof EntityPlayer) {
            int i;
            EntityPlayer tPlayer = (EntityPlayer)aEntity;
            int tCount = 64;
            for (i = 0; i < 36; ++i) {
                if (tPlayer.field_71071_by.func_70301_a(i) == null) continue;
                tCount += tPlayer.field_71071_by.func_70301_a(i).func_77976_d() > 1 ? tPlayer.field_71071_by.func_70301_a((int)i).field_77994_a : 64;
            }
            for (i = 0; i < 4; ++i) {
                if (tPlayer.field_71071_by.field_70460_b[i] == null) continue;
                tCount += 256;
            }
            return Math.min(5.0f, (float)tCount / 666.6f);
        }
        if (GT_Utility.getClassName(aEntity).equals("EntityItnt")) {
            return 5.0f;
        }
        if (GT_Utility.getClassName(aEntity).equals("EntityNuke")) {
            return 50.0f;
        }
        if (aEntity instanceof EntityArrow) {
            return 0.001f;
        }
        if (aEntity instanceof EntityBoat) {
            return 0.1f;
        }
        if (aEntity instanceof EntityEnderCrystal) {
            return 2.0f;
        }
        if (aEntity instanceof EntityEnderEye) {
            return 0.001f;
        }
        if (aEntity instanceof EntityFireball) {
            return 0.001f;
        }
        if (aEntity instanceof EntityFireworkRocket) {
            return 0.001f;
        }
        if (aEntity instanceof EntityHanging) {
            return 0.005f;
        }
        if (aEntity instanceof EntityItem) {
            return 0.001f;
        }
        if (aEntity instanceof EntityLiving) {
            return 0.5f;
        }
        if (aEntity instanceof EntityMinecart) {
            return 0.1f;
        }
        if (aEntity instanceof EntityThrowable) {
            return 0.001f;
        }
        if (aEntity instanceof EntityTNTPrimed) {
            return 5.0f;
        }
        if (aEntity instanceof EntityXPOrb) {
            return 0.001f;
        }
        return -1.0f;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        this.hasEgg = this.checkForEgg();
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_Teleporter(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_Teleporter(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Teleporter(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{"Coordinates:", "X: " + this.mTargetX, "Y: " + this.mTargetY, "Z: " + this.mTargetZ, "Dimension: " + this.mTargetD};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], aSide != this.getBaseMetaTileEntity().getFrontFacing() ? null : (aActive ? new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TELEPORTER_ACTIVE) : new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TELEPORTER))};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        if (this.mFluid != null) {
            aNBT.func_74782_a("mFluid", (NBTBase)this.mFluid.writeToNBT(new NBTTagCompound()));
        }
        aNBT.func_74768_a("mTargetX", this.mTargetX);
        aNBT.func_74768_a("mTargetY", this.mTargetY);
        aNBT.func_74768_a("mTargetZ", this.mTargetZ);
        aNBT.func_74768_a("mTargetD", this.mTargetD);
        aNBT.func_74757_a("mDebug", this.mDebug);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluid"));
        this.mTargetX = aNBT.func_74762_e("mTargetX");
        this.mTargetY = aNBT.func_74762_e("mTargetY");
        this.mTargetZ = aNBT.func_74762_e("mTargetZ");
        this.mTargetD = aNBT.func_74762_e("mTargetD");
        this.mDebug = aNBT.func_74767_n("mDebug");
    }

    @Override
    public void onConfigLoad(GT_Config aConfig) {
        sInterDimensionalTeleportAllowed = aConfig.get((Object)ConfigCategories.machineconfig, "Teleporter.Interdimensional", true);
        sPassiveEnergyDrain = aConfig.get((Object)ConfigCategories.machineconfig, "Teleporter.PassiveDrain", sPassiveEnergyDrain);
        sPowerMultiplyer = aConfig.get((Object)ConfigCategories.machineconfig, "Teleporter.PowerMultipler", sPowerMultiplyer);
        sFPowerMultiplyer = (double)sPowerMultiplyer / 100.0;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.mTargetX == 0 && this.mTargetY == 0 && this.mTargetZ == 0 && this.mTargetD == 0) {
                this.mTargetX = this.getBaseMetaTileEntity().getXCoord();
                this.mTargetY = this.getBaseMetaTileEntity().getYCoord();
                this.mTargetZ = this.getBaseMetaTileEntity().getZCoord();
                this.mTargetD = this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g;
            }
            this.hasEgg = this.checkForEgg();
        }
    }

    public boolean checkForEgg() {
        for (int i = -5; i <= 5; i = (int)((byte)(i + 1))) {
            for (int j = -5; j <= 5; j = (int)((byte)(j + 1))) {
                for (int k = -5; k <= 5; k = (int)((byte)(k + 1))) {
                    if (this.getBaseMetaTileEntity().getBlockOffset(i, j, k) != Blocks.field_150380_bt) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasDimensionalTeleportCapability() {
        return this.mDebug || this.hasEgg || this.mFluid != null && this.mFluid.isFluidEqual(Materials.Nitrogen.getPlasma(1L)) && this.mFluid.amount >= 10;
    }

    public boolean isDimensionalTeleportAvailable() {
        return this.mDebug || this.hasDimensionalTeleportCapability() && GT_Utility.isRealDimension(this.mTargetD) && GT_Utility.isRealDimension(this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mFluid == null) {
            this.mFluid = Materials.Nitrogen.getPlasma(0L);
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.getBaseMetaTileEntity().getTimer() % 100L == 50L) {
                this.hasEgg = this.checkForEgg();
            }
            if (this.getBaseMetaTileEntity().isAllowedToWork() && this.getBaseMetaTileEntity().getRedstone()) {
                if (this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(sPassiveEnergyDrain, false)) {
                    if (this.hasDimensionalTeleportCapability() && this.mTargetD != this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g && (this.hasEgg || this.mFluid.isFluidEqual(Materials.Nitrogen.getPlasma(1L))) && new XSTR().nextInt(10) == 0) {
                        --this.mFluid.amount;
                        if (this.mFluid.amount < 1) {
                            this.mFluid = null;
                        }
                    }
                    int tDistance = this.distanceCalculation();
                    if (this.mInventory[0] != null) {
                        TileEntity tTile = null;
                        if (this.mTargetD == this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g) {
                            tTile = this.getBaseMetaTileEntity().getTileEntity(this.mTargetX, this.mTargetY, this.mTargetZ);
                        } else {
                            WorldServer tWorld = DimensionManager.getWorld((int)this.mTargetD);
                            if (tWorld != null) {
                                tTile = tWorld.func_147438_o(this.mTargetX, this.mTargetY, this.mTargetZ);
                            }
                        }
                        if (tTile != null && tTile instanceof IInventory) {
                            int tStacksize = this.mInventory[0].field_77994_a;
                            GT_Utility.moveOneItemStack(this, tTile, (byte)0, (byte)0, null, false, (byte)64, (byte)1, (byte)64, (byte)1);
                            if (this.mInventory[0] == null || this.mInventory[0].field_77994_a < tStacksize) {
                                this.getBaseMetaTileEntity().decreaseStoredEnergyUnits((int)(Math.pow(tDistance, 1.5) * (double)tDistance * (double)(tStacksize - (this.mInventory[0] == null ? 0 : this.mInventory[0].field_77994_a)) * sFPowerMultiplyer), false);
                            }
                        }
                    }
                    for (Object tObject : this.getBaseMetaTileEntity().getWorld().func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(this.getBaseMetaTileEntity().getOffsetX(this.getBaseMetaTileEntity().getFrontFacing(), 2) - 1), (double)(this.getBaseMetaTileEntity().getOffsetY(this.getBaseMetaTileEntity().getFrontFacing(), 2) - 1), (double)(this.getBaseMetaTileEntity().getOffsetZ(this.getBaseMetaTileEntity().getFrontFacing(), 2) - 1), (double)(this.getBaseMetaTileEntity().getOffsetX(this.getBaseMetaTileEntity().getFrontFacing(), 2) + 2), (double)(this.getBaseMetaTileEntity().getOffsetY(this.getBaseMetaTileEntity().getFrontFacing(), 2) + 2), (double)(this.getBaseMetaTileEntity().getOffsetZ(this.getBaseMetaTileEntity().getFrontFacing(), 2) + 2)))) {
                        if (!(tObject instanceof Entity) || ((Entity)tObject).field_70128_L) continue;
                        Entity tEntity = (Entity)tObject;
                        if (!this.getBaseMetaTileEntity().decreaseStoredEnergyUnits((int)(Math.pow(tDistance, 1.5) * (double)GT_MetaTileEntity_Teleporter.weightCalculation(tEntity) * sFPowerMultiplyer), false)) continue;
                        if (this.hasDimensionalTeleportCapability() && this.mTargetD != this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g && (this.hasEgg || this.mFluid.isFluidEqual(Materials.Nitrogen.getPlasma(1L)))) {
                            this.mFluid.amount -= (int)Math.min(10.0, Math.pow(tDistance, 1.5) * (double)GT_MetaTileEntity_Teleporter.weightCalculation(tEntity) / 8192.0);
                            if (this.mFluid.amount < 1) {
                                this.mFluid = null;
                            }
                        }
                        if (tEntity.field_70154_o != null) {
                            tEntity.func_70078_a(null);
                        }
                        if (tEntity.field_70153_n != null) {
                            tEntity.field_70153_n.func_70078_a(null);
                        }
                        if (this.mTargetD != this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g && this.isDimensionalTeleportAvailable() && GT_Utility.moveEntityToDimensionAtCoords(tEntity, this.mTargetD, (double)this.mTargetX + 0.5, (double)this.mTargetY + 0.5, (double)this.mTargetZ + 0.5)) continue;
                        if (tEntity instanceof EntityLivingBase) {
                            ((EntityLivingBase)tEntity).func_70634_a((double)this.mTargetX + 0.5, (double)this.mTargetY + 0.5, (double)this.mTargetZ + 0.5);
                            continue;
                        }
                        tEntity.func_70107_b((double)this.mTargetX + 0.5, (double)this.mTargetY + 0.5, (double)this.mTargetZ + 0.5);
                    }
                }
                this.getBaseMetaTileEntity().setActive(true);
            } else {
                this.getBaseMetaTileEntity().setActive(false);
            }
        }
    }

    private int distanceCalculation() {
        return Math.abs(this.mTargetD != this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g && this.isDimensionalTeleportAvailable() ? 4000 : (int)Math.sqrt(Math.pow(this.getBaseMetaTileEntity().getXCoord() - this.mTargetX, 2.0) + Math.pow(this.getBaseMetaTileEntity().getYCoord() - this.mTargetY, 2.0) + Math.pow(this.getBaseMetaTileEntity().getZCoord() - this.mTargetZ, 2.0)));
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isOverclockerUpgradable() {
        return false;
    }

    @Override
    public boolean isTransformerUpgradable() {
        return false;
    }

    @Override
    public boolean isElectric() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isInputFacing(byte aSide) {
        return true;
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return false;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier] * 16L;
    }

    @Override
    public long maxEUStore() {
        return 100000000L;
    }

    @Override
    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    @Override
    public long maxSteamStore() {
        return this.maxEUStore();
    }

    @Override
    public long maxAmperesIn() {
        return 2L;
    }

    @Override
    public int getStackDisplaySlot() {
        return 2;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public int getInputSlot() {
        return 0;
    }

    @Override
    public int getOutputSlot() {
        return 0;
    }

    @Override
    public int getCapacity() {
        return 64000;
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public boolean displaysItemStack() {
        return false;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }
}

