/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_DataAccess;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_AssemblyLine
extends GT_MetaTileEntity_MultiBlockBase {
    public ArrayList<GT_MetaTileEntity_Hatch_DataAccess> mDataAccessHatches = new ArrayList();

    public GT_MetaTileEntity_AssemblyLine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_AssemblyLine(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_AssemblyLine(this.mName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Assembly Line", "Size: 3x(5-16)x4, variable length", "Bottom: Steel Machine Casing(or Maintenance or Input Hatch),", "Input Bus (Last Output Bus), Steel Machine Casing", "Middle: Reinforced Glass, Assembly Line, Reinforced Glass", "UpMiddle: Grate Machine Casing,", "    Assembler Machine Casing,", "    Grate Machine Casing (or Controller or Data Access Hatch)", "Top: Steel Casing(or Energy Hatch)", "Up to 16 repeating slices, last is Output Bus", "Optional 1x Data Access Hatch next to the Controller"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[16], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[16]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "AssemblyLine.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        int i;
        ArrayList<ItemStack> tDataStickList;
        if (GT_Values.D1) {
            System.out.println("Start ALine recipe check");
        }
        if ((tDataStickList = this.getDataItems(2)).size() == 0) {
            return false;
        }
        if (GT_Values.D1) {
            System.out.println("Stick accepted, " + tDataStickList.size() + " Data Sticks found");
        }
        ItemStack[] tStack = new ItemStack[15];
        FluidStack[] tFluids = new FluidStack[4];
        boolean recipeNA = false;
        boolean findRecipe = false;
        for (ItemStack tDataStick : tDataStickList) {
            int i2;
            recipeNA = false;
            NBTTagCompound tTag = tDataStick.func_77978_p();
            if (tTag == null) continue;
            for (i2 = 0; i2 < 15; ++i2) {
                ItemStack stackInSlot;
                if (!tTag.func_74764_b("" + i2)) continue;
                if (this.mInputBusses.get(i2) == null) {
                    recipeNA = true;
                    break;
                }
                tStack[i2] = GT_Utility.loadItem(tTag, "" + i2);
                if (tStack[i2] == null) continue;
                if (GT_Values.D1) {
                    System.out.println("Item " + i2 + " : " + tStack[i2].func_77977_a());
                }
                if (!GT_Utility.areStacksEqual(tStack[i2], stackInSlot = ((GT_MetaTileEntity_Hatch_InputBus)this.mInputBusses.get(i2)).getBaseMetaTileEntity().func_70301_a(0), true) || tStack[i2].field_77994_a > stackInSlot.field_77994_a) {
                    if (GT_Values.D1) {
                        System.out.println(i2 + " not accepted");
                    }
                    recipeNA = true;
                    break;
                }
                if (!GT_Values.D1) continue;
                System.out.println(i2 + " accepted");
            }
            if (recipeNA) continue;
            if (GT_Values.D1) {
                System.out.println("All Items done, start fluid check");
            }
            for (i2 = 0; i2 < 4; ++i2) {
                if (!tTag.func_74764_b("f" + i2)) continue;
                tFluids[i2] = GT_Utility.loadFluid(tTag, "f" + i2);
                if (tFluids[i2] == null) continue;
                if (GT_Values.D1) {
                    System.out.println("Fluid " + i2 + " " + tFluids[i2].getUnlocalizedName());
                }
                if (this.mInputHatches.get(i2) == null) {
                    recipeNA = true;
                    break;
                }
                FluidStack fluidInHatch = ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)i2)).mFluid;
                if (fluidInHatch == null || !GT_Utility.areFluidsEqual(fluidInHatch, tFluids[i2], true) || fluidInHatch.amount < tFluids[i2].amount) {
                    if (GT_Values.D1) {
                        System.out.println(i2 + " not accepted");
                    }
                    recipeNA = true;
                    break;
                }
                if (!GT_Values.D1) continue;
                System.out.println(i2 + " accepted");
            }
            if (recipeNA) continue;
            if (GT_Values.D1) {
                System.out.println("Input accepted, check other values");
            }
            if (!tTag.func_74764_b("output")) continue;
            this.mOutputItems = new ItemStack[]{GT_Utility.loadItem(tTag, "output")};
            if (this.mOutputItems[0] == null || !GT_Utility.isStackValid(this.mOutputItems[0]) || !tTag.func_74764_b("time")) continue;
            this.mMaxProgresstime = tTag.func_74762_e("time");
            if (this.mMaxProgresstime <= 0 || !tTag.func_74764_b("eu")) continue;
            this.mEUt = tTag.func_74762_e("eu");
            if (GT_Values.D1) {
                System.out.println("Find avaiable recipe");
            }
            findRecipe = true;
            break;
        }
        if (!findRecipe) {
            return false;
        }
        if (GT_Values.D1) {
            System.out.println("All checked start consuming inputs");
        }
        for (i = 0; i < 15; ++i) {
            if (tStack[i] == null) continue;
            ItemStack stackInSlot = ((GT_MetaTileEntity_Hatch_InputBus)this.mInputBusses.get(i)).getBaseMetaTileEntity().func_70301_a(0);
            stackInSlot.field_77994_a -= tStack[i].field_77994_a;
        }
        for (i = 0; i < 4; ++i) {
            if (tFluids[i] == null) continue;
            ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)i)).mFluid.amount -= tFluids[i].amount;
            if (((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)i)).mFluid.amount > 0) continue;
            ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)i)).mFluid = null;
        }
        if (GT_Values.D1) {
            System.out.println("Check overclock");
        }
        byte tTier = (byte)Math.max(1, GT_Utility.getTier(this.getMaxInputVoltage()));
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.mEUt <= 16) {
            this.mEUt = this.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
            this.mMaxProgresstime /= 1 << tTier - 1;
        } else {
            while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                this.mEUt *= 4;
                this.mMaxProgresstime /= 2;
            }
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        this.updateSlots();
        if (GT_Values.D1) {
            System.out.println("Recipe sucessfull");
        }
        return true;
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 20) {
            GT_Utility.doSoundAtClient(GregTech_API.sSoundList.get(212), 10, 1.0f, aX, aY, aZ);
        }
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        if (xDir != 0) {
            for (int r = 0; r <= 16; ++r) {
                int i = r * xDir;
                IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(0, 0, i);
                if (!(i == 0 || aBaseMetaTileEntity.getBlockOffset(0, 0, i) == GregTech_API.sBlockCasings3 && aBaseMetaTileEntity.getMetaIDOffset(0, 0, i) == 10 || r != 1 || this.addDataAccessToMachineList(tTileEntity, 16))) {
                    return false;
                }
                if (!aBaseMetaTileEntity.getBlockOffset(0, -1, i).func_149739_a().equals("blockAlloyGlass")) {
                    return false;
                }
                tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(0, -2, i);
                if (!this.addMaintenanceToMachineList(tTileEntity, 16) && !this.addInputToMachineList(tTileEntity, 16)) {
                    if (aBaseMetaTileEntity.getBlockOffset(0, -2, i) != GregTech_API.sBlockCasings2) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(0, -2, i) != 0) {
                        return false;
                    }
                }
                if (!this.addEnergyInputToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir, 1, i), 16)) {
                    if (aBaseMetaTileEntity.getBlockOffset(xDir, 1, i) != GregTech_API.sBlockCasings2) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(xDir, 1, i) != 0) {
                        return false;
                    }
                }
                if (i != 0 && (aBaseMetaTileEntity.getBlockOffset(xDir, 0, i) != GregTech_API.sBlockCasings2 || aBaseMetaTileEntity.getMetaIDOffset(xDir, 0, i) != 9)) {
                    return false;
                }
                if (i != 0 && (aBaseMetaTileEntity.getBlockOffset(xDir, -1, i) != GregTech_API.sBlockCasings2 || aBaseMetaTileEntity.getMetaIDOffset(xDir, -1, i) != 5)) {
                    return false;
                }
                if (aBaseMetaTileEntity.getBlockOffset(xDir * 2, 0, i) != GregTech_API.sBlockCasings3 || aBaseMetaTileEntity.getMetaIDOffset(xDir * 2, 0, i) != 10) {
                    return false;
                }
                if (!aBaseMetaTileEntity.getBlockOffset(xDir * 2, -1, i).func_149739_a().equals("blockAlloyGlass")) {
                    return false;
                }
                tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir * 2, -2, i);
                if (!this.addMaintenanceToMachineList(tTileEntity, 16) && !this.addInputToMachineList(tTileEntity, 16)) {
                    if (aBaseMetaTileEntity.getBlockOffset(xDir * 2, -2, i) != GregTech_API.sBlockCasings2) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(xDir * 2, -2, i) != 0) {
                        return false;
                    }
                }
                if (this.addInputToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir, -2, i), 16) || !this.addOutputToMachineList(tTileEntity, 16)) continue;
                return r > 0 && this.mEnergyHatches.size() > 0;
            }
        } else {
            for (int r = 0; r <= 16; ++r) {
                int i = r * -zDir;
                IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(i, 0, 0);
                if (!(i == 0 || aBaseMetaTileEntity.getBlockOffset(i, 0, 0) == GregTech_API.sBlockCasings3 && aBaseMetaTileEntity.getMetaIDOffset(i, 0, 0) == 10 || r != 1 || this.addDataAccessToMachineList(tTileEntity, 16))) {
                    return false;
                }
                if (!aBaseMetaTileEntity.getBlockOffset(i, -1, 0).func_149739_a().equals("blockAlloyGlass")) {
                    return false;
                }
                tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(i, -2, 0);
                if (!this.addMaintenanceToMachineList(tTileEntity, 16) && !this.addInputToMachineList(tTileEntity, 16)) {
                    if (aBaseMetaTileEntity.getBlockOffset(i, -2, 0) != GregTech_API.sBlockCasings2) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(i, -2, 0) != 0) {
                        return false;
                    }
                }
                if (!this.addEnergyInputToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(i, 1, zDir), 16)) {
                    if (aBaseMetaTileEntity.getBlockOffset(i, 1, zDir) != GregTech_API.sBlockCasings2) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(i, 1, zDir) != 0) {
                        return false;
                    }
                }
                if (i != 0 && (aBaseMetaTileEntity.getBlockOffset(i, 0, zDir) != GregTech_API.sBlockCasings2 || aBaseMetaTileEntity.getMetaIDOffset(i, 0, zDir) != 9)) {
                    return false;
                }
                if (i != 0 && (aBaseMetaTileEntity.getBlockOffset(i, -1, zDir) != GregTech_API.sBlockCasings2 || aBaseMetaTileEntity.getMetaIDOffset(i, -1, zDir) != 5)) {
                    return false;
                }
                if (aBaseMetaTileEntity.getBlockOffset(i, 0, zDir * 2) != GregTech_API.sBlockCasings3 || aBaseMetaTileEntity.getMetaIDOffset(i, 0, zDir * 2) != 10) {
                    return false;
                }
                if (!aBaseMetaTileEntity.getBlockOffset(i, -1, zDir * 2).func_149739_a().equals("blockAlloyGlass")) {
                    return false;
                }
                tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(i, -2, zDir * 2);
                if (!this.addMaintenanceToMachineList(tTileEntity, 16) && !this.addInputToMachineList(tTileEntity, 16)) {
                    if (aBaseMetaTileEntity.getBlockOffset(i, -2, zDir * 2) != GregTech_API.sBlockCasings2) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(i, -2, zDir * 2) != 0) {
                        return false;
                    }
                }
                if (this.addInputToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(i, -2, zDir), 16) || !this.addOutputToMachineList(tTileEntity, 16)) continue;
                return r > 0 && this.mEnergyHatches.size() > 0;
            }
        }
        return false;
    }

    private boolean isCorrectDataItem(ItemStack aStack, int state) {
        if ((state & 1) != 0 && ItemList.Circuit_Integrated.isStackEqual(aStack, true, true)) {
            return true;
        }
        if ((state & 2) != 0 && ItemList.Tool_DataStick.isStackEqual(aStack, false, true)) {
            return true;
        }
        return (state & 4) != 0 && ItemList.Tool_DataOrb.isStackEqual(aStack, false, true);
    }

    public ArrayList<ItemStack> getDataItems(int state) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (GT_Utility.isStackValid(this.mInventory[1]) && this.isCorrectDataItem(this.mInventory[1], state)) {
            rList.add(this.mInventory[1]);
        }
        for (GT_MetaTileEntity_Hatch_DataAccess tHatch : this.mDataAccessHatches) {
            if (!GT_MetaTileEntity_AssemblyLine.isValidMetaTileEntity(tHatch)) continue;
            for (int i = 0; i < tHatch.getBaseMetaTileEntity().func_70302_i_(); ++i) {
                if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null || !this.isCorrectDataItem(tHatch.getBaseMetaTileEntity().func_70301_a(i), state)) continue;
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    public boolean addDataAccessToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DataAccess) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mDataAccessHatches.add((GT_MetaTileEntity_Hatch_DataAccess)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

