/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_DataAccess;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class GT_MetaTileEntity_DrillerBase
extends GT_MetaTileEntity_MultiBlockBase {
    private static final ItemStack miningPipe = GT_ModHandler.getIC2Item("miningPipe", 0L);
    private static final ItemStack miningPipeTip = GT_ModHandler.getIC2Item("miningPipeTip", 0L);
    private static final Block miningPipeBlock = GT_Utility.getBlockFromStack(miningPipe);
    private static final Block miningPipeTipBlock = GT_Utility.getBlockFromStack(miningPipeTip);
    private Block casingBlock;
    private int casingMeta;
    private int frameMeta;
    private int casingTextureIndex;
    private ForgeDirection back;
    private int xDrill;
    private int yDrill;
    private int zDrill;
    private int xPipe;
    private int zPipe;
    private int yHead;
    protected boolean isPickingPipes;
    public ArrayList<GT_MetaTileEntity_Hatch_DataAccess> mDataAccessHatches = new ArrayList();

    public GT_MetaTileEntity_DrillerBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.initFields();
    }

    public GT_MetaTileEntity_DrillerBase(String aName) {
        super(aName);
        this.initFields();
    }

    private void initFields() {
        this.casingBlock = this.getCasingBlockItem().getBlock();
        this.casingMeta = this.getCasingBlockItem().get(0L, new Object[0]).func_77960_j();
        int frameId = 4096 + this.getFrameMaterial().mMetaItemSubID;
        this.frameMeta = GregTech_API.METATILEENTITIES[frameId] != null ? (int)GregTech_API.METATILEENTITIES[frameId].getTileEntityBaseType() : Short.MAX_VALUE;
        this.casingTextureIndex = this.getCasingTextureIndex();
        this.isPickingPipes = false;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[this.casingTextureIndex], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_ORE_DRILL_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_ORE_DRILL)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[this.casingTextureIndex]};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("isPickingPipe", this.isPickingPipes);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.isPickingPipes = aNBT.func_74767_n("isPickingPipes");
    }

    protected boolean tryPickPipe() {
        if (this.yHead == this.yDrill) {
            return false;
        }
        if (this.tryOutputPipe()) {
            if (this.checkBlockAndMeta(this.xPipe, this.yHead + 1, this.zPipe, miningPipeBlock, Short.MAX_VALUE)) {
                this.getBaseMetaTileEntity().getWorld().func_147449_b(this.xPipe, this.yHead + 1, this.zPipe, miningPipeTipBlock);
            }
            this.getBaseMetaTileEntity().getWorld().func_147468_f(this.xPipe, this.yHead, this.zPipe);
            return true;
        }
        return false;
    }

    protected boolean tryLowerPipe() {
        if (!this.isHasMiningPipes()) {
            return false;
        }
        if (this.yHead <= 0) {
            return false;
        }
        if (!this.canLowerPipe()) {
            return false;
        }
        this.getBaseMetaTileEntity().getWorld().func_147449_b(this.xPipe, this.yHead - 1, this.zPipe, miningPipeTipBlock);
        if (this.yHead != this.yDrill) {
            this.getBaseMetaTileEntity().getWorld().func_147449_b(this.xPipe, this.yHead, this.zPipe, miningPipeBlock);
        }
        this.getBaseMetaTileEntity().func_70298_a(1, 1);
        return true;
    }

    private void putMiningPipesFromInputsInController() {
        int maxPipes = miningPipe.func_77976_d();
        if (this.isHasMiningPipes(maxPipes)) {
            return;
        }
        ItemStack pipes = this.func_70301_a(1);
        for (ItemStack storedItem : this.getStoredInputs()) {
            if (!storedItem.func_77969_a(miningPipe)) continue;
            if (pipes == null) {
                this.func_70299_a(1, GT_Utility.copy(miningPipe));
                pipes = this.func_70301_a(1);
            }
            if (pipes.field_77994_a == maxPipes) break;
            int needPipes = maxPipes - pipes.field_77994_a;
            int transferPipes = storedItem.field_77994_a < needPipes ? storedItem.field_77994_a : needPipes;
            pipes.field_77994_a += transferPipes;
            storedItem.field_77994_a -= transferPipes;
        }
        this.updateSlots();
    }

    private boolean tryOutputPipe() {
        if (!this.getBaseMetaTileEntity().addStackToSlot(1, GT_Utility.copyAmount(1L, miningPipe))) {
            this.mOutputItems = new ItemStack[]{GT_Utility.copyAmount(1L, miningPipe)};
        }
        return true;
    }

    protected boolean canLowerPipe() {
        return this.yHead > 0 && !this.checkBlockAndMeta(this.xPipe, this.yHead - 1, this.zPipe, Blocks.field_150357_h, Short.MAX_VALUE);
    }

    private boolean isHasMiningPipes() {
        return this.isHasMiningPipes(1);
    }

    private boolean isHasMiningPipes(int minCount) {
        ItemStack pipe = this.func_70301_a(1);
        return pipe != null && pipe.field_77994_a > minCount - 1 && pipe.func_77969_a(miningPipe);
    }

    private boolean isEnergyEnough() {
        long requiredEnergy = 512L + this.getMaxInputVoltage() * 4L;
        for (GT_MetaTileEntity_Hatch_Energy energyHatch : this.mEnergyHatches) {
            if ((requiredEnergy -= energyHatch.getEUVar()) > 0L) continue;
            return true;
        }
        return false;
    }

    protected boolean workingDownward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (!this.tryLowerPipe() && this.waitForPipes()) {
            return false;
        }
        this.isPickingPipes = true;
        return true;
    }

    protected boolean workingUpward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.tryPickPipe()) {
            return true;
        }
        this.isPickingPipes = false;
        this.stopMachine();
        return false;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        this.setElectricityStats();
        int oldYHead = this.yHead;
        if (!this.checkPipesAndSetYHead() || !this.isEnergyEnough()) {
            this.stopMachine();
            return false;
        }
        this.putMiningPipesFromInputsInController();
        if (!this.isPickingPipes) {
            return this.workingDownward(aStack, this.xDrill, this.yDrill, this.zDrill, this.xPipe, this.zPipe, this.yHead, oldYHead);
        }
        return this.workingUpward(aStack, this.xDrill, this.yDrill, this.zDrill, this.xPipe, this.zPipe, this.yHead, oldYHead);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.updateCoordinates();
        for (int xOff = -1 + this.back.offsetX; xOff <= 1 + this.back.offsetX; ++xOff) {
            for (int zOff = -1 + this.back.offsetZ; zOff <= 1 + this.back.offsetZ; ++zOff) {
                if (xOff == 0 && zOff == 0) continue;
                IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xOff, 0, zOff);
                if (this.checkCasingBlock(xOff, 0, zOff) || this.addMaintenanceToMachineList(tTileEntity, this.casingTextureIndex) || this.addInputToMachineList(tTileEntity, this.casingTextureIndex) || this.addOutputToMachineList(tTileEntity, this.casingTextureIndex) || this.addEnergyInputToMachineList(tTileEntity, this.casingTextureIndex) || this.addDataAccessToMachineList(tTileEntity, this.casingTextureIndex)) continue;
                return false;
            }
        }
        if (!this.checkHatches()) {
            return false;
        }
        if (GT_Utility.getTier(this.getMaxInputVoltage()) < this.getMinTier()) {
            return false;
        }
        for (int yOff = 1; yOff < 4; ++yOff) {
            if (this.checkCasingBlock(this.back.offsetX, yOff, this.back.offsetZ) && this.checkFrameBlock(this.back.offsetX + 1, yOff, this.back.offsetZ) && this.checkFrameBlock(this.back.offsetX - 1, yOff, this.back.offsetZ) && this.checkFrameBlock(this.back.offsetX, yOff, this.back.offsetZ + 1) && this.checkFrameBlock(this.back.offsetX, yOff, this.back.offsetZ - 1) && this.checkFrameBlock(this.back.offsetX, yOff + 3, this.back.offsetZ)) continue;
            return false;
        }
        return true;
    }

    private void updateCoordinates() {
        this.xDrill = this.getBaseMetaTileEntity().getXCoord();
        this.yDrill = this.getBaseMetaTileEntity().getYCoord();
        this.zDrill = this.getBaseMetaTileEntity().getZCoord();
        this.back = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing());
        this.xPipe = this.xDrill + this.back.offsetX;
        this.zPipe = this.zDrill + this.back.offsetZ;
    }

    private boolean checkPipesAndSetYHead() {
        this.yHead = this.yDrill - 1;
        while (this.checkBlockAndMeta(this.xPipe, this.yHead, this.zPipe, miningPipeBlock, Short.MAX_VALUE)) {
            --this.yHead;
        }
        if (this.checkBlockAndMeta(this.xPipe, this.yHead, this.zPipe, miningPipeTipBlock, Short.MAX_VALUE) || ++this.yHead == this.yDrill) {
            return true;
        }
        this.getBaseMetaTileEntity().getWorld().func_147449_b(this.xPipe, this.yHead, this.zPipe, miningPipeTipBlock);
        return true;
    }

    protected boolean checkCasingBlock(int xOff, int yOff, int zOff) {
        return this.checkBlockAndMetaOffset(xOff, yOff, zOff, this.casingBlock, this.casingMeta);
    }

    protected boolean checkFrameBlock(int xOff, int yOff, int zOff) {
        return this.checkBlockAndMetaOffset(xOff, yOff, zOff, GregTech_API.sBlockMachines, this.frameMeta);
    }

    protected boolean checkBlockAndMetaOffset(int xOff, int yOff, int zOff, Block block, int meta) {
        return this.checkBlockAndMeta(this.xDrill + xOff, this.yDrill + yOff, this.zDrill + zOff, block, meta);
    }

    private boolean checkBlockAndMeta(int x, int y, int z, Block block, int meta) {
        return (meta == Short.MAX_VALUE || this.getBaseMetaTileEntity().getMetaID(x, y, z) == meta) && this.getBaseMetaTileEntity().getBlock(x, y, z) == block;
    }

    protected boolean waitForPipes() {
        if (this.canLowerPipe()) {
            this.mMaxProgresstime = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public abstract Object getClientGUI(int var1, InventoryPlayer var2, IGregTechTileEntity var3);

    protected abstract ItemList getCasingBlockItem();

    protected abstract Materials getFrameMaterial();

    protected abstract int getCasingTextureIndex();

    protected abstract int getMinTier();

    protected abstract boolean checkHatches();

    protected abstract void setElectricityStats();

    public int getTotalConfigValue() {
        int config = 0;
        ArrayList<ItemStack> tCircuitList = this.getDataItems(1);
        for (ItemStack tCircuit : tCircuitList) {
            config += tCircuit.func_77960_j();
        }
        return config;
    }

    private boolean isCorrectDataItem(ItemStack aStack, int state) {
        if ((state & 1) != 0 && ItemList.Circuit_Integrated.isStackEqual(aStack, true, true)) {
            return true;
        }
        if ((state & 2) != 0 && ItemList.Tool_DataStick.isStackEqual(aStack, false, true)) {
            return true;
        }
        return (state & 4) != 0 && ItemList.Tool_DataOrb.isStackEqual(aStack, false, true);
    }

    public ArrayList<ItemStack> getDataItems(int state) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (GT_Utility.isStackValid(this.mInventory[1]) && this.isCorrectDataItem(this.mInventory[1], state)) {
            rList.add(this.mInventory[1]);
        }
        for (GT_MetaTileEntity_Hatch_DataAccess tHatch : this.mDataAccessHatches) {
            if (!GT_MetaTileEntity_DrillerBase.isValidMetaTileEntity(tHatch)) continue;
            for (int i = 0; i < tHatch.getBaseMetaTileEntity().func_70302_i_(); ++i) {
                if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null || !this.isCorrectDataItem(tHatch.getBaseMetaTileEntity().func_70301_a(i), state)) continue;
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    public boolean addDataAccessToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DataAccess) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).mMachineBlock = (byte)aBaseCasingIndex;
            return this.mDataAccessHatches.add((GT_MetaTileEntity_Hatch_DataAccess)aMetaTileEntity);
        }
        return false;
    }
}

