/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_MetaTileEntity_OreDrillingPlantBase
extends GT_MetaTileEntity_MultiBlockBase {
    private static final ItemStack miningPipe = GT_ModHandler.getIC2Item("miningPipe", 0L);
    private static final ItemStack miningPipeTip = GT_ModHandler.getIC2Item("miningPipeTip", 0L);
    private static final Block miningPipeBlock = GT_Utility.getBlockFromStack(miningPipe);
    private static final Block miningPipeTipBlock = GT_Utility.getBlockFromStack(miningPipeTip);
    private final ArrayList<ChunkPosition> oreBlockPositions = new ArrayList();
    private Block casingBlock;
    private int casingMeta;
    private int frameMeta;
    private int casingTextureIndex;
    private ForgeDirection back;
    private int xDrill;
    private int yDrill;
    private int zDrill;
    private int xCenter;
    private int zCenter;
    private int yHead;
    private boolean isPickingPipes;

    public GT_MetaTileEntity_OreDrillingPlantBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.initFields();
    }

    public GT_MetaTileEntity_OreDrillingPlantBase(String aName) {
        super(aName);
        this.initFields();
    }

    private void initFields() {
        this.casingBlock = this.getCasingBlockItem().getBlock();
        this.casingMeta = this.getCasingBlockItem().get(0L, new Object[0]).func_77960_j();
        int frameId = 4096 + this.getFrameMaterial().mMetaItemSubID;
        this.frameMeta = GregTech_API.METATILEENTITIES[frameId] != null ? (int)GregTech_API.METATILEENTITIES[frameId].getTileEntityBaseType() : Short.MAX_VALUE;
        this.casingTextureIndex = this.getCasingTextureIndex();
        this.isPickingPipes = false;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[this.casingTextureIndex], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_ORE_DRILL_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_ORE_DRILL)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[this.casingTextureIndex]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "OreDrillingPlant.png");
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("isPickingPipes", this.isPickingPipes);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.isPickingPipes = aNBT.func_74767_n("isPickingPipes");
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        this.setElectricityStats();
        int oldYHead = this.yHead;
        if (!this.checkPipesAndSetYHead() || !this.isEnergyEnough()) {
            this.stopMachine();
            return false;
        }
        if (this.yHead != oldYHead) {
            this.oreBlockPositions.clear();
        }
        if (this.isPickingPipes) {
            if (this.tryPickPipe()) {
                this.mOutputItems = new ItemStack[]{GT_Utility.copyAmount(1L, miningPipe)};
                return true;
            }
            this.isPickingPipes = false;
            this.stopMachine();
            return false;
        }
        this.putMiningPipesFromInputsInController();
        if (!this.tryConsumeDrillingFluid()) {
            return false;
        }
        this.fillMineListIfEmpty();
        if (this.oreBlockPositions.isEmpty()) {
            if (!this.tryLowerPipe()) {
                this.isPickingPipes = true;
                return true;
            }
            this.fillMineListIfEmpty();
        }
        ChunkPosition oreBlockPos = null;
        Block oreBlock = null;
        while (!(oreBlock != null && oreBlock != Blocks.field_150350_a || this.oreBlockPositions.isEmpty())) {
            oreBlockPos = this.oreBlockPositions.remove(0);
            oreBlock = this.getBaseMetaTileEntity().getBlock(oreBlockPos.field_151329_a, oreBlockPos.field_151327_b, oreBlockPos.field_151328_c);
        }
        if (oreBlock != null && oreBlock != Blocks.field_150350_a) {
            ArrayList<ItemStack> oreBlockDrops = this.getBlockDrops(oreBlock, oreBlockPos.field_151329_a, oreBlockPos.field_151327_b, oreBlockPos.field_151328_c);
            this.getBaseMetaTileEntity().getWorld().func_147468_f(oreBlockPos.field_151329_a, oreBlockPos.field_151327_b, oreBlockPos.field_151328_c);
            this.mOutputItems = this.getOutputByDrops(oreBlockDrops);
        }
        return true;
    }

    private boolean isEnergyEnough() {
        long requiredEnergy = 512L + this.getMaxInputVoltage() * 4L;
        for (GT_MetaTileEntity_Hatch_Energy energyHatch : this.mEnergyHatches) {
            if ((requiredEnergy -= energyHatch.getEUVar()) > 0L) continue;
            return true;
        }
        return false;
    }

    private boolean tryPickPipe() {
        if (this.yHead == this.yDrill) {
            return false;
        }
        if (this.checkBlockAndMeta(this.xCenter, this.yHead + 1, this.zCenter, miningPipeBlock, Short.MAX_VALUE)) {
            this.getBaseMetaTileEntity().getWorld().func_147449_b(this.xCenter, this.yHead + 1, this.zCenter, miningPipeTipBlock);
        }
        this.getBaseMetaTileEntity().getWorld().func_147468_f(this.xCenter, this.yHead, this.zCenter);
        return true;
    }

    private void setElectricityStats() {
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
        int overclock = 1 << GT_Utility.getTier(this.getMaxInputVoltage()) - 1;
        this.mEUt = -12 * overclock * overclock;
        this.mMaxProgresstime = (this.isPickingPipes ? 80 : this.getBaseProgressTime()) / overclock;
    }

    private ItemStack[] getOutputByDrops(ArrayList<ItemStack> oreBlockDrops) {
        long voltage = this.getMaxInputVoltage();
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        while (!oreBlockDrops.isEmpty()) {
            ItemStack currentItem = oreBlockDrops.remove(0).func_77946_l();
            if (!this.doUseMaceratorRecipe(currentItem)) {
                this.multiplyStackSize(currentItem);
                outputItems.add(currentItem);
                continue;
            }
            GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sMaceratorRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, voltage, null, currentItem);
            if (tRecipe == null) {
                outputItems.add(currentItem);
                continue;
            }
            for (int i = 0; i < tRecipe.mOutputs.length; ++i) {
                ItemStack recipeOutput = tRecipe.mOutputs[i].func_77946_l();
                if (this.getBaseMetaTileEntity().getRandomNumber(10000) < tRecipe.getOutputChance(i)) {
                    this.multiplyStackSize(recipeOutput);
                }
                outputItems.add(recipeOutput);
            }
        }
        return outputItems.toArray(new ItemStack[0]);
    }

    private boolean doUseMaceratorRecipe(ItemStack currentItem) {
        ItemData itemData = GT_OreDictUnificator.getItemData(currentItem);
        return itemData == null || itemData.mPrefix != OrePrefixes.crushed && itemData.mPrefix != OrePrefixes.dustImpure && itemData.mPrefix != OrePrefixes.dust && itemData.mMaterial.mMaterial != Materials.Oilsands;
    }

    private void multiplyStackSize(ItemStack itemStack) {
        itemStack.field_77994_a *= this.getBaseMetaTileEntity().getRandomNumber(4) + 1;
    }

    private ArrayList<ItemStack> getBlockDrops(final Block oreBlock, int posX, int posY, int posZ) {
        final byte blockMeta = this.getBaseMetaTileEntity().getMetaID(posX, posY, posZ);
        if (oreBlock.canSilkHarvest(this.getBaseMetaTileEntity().getWorld(), null, posX, posY, posZ, (int)blockMeta)) {
            return new ArrayList<ItemStack>(){
                {
                    this.add(new ItemStack(oreBlock, 1, blockMeta));
                }
            };
        }
        return oreBlock.getDrops(this.getBaseMetaTileEntity().getWorld(), posX, posY, posZ, (int)blockMeta, 1);
    }

    private boolean tryConsumeDrillingFluid() {
        return this.depleteInput(new FluidStack(ItemList.sDrillingFluid, 2000));
    }

    private void putMiningPipesFromInputsInController() {
        int maxPipes = miningPipe.func_77976_d();
        if (this.isHasMiningPipes(maxPipes)) {
            return;
        }
        ItemStack pipes = this.func_70301_a(1);
        for (ItemStack storedItem : this.getStoredInputs()) {
            if (!storedItem.func_77969_a(miningPipe)) continue;
            if (pipes == null) {
                this.func_70299_a(1, GT_Utility.copy(miningPipe));
                pipes = this.func_70301_a(1);
            }
            if (pipes.field_77994_a == maxPipes) break;
            int needPipes = maxPipes - pipes.field_77994_a;
            int transferPipes = storedItem.field_77994_a < needPipes ? storedItem.field_77994_a : needPipes;
            pipes.field_77994_a += transferPipes;
            storedItem.field_77994_a -= transferPipes;
        }
        this.updateSlots();
    }

    private void fillMineListIfEmpty() {
        if (!this.oreBlockPositions.isEmpty()) {
            return;
        }
        this.tryAddOreBlockToMineList(this.xCenter, this.yHead - 1, this.zCenter);
        if (this.yHead == this.yDrill) {
            return;
        }
        int radius = this.getRadiusInChunks() << 4;
        for (int xOff = -radius; xOff <= radius; ++xOff) {
            for (int zOff = -radius; zOff <= radius; ++zOff) {
                this.tryAddOreBlockToMineList(this.xDrill + xOff, this.yHead, this.zDrill + zOff);
            }
        }
    }

    private void tryAddOreBlockToMineList(int x, int y, int z) {
        Block block = this.getBaseMetaTileEntity().getBlock(x, y, z);
        byte blockMeta = this.getBaseMetaTileEntity().getMetaID(x, y, z);
        ChunkPosition blockPos = new ChunkPosition(x, y, z);
        if (this.oreBlockPositions.contains(blockPos)) {
            return;
        }
        if (block instanceof GT_Block_Ores_Abstract) {
            TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntity(x, y, z);
            if (tTileEntity != null && tTileEntity instanceof GT_TileEntity_Ores && ((GT_TileEntity_Ores)tTileEntity).mNatural) {
                this.oreBlockPositions.add(blockPos);
            }
        } else {
            ItemData association = GT_OreDictUnificator.getAssociation(new ItemStack(block, 1, (int)blockMeta));
            if (association != null && association.mPrefix.toString().startsWith("ore")) {
                this.oreBlockPositions.add(blockPos);
            }
        }
    }

    private boolean tryLowerPipe() {
        if (!this.isHasMiningPipes()) {
            return false;
        }
        if (this.yHead <= 0) {
            return false;
        }
        if (this.checkBlockAndMeta(this.xCenter, this.yHead - 1, this.zCenter, Blocks.field_150357_h, Short.MAX_VALUE)) {
            return false;
        }
        this.getBaseMetaTileEntity().getWorld().func_147449_b(this.xCenter, this.yHead - 1, this.zCenter, miningPipeTipBlock);
        if (this.yHead != this.yDrill) {
            this.getBaseMetaTileEntity().getWorld().func_147449_b(this.xCenter, this.yHead, this.zCenter, miningPipeBlock);
        }
        this.getBaseMetaTileEntity().func_70298_a(1, 1);
        return true;
    }

    private boolean isHasMiningPipes() {
        return this.isHasMiningPipes(1);
    }

    private boolean isHasMiningPipes(int minCount) {
        ItemStack pipe = this.func_70301_a(1);
        return pipe != null && pipe.field_77994_a > minCount - 1 && pipe.func_77969_a(miningPipe);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.updateCoordinates();
        for (int xOff = -1 + this.back.offsetX; xOff <= 1 + this.back.offsetX; ++xOff) {
            for (int zOff = -1 + this.back.offsetZ; zOff <= 1 + this.back.offsetZ; ++zOff) {
                if (xOff == 0 && zOff == 0) continue;
                IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xOff, 0, zOff);
                if (this.checkCasingBlock(xOff, 0, zOff) || this.addMaintenanceToMachineList(tTileEntity, this.casingTextureIndex) || this.addInputToMachineList(tTileEntity, this.casingTextureIndex) || this.addOutputToMachineList(tTileEntity, this.casingTextureIndex) || this.addEnergyInputToMachineList(tTileEntity, this.casingTextureIndex)) continue;
                return false;
            }
        }
        if (this.mMaintenanceHatches.isEmpty() || this.mInputHatches.isEmpty() || this.mOutputBusses.isEmpty() || this.mEnergyHatches.isEmpty()) {
            return false;
        }
        if (GT_Utility.getTier(this.getMaxInputVoltage()) < this.getMinTier()) {
            return false;
        }
        for (int yOff = 1; yOff < 4; ++yOff) {
            if (this.checkCasingBlock(this.back.offsetX, yOff, this.back.offsetZ) && this.checkFrameBlock(this.back.offsetX + 1, yOff, this.back.offsetZ) && this.checkFrameBlock(this.back.offsetX - 1, yOff, this.back.offsetZ) && this.checkFrameBlock(this.back.offsetX, yOff, this.back.offsetZ + 1) && this.checkFrameBlock(this.back.offsetX, yOff, this.back.offsetZ - 1) && this.checkFrameBlock(this.back.offsetX, yOff + 3, this.back.offsetZ)) continue;
            return false;
        }
        return true;
    }

    private void updateCoordinates() {
        this.xDrill = this.getBaseMetaTileEntity().getXCoord();
        this.yDrill = this.getBaseMetaTileEntity().getYCoord();
        this.zDrill = this.getBaseMetaTileEntity().getZCoord();
        this.back = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing());
        this.xCenter = this.xDrill + this.back.offsetX;
        this.zCenter = this.zDrill + this.back.offsetZ;
    }

    private boolean checkPipesAndSetYHead() {
        this.yHead = this.yDrill - 1;
        while (this.checkBlockAndMeta(this.xCenter, this.yHead, this.zCenter, miningPipeBlock, Short.MAX_VALUE)) {
            --this.yHead;
        }
        if (this.checkBlockAndMeta(this.xCenter, this.yHead, this.zCenter, miningPipeTipBlock, Short.MAX_VALUE) || ++this.yHead == this.yDrill) {
            return true;
        }
        this.getBaseMetaTileEntity().getWorld().func_147449_b(this.xCenter, this.yHead, this.zCenter, miningPipeTipBlock);
        return true;
    }

    private boolean checkCasingBlock(int xOff, int yOff, int zOff) {
        return this.checkBlockAndMetaOffset(xOff, yOff, zOff, this.casingBlock, this.casingMeta);
    }

    private boolean checkFrameBlock(int xOff, int yOff, int zOff) {
        return this.checkBlockAndMetaOffset(xOff, yOff, zOff, GregTech_API.sBlockMachines, this.frameMeta);
    }

    private boolean checkBlockAndMetaOffset(int xOff, int yOff, int zOff, Block block, int meta) {
        return this.checkBlockAndMeta(this.xDrill + xOff, this.yDrill + yOff, this.zDrill + zOff, block, meta);
    }

    private boolean checkBlockAndMeta(int x, int y, int z, Block block, int meta) {
        return (meta == Short.MAX_VALUE || this.getBaseMetaTileEntity().getMetaID(x, y, z) == meta) && this.getBaseMetaTileEntity().getBlock(x, y, z) == block;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    protected abstract ItemList getCasingBlockItem();

    protected abstract Materials getFrameMaterial();

    protected abstract int getCasingTextureIndex();

    protected abstract int getRadiusInChunks();

    protected abstract int getMinTier();

    protected abstract int getBaseProgressTime();

    protected String[] getDescriptionInternal(String tierSuffix) {
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        return new String[]{"Controller Block for the Ore Drilling Plant " + (tierSuffix != null ? tierSuffix : ""), "Size(WxHxD): 3x7x3, Controller (Front middle bottom)", "3x1x3 Base of " + casings, "1x3x1 " + casings + " pillar (Center of base)", "1x3x1 " + this.getFrameMaterial().mName + " Frame Boxes (Each pillar side and on top)", "1x Input Hatch for drilling fluid (Any bottom layer casing)", "1x Input Bus for mining pipes (Any bottom layer casing; not necessary)", "1x Output Bus (Any bottom layer casing)", "1x Maintenance Hatch (Any bottom layer casing)", "1x " + GT_Values.VN[this.getMinTier()] + "+ Energy Hatch (Any bottom layer casing)", "Radius is " + (this.getRadiusInChunks() << 4) + " blocks"};
    }
}

