/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.postload;

import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.parts.AEBasePart;
import appeng.parts.p2p.PartP2PIC2Power;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Utility;
import java.lang.reflect.Field;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PartP2PGTPower
extends PartP2PIC2Power
implements IGridTickable {
    public PartP2PGTPower(ItemStack is) {
        super(is);
    }

    public final World getWorld() {
        return this.getTile().func_145831_w();
    }

    public final int getXCoord() {
        return this.getTile().field_145851_c;
    }

    public final short getYCoord() {
        return (short)this.getTile().field_145848_d;
    }

    public final int getZCoord() {
        return this.getTile().field_145849_e;
    }

    public final int getOffsetX(byte aSide, int aMultiplier) {
        return this.getXCoord() + ForgeDirection.getOrientation((int)aSide).offsetX * aMultiplier;
    }

    public final short getOffsetY(byte aSide, int aMultiplier) {
        return (short)(this.getYCoord() + ForgeDirection.getOrientation((int)aSide).offsetY * aMultiplier);
    }

    public final int getOffsetZ(byte aSide, int aMultiplier) {
        return this.getZCoord() + ForgeDirection.getOrientation((int)aSide).offsetZ * aMultiplier;
    }

    public final TileEntity getTileEntity(int aX, int aY, int aZ) {
        return this.getWorld().func_147438_o(aX, aY, aZ);
    }

    public final TileEntity getTileEntityAtSide(byte aSide) {
        int tX = this.getOffsetX(aSide, 1);
        short tY = this.getOffsetY(aSide, 1);
        int tZ = this.getOffsetZ(aSide, 1);
        return this.getWorld().func_147438_o(tX, (int)tY, tZ);
    }

    public boolean outputEnergy() {
        if (this.getOfferedEnergy() == 0.0) {
            return false;
        }
        TileEntity t = this.getTileEntityAtSide((byte)this.getSide().ordinal());
        if (t instanceof IEnergyConnected) {
            long voltage = 8 << this.getSourceTier() * 2;
            if ((double)voltage > this.getOfferedEnergy()) {
                voltage = (long)this.getOfferedEnergy();
            }
            if (((IEnergyConnected)t).injectEnergyUnits(GT_Utility.getOppositeSide(this.getSide().ordinal()), voltage, 1L) > 0L) {
                this.drawEnergy(voltage);
                return true;
            }
        }
        return false;
    }

    public TickingRequest getTickingRequest(IGridNode iGridNode) {
        return new TickingRequest(1, 20, false, false);
    }

    public TickRateModulation tickingRequest(IGridNode iGridNode, int i) {
        return this.outputEnergy() ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    public ForgeDirection getSide() {
        try {
            Field fSide = AEBasePart.class.getDeclaredField("side");
            fSide.setAccessible(true);
            return (ForgeDirection)fSide.get((Object)this);
        }
        catch (Exception e) {
            GT_Log.out.println("A fatal error occured at the P2P tunnel for GT electricity");
            e.printStackTrace(GT_Log.out);
            throw new RuntimeException(e);
        }
    }
}

