/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.api.container;

import java.util.function.BiFunction;
import javax.annotation.Nullable;
import mcjty.lib.api.container.IGenericContainer;
import mcjty.lib.tileentity.GenericEnergyStorage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class DefaultContainerProvider<C extends IGenericContainer>
implements INamedContainerProvider {
    private final String name;
    private BiFunction<Integer, PlayerEntity, C> containerSupplier;
    private LazyOptional<? extends IItemHandler> itemHandler = LazyOptional.empty();
    private LazyOptional<? extends GenericEnergyStorage> energyHandler = LazyOptional.empty();

    public DefaultContainerProvider(String name) {
        this.name = name;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.name);
    }

    public DefaultContainerProvider<C> containerSupplier(BiFunction<Integer, PlayerEntity, C> containerSupplier) {
        this.containerSupplier = containerSupplier;
        return this;
    }

    public DefaultContainerProvider<C> itemHandler(LazyOptional<? extends IItemHandler> itemHandler) {
        this.itemHandler = itemHandler;
        return this;
    }

    public DefaultContainerProvider<C> energyHandler(LazyOptional<? extends GenericEnergyStorage> energyHandler) {
        this.energyHandler = energyHandler;
        return this;
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        IGenericContainer container = (IGenericContainer)this.containerSupplier.apply(windowId, playerEntity);
        this.itemHandler.ifPresent(h -> container.setupInventories((IItemHandler)h, playerInventory));
        this.energyHandler.ifPresent(e -> e.addIntegerListeners(container));
        return container.getAsContainer();
    }
}

