/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.varia.Logging;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public class NetworkTools {
    public static FluidStack readFluidStack(ByteBuf dataIn) {
        PacketBuffer buf = new PacketBuffer(dataIn);
        CompoundNBT nbt = buf.func_150793_b();
        return FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt);
    }

    public static void writeFluidStack(ByteBuf dataOut, FluidStack fluidStack) {
        PacketBuffer buf = new PacketBuffer(dataOut);
        CompoundNBT nbt = new CompoundNBT();
        fluidStack.writeToNBT(nbt);
        try {
            buf.func_150786_a(nbt);
        }
        catch (RuntimeException e) {
            Logging.logError("Error writing fluid stack", e);
        }
    }

    public static CompoundNBT readTag(ByteBuf dataIn) {
        PacketBuffer buf = new PacketBuffer(dataIn);
        return buf.func_150793_b();
    }

    public static void writeTag(ByteBuf dataOut, CompoundNBT tag) {
        PacketBuffer buf = new PacketBuffer(dataOut);
        try {
            buf.func_150786_a(tag);
        }
        catch (RuntimeException e) {
            Logging.logError("Error writing tag", e);
        }
    }

    public static ItemStack readItemStack(ByteBuf dataIn) {
        PacketBuffer buf = new PacketBuffer(dataIn);
        CompoundNBT nbt = buf.func_150793_b();
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbt);
        int amount = buf.readInt();
        if (amount <= 0) {
            stack.func_190920_e(0);
        } else {
            stack.func_190920_e(amount);
        }
        return stack;
    }

    public static void writeItemStack(ByteBuf dataOut, @Nonnull ItemStack itemStack) {
        PacketBuffer buf = new PacketBuffer(dataOut);
        CompoundNBT nbt = new CompoundNBT();
        itemStack.func_77955_b(nbt);
        try {
            buf.func_150786_a(nbt);
            buf.writeInt(itemStack.func_190916_E());
        }
        catch (RuntimeException e) {
            Logging.logError("Error writing item stack", e);
        }
    }

    public static String readString(ByteBuf dataIn) {
        int s = dataIn.readInt();
        if (s == -1) {
            return null;
        }
        if (s == 0) {
            return "";
        }
        byte[] dst = new byte[s];
        dataIn.readBytes(dst);
        return new String(dst);
    }

    public static void writeString(ByteBuf dataOut, String str) {
        if (str == null) {
            dataOut.writeInt(-1);
            return;
        }
        byte[] bytes = str.getBytes();
        dataOut.writeInt(bytes.length);
        if (bytes.length > 0) {
            dataOut.writeBytes(bytes);
        }
    }

    public static String readStringUTF8(ByteBuf dataIn) {
        int s = dataIn.readInt();
        if (s == -1) {
            return null;
        }
        if (s == 0) {
            return "";
        }
        byte[] dst = new byte[s];
        dataIn.readBytes(dst);
        return new String(dst, StandardCharsets.UTF_8);
    }

    public static void writeStringUTF8(ByteBuf dataOut, String str) {
        if (str == null) {
            dataOut.writeInt(-1);
            return;
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        dataOut.writeInt(bytes.length);
        if (bytes.length > 0) {
            dataOut.writeBytes(bytes);
        }
    }

    public static void writeStringList(ByteBuf dataOut, @Nonnull List<String> list) {
        dataOut.writeInt(list.size());
        list.stream().forEach(s -> NetworkTools.writeStringUTF8(dataOut, s));
    }

    @Nonnull
    public static List<String> readStringList(ByteBuf dataIn) {
        int size = dataIn.readInt();
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            list.add(NetworkTools.readStringUTF8(dataIn));
        }
        return list;
    }

    public static BlockPos readPos(ByteBuf dataIn) {
        if (((Boolean)GeneralConfig.tallChunkFriendly.get()).booleanValue()) {
            return new BlockPos(dataIn.readInt(), dataIn.readInt(), dataIn.readInt());
        }
        return BlockPos.func_218283_e((long)dataIn.readLong());
    }

    public static void writePos(ByteBuf dataOut, BlockPos pos) {
        if (((Boolean)GeneralConfig.tallChunkFriendly.get()).booleanValue()) {
            dataOut.writeInt(pos.func_177958_n());
            dataOut.writeInt(pos.func_177956_o());
            dataOut.writeInt(pos.func_177952_p());
        } else {
            dataOut.writeLong(pos.func_218275_a());
        }
    }

    public static <T extends Enum<T>> void writeEnum(ByteBuf buf, T value, T nullValue) {
        if (value == null) {
            buf.writeInt(nullValue.ordinal());
        } else {
            buf.writeInt(value.ordinal());
        }
    }

    public static <T extends Enum<T>> T readEnum(ByteBuf buf, T[] values) {
        return values[buf.readInt()];
    }

    public static <T extends Enum<T>> void writeEnumCollection(ByteBuf buf, Collection<T> collection) {
        buf.writeInt(collection.size());
        for (Enum type : collection) {
            buf.writeInt(type.ordinal());
        }
    }

    public static <T extends Enum<T>> void readEnumCollection(ByteBuf buf, Collection<T> collection, T[] values) {
        collection.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            collection.add(values[buf.readInt()]);
        }
    }

    public static void writeFloat(ByteBuf buf, Float f) {
        if (f != null) {
            buf.writeBoolean(true);
            buf.writeFloat(f.floatValue());
        } else {
            buf.writeBoolean(false);
        }
    }

    public static Float readFloat(ByteBuf buf) {
        if (buf.readBoolean()) {
            return Float.valueOf(buf.readFloat());
        }
        return null;
    }

    @Nullable
    public static List<BlockPos> readPosList(ByteBuf buf) {
        ArrayList<BlockPos> list = null;
        int size = buf.readInt();
        if (size != -1) {
            list = new ArrayList<BlockPos>(size);
            for (int i = 0; i < size; ++i) {
                BlockPos item = NetworkTools.readPos(buf);
                list.add(item);
            }
        }
        return list;
    }

    public static void writePosList(ByteBuf buf, @Nullable List<BlockPos> list) {
        if (list == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(list.size());
            for (BlockPos item : list) {
                NetworkTools.writePos(buf, item);
            }
        }
    }

    @Nonnull
    public static List<ItemStack> readItemStackList(ByteBuf buf) {
        int size = buf.readInt();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            outputs.add(NetworkTools.readItemStack(buf));
        }
        return outputs;
    }

    public static void writeItemStackList(ByteBuf buf, @Nonnull List<ItemStack> outputs) {
        buf.writeInt(outputs.size());
        for (ItemStack output : outputs) {
            NetworkTools.writeItemStack(buf, output);
        }
    }
}

