/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tileentity;

import mcjty.lib.api.container.IGenericContainer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.EnergyTools;
import net.minecraft.nbt.LongNBT;
import net.minecraft.util.IntReferenceHolder;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;

public class GenericEnergyStorage
implements IEnergyStorage,
INBTSerializable<LongNBT> {
    private final GenericTileEntity tileEntity;
    private final boolean isReceiver;
    private long energy;
    private long capacity;
    private long maxReceive;

    public GenericEnergyStorage(GenericTileEntity tileEntity, boolean isReceiver, long capacity, long maxReceive) {
        this.tileEntity = tileEntity;
        this.isReceiver = isReceiver;
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.energy = 0L;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.isReceiver) {
            if (!this.canReceive()) {
                return 0;
            }
            long energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, (long)maxReceive));
            if (!simulate) {
                this.energy += energyReceived;
                this.tileEntity.markDirtyQuick();
            }
            return (int)energyReceived;
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return EnergyTools.getIntEnergyStored(this.energy, this.capacity);
    }

    public long getEnergy() {
        return this.energy;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void setEnergy(long s) {
        this.energy = s;
    }

    public void consumeEnergy(long energy) {
        this.energy -= energy;
        if (this.energy < 0L) {
            this.energy = 0L;
        } else if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
        this.tileEntity.markDirtyQuick();
    }

    public void produceEnergy(long energy) {
        this.energy += energy;
        if (this.energy < 0L) {
            this.energy = 0L;
        } else if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
        this.tileEntity.markDirtyQuick();
    }

    public LongNBT serializeNBT() {
        return new LongNBT(this.energy);
    }

    public void deserializeNBT(LongNBT nbt) {
        this.energy = nbt.func_150291_c();
    }

    public int getMaxEnergyStored() {
        return EnergyTools.unsignedClampToInt(this.capacity);
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return this.isReceiver;
    }

    public void addIntegerListeners(IGenericContainer container) {
        container.addIntegerListener(new IntReferenceHolder(){

            public int func_221495_b() {
                return (int)GenericEnergyStorage.this.getEnergy();
            }

            public void func_221494_a(int i) {
                long orig = GenericEnergyStorage.this.getEnergy() & 0xFFFFFFFF00000000L;
                GenericEnergyStorage.this.setEnergy(orig |= (long)i);
            }
        });
        container.addIntegerListener(new IntReferenceHolder(){

            public int func_221495_b() {
                return (int)(GenericEnergyStorage.this.getEnergy() >> 32);
            }

            public void func_221494_a(int i) {
                long orig = GenericEnergyStorage.this.getEnergy() & 0xFFFFFFFFL;
                GenericEnergyStorage.this.setEnergy(orig |= (long)i << 32);
            }
        });
    }
}

