/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.typed;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public final class Type<V> {
    public static final Type<Object> OBJECT = new Type<Object>(Object.class);
    public static final Type<Integer> INTEGER = Type.create(Integer.class);
    public static final Type<Double> DOUBLE = Type.create(Double.class);
    public static final Type<Long> LONG = Type.create(Long.class);
    public static final Type<String> STRING = Type.create(String.class);
    public static final Type<UUID> UUID = Type.create(UUID.class);
    public static final Type<Boolean> BOOLEAN = Type.create(Boolean.class);
    public static final Type<BlockPos> BLOCKPOS = Type.create(BlockPos.class);
    public static final Type<ItemStack> ITEMSTACK = Type.create(ItemStack.class);
    public static final Type<List<String>> STRING_LIST = Type.create(List.class);
    public static final Type<List<ItemStack>> ITEMSTACK_LIST = Type.create(List.class);
    public static final Type<List<BlockPos>> POS_LIST = Type.create(List.class);
    @Nonnull
    private final Class<V> type;

    private Type(@Nonnull Class<V> type) {
        this.type = type;
    }

    @Nonnull
    public static <V> Type<V> create(@Nonnull Class<? super V> type) {
        return new Type<V>(type);
    }

    @Nonnull
    public Class<V> getType() {
        return this.type;
    }

    public boolean isA(Object b) {
        return this.type.isInstance(b);
    }

    @Nonnull
    public List<V> convert(@Nonnull List<?> list) {
        for (Object o : list) {
            if (o == null || this.type.isInstance(o)) continue;
            throw new ClassCastException("Cannot cast List<? super " + o.getClass().getName() + "> to List<" + this.type.getName() + ">");
        }
        return list;
    }

    public V convert(Object o) {
        return this.type.cast(o);
    }

    public String toString() {
        return "Type(" + this.getType().getSimpleName() + ')';
    }
}

