/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.api.power.IBigPower;
import mcjty.lib.compat.EnergySupportDraconic;
import mcjty.lib.compat.EnergySupportEnderIO;
import mcjty.lib.compat.EnergySupportMekanism;
import mcjty.lib.compat.TeslaCompatibility;
import mcjty.lib.varia.IEnergyItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.energy.CapabilityEnergy;

public class EnergyTools {
    private static boolean draconic = false;
    private static boolean mekanism = false;
    private static boolean enderio = false;
    private static boolean checkMods = true;

    public static boolean isEnergyTE(TileEntity te, @Nullable Direction side) {
        if (te == null) {
            return false;
        }
        if (McJtyLib.tesla && TeslaCompatibility.isEnergyHandler(te, side)) {
            return true;
        }
        return te.getCapability(CapabilityEnergy.ENERGY, side).isPresent();
    }

    public static boolean isEnergyItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IEnergyItem) {
            return true;
        }
        if (McJtyLib.tesla && TeslaCompatibility.isEnergyItem(stack)) {
            return true;
        }
        return stack.getCapability(CapabilityEnergy.ENERGY).isPresent();
    }

    private static void doCheckMods() {
        if (checkMods) {
            checkMods = false;
        }
    }

    public static EnergyLevel getEnergyLevelMulti(TileEntity tileEntity, @Nullable Direction side) {
        long energyStored;
        long maxEnergyStored;
        EnergyTools.doCheckMods();
        if (tileEntity instanceof IBigPower) {
            maxEnergyStored = ((IBigPower)tileEntity).getCapacity();
            energyStored = ((IBigPower)tileEntity).getStoredPower();
        } else if (McJtyLib.tesla && TeslaCompatibility.isEnergyHandler(tileEntity, side)) {
            maxEnergyStored = TeslaCompatibility.getMaxEnergy(tileEntity, side);
            energyStored = TeslaCompatibility.getEnergy(tileEntity, side);
        } else if (draconic && EnergySupportDraconic.isDraconicEnergyTile(tileEntity)) {
            maxEnergyStored = EnergySupportDraconic.getMaxEnergy(tileEntity);
            energyStored = EnergySupportDraconic.getCurrentEnergy(tileEntity);
        } else if (mekanism && EnergySupportMekanism.isMekanismTileEntity(tileEntity)) {
            maxEnergyStored = EnergySupportMekanism.getMaxEnergy(tileEntity);
            energyStored = EnergySupportMekanism.getCurrentEnergy(tileEntity);
        } else if (enderio && EnergySupportEnderIO.isEnderioTileEntity(tileEntity)) {
            maxEnergyStored = EnergySupportEnderIO.getMaxEnergy(tileEntity);
            energyStored = EnergySupportEnderIO.getCurrentEnergy(tileEntity);
        } else {
            maxEnergyStored = 0L;
            energyStored = 0L;
        }
        return new EnergyLevel(energyStored, maxEnergyStored);
    }

    public static EnergyLevel getEnergyLevel(TileEntity tileEntity, @Nullable Direction side) {
        AtomicLong maxEnergyStored = new AtomicLong();
        AtomicLong energyStored = new AtomicLong();
        if (McJtyLib.tesla && TeslaCompatibility.isEnergyHandler(tileEntity, side)) {
            maxEnergyStored.set(TeslaCompatibility.getMaxEnergy(tileEntity, side));
            energyStored.set(TeslaCompatibility.getEnergy(tileEntity, side));
        } else if (tileEntity != null) {
            tileEntity.getCapability(CapabilityEnergy.ENERGY, side).ifPresent(handler -> {
                maxEnergyStored.set(handler.getMaxEnergyStored());
                energyStored.set(handler.getEnergyStored());
            });
        } else {
            maxEnergyStored.set(0L);
            energyStored.set(0L);
        }
        return new EnergyLevel(energyStored.get(), maxEnergyStored.get());
    }

    public static long receiveEnergy(TileEntity tileEntity, Direction from, long maxReceive) {
        if (McJtyLib.tesla && TeslaCompatibility.isEnergyReceiver(tileEntity, from)) {
            return TeslaCompatibility.receiveEnergy(tileEntity, from, maxReceive);
        }
        if (tileEntity != null) {
            return ((Integer)tileEntity.getCapability(CapabilityEnergy.ENERGY, from).map(handler -> handler.receiveEnergy(EnergyTools.unsignedClampToInt(maxReceive), false)).orElse((Object)0)).intValue();
        }
        return 0L;
    }

    public static long receiveEnergy(ItemStack stack, long maxReceive) {
        Item item = stack.func_77973_b();
        if (item instanceof IEnergyItem) {
            return ((IEnergyItem)item).receiveEnergyL(stack, maxReceive, false);
        }
        if (McJtyLib.tesla && TeslaCompatibility.isEnergyItem(stack)) {
            return TeslaCompatibility.receiveEnergy(stack, maxReceive, false);
        }
        return ((Integer)stack.getCapability(CapabilityEnergy.ENERGY).map(handler -> handler.receiveEnergy(EnergyTools.unsignedClampToInt(maxReceive), false)).orElse((Object)0)).intValue();
    }

    public static int unsignedClampToInt(long l) {
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    public static int getIntEnergyStored(long energyStored, long maxEnergyStored) {
        return EnergyTools.unsignedClampToInt(energyStored);
    }

    public static class EnergyLevel {
        private final long energy;
        private final long maxEnergy;

        public EnergyLevel(long energy, long maxEnergy) {
            this.energy = energy;
            this.maxEnergy = maxEnergy;
        }

        public long getEnergy() {
            return this.energy;
        }

        public long getMaxEnergy() {
            return this.maxEnergy;
        }
    }
}

