/*
 * Decompiled with CFR 0.152.
 */
package mcjty.restrictions.blocks;

import javax.annotation.Nullable;
import mcjty.restrictions.blocks.GenericTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public abstract class GenericBlock
extends Block {
    public GenericBlock(String name) {
        this(name, Material.field_151573_f);
    }

    public GenericBlock(String name, Material material) {
        super(Block.Properties.func_200945_a((Material)material).func_200943_b(2.0f).func_200947_a(SoundType.field_185852_e));
        this.setRegistryName(name);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public int getHarvestLevel(BlockState state) {
        return 0;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean what) {
        this.checkRedstone(world, pos);
    }

    protected void checkRedstone(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTileEntity) {
            int powered = world.func_175687_A(pos);
            GenericTileEntity pusher = (GenericTileEntity)te;
            pusher.setPower(powered);
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)GenericBlock.getFacingFromEntity(pos, entity)), 2);
        }
    }

    public static Direction getFacingFromEntity(BlockPos clickedBlock, LivingEntity entity) {
        return Direction.func_176737_a((float)((float)(entity.field_70165_t - (double)clickedBlock.func_177958_n())), (float)((float)(entity.field_70163_u - (double)clickedBlock.func_177956_o())), (float)((float)(entity.field_70161_v - (double)clickedBlock.func_177952_p())));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208155_H});
    }
}

