/*
 * Decompiled with CFR 0.152.
 */
package tschipp.primitivecrafting.common.config;

import java.io.File;
import java.lang.invoke.MethodHandle;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import tschipp.primitivecrafting.common.config.Configs;
import tschipp.primitivecrafting.common.helper.ReflectionUtil;

@Config(modid="primitivecrafting")
public class PrimitiveConfig {
    @Config.LangKey(value="primitivecrafting")
    @Config.Comment(value={"General Mod Settings"})
    public static Configs.Settings Settings = new Configs.Settings();
    @Config.LangKey(value="primitivecrafting")
    @Config.Comment(value={"Blacklist for Recipes"})
    public static Configs.Blacklist Blacklist = new Configs.Blacklist();
    @Config.LangKey(value="primitivecrafting")
    @Config.Comment(value={"Whitelist for Recipes"})
    public static Configs.WhiteList Whitelist = new Configs.WhiteList();

    @Mod.EventBusSubscriber
    public static class EventHandler {
        private static final MethodHandle CONFIGS_GETTER = ReflectionUtil.findFieldGetter(ConfigManager.class, "CONFIGS");
        private static Configuration configuration;

        public static Configuration getConfiguration() {
            if (configuration == null) {
                try {
                    String fileName = "primitivecrafting.cfg";
                    Map configsMap = CONFIGS_GETTER.invokeExact();
                    Optional<Map.Entry> entryOptional = configsMap.entrySet().stream().filter(entry -> "primitivecrafting.cfg".equals(new File((String)entry.getKey()).getName())).findFirst();
                    entryOptional.ifPresent(stringConfigurationEntry -> {
                        configuration = (Configuration)stringConfigurationEntry.getValue();
                    });
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            return configuration;
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("primitivecrafting")) {
                ConfigManager.load((String)"primitivecrafting", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

