/*
 * Decompiled with CFR 0.152.
 */
package tschipp.primitivecrafting.common.crafting;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import tschipp.primitivecrafting.common.crafting.PrimitiveRecipe;
import tschipp.primitivecrafting.common.crafting.TransformData;

public class PrimitiveIngredient {
    public Ingredient ingredient;
    protected TransformData[] transformData;
    public int count;

    protected PrimitiveIngredient() {
    }

    public PrimitiveIngredient(Ingredient ingredient, int count) {
        this(ingredient, count, true);
    }

    public PrimitiveIngredient(Ingredient ingredient, int count, boolean init) {
        this.ingredient = ingredient;
        ItemStack[] stacks = ingredient.func_193365_a();
        this.transformData = new TransformData[stacks.length];
        this.count = count;
        if (init) {
            this.initTransformData();
        }
    }

    public void initTransformData() {
        ItemStack[] stacks = this.ingredient.func_193365_a();
        for (int i = 0; i < stacks.length; ++i) {
            TransformData data;
            ItemStack stack = stacks[i];
            if (stack.func_77973_b().hasContainerItem(stack)) {
                ItemStack container = stack.func_77973_b().getContainerItem(stack);
                data = stack.func_77973_b() == container.func_77973_b() ? TransformData.getTransformData(TransformData.TransformType.DAMAGE, container.func_77952_i() - stack.func_77952_i()) : TransformData.getTransformData(TransformData.TransformType.GIVE_BACK, container);
            } else {
                data = TransformData.getTransformData(TransformData.TransformType.SHRINK, this.count);
            }
            this.transformData[i] = data;
        }
    }

    public TransformData getTransformForStack(ItemStack stack) {
        ItemStack[] matchingStacks = this.ingredient.func_193365_a();
        for (int i = 0; i < matchingStacks.length; ++i) {
            ItemStack itemstack = matchingStacks[i];
            boolean equal = PrimitiveRecipe.areStacksEqual(itemstack, stack);
            if (this.ingredient.apply(stack)) {
                equal = true;
            }
            if (!equal) continue;
            return this.transformData[i];
        }
        return null;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        for (ItemStack itemstack : this.ingredient.func_193365_a()) {
            boolean equal = PrimitiveRecipe.areStacksEqual(itemstack, stack);
            if (this.ingredient.apply(stack)) {
                equal = true;
            }
            if (!equal) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.count;
        result = 31 * result + (this.ingredient == null ? 0 : this.ingredient.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PrimitiveIngredient)) {
            return false;
        }
        PrimitiveIngredient other = (PrimitiveIngredient)obj;
        if (other.count != this.count) {
            return false;
        }
        ItemStack[] thisStack = this.ingredient.func_193365_a();
        ItemStack[] otherStack = other.ingredient.func_193365_a();
        boolean equal = true;
        if (thisStack.length != otherStack.length) {
            return false;
        }
        for (int i = 0; i < thisStack.length; ++i) {
            if (ItemStack.func_77989_b((ItemStack)thisStack[i], (ItemStack)otherStack[i])) continue;
            equal = false;
        }
        return equal;
    }
}

