/*
 * Decompiled with CFR 0.152.
 */
package tschipp.primitivecrafting.common.crafting;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import tschipp.primitivecrafting.common.config.PrimitiveConfig;
import tschipp.primitivecrafting.common.crafting.IPrimitiveRecipe;
import tschipp.primitivecrafting.common.crafting.PrimitiveIngredient;
import tschipp.primitivecrafting.common.crafting.PrimitiveRecipe;
import tschipp.primitivecrafting.common.helper.ListHandler;
import tschipp.primitivecrafting.common.helper.StageHelper;

public class RecipeRegistry {
    private static Set<IPrimitiveRecipe> registry = new HashSet<IPrimitiveRecipe>();
    private static Map<Integer, IPrimitiveRecipe> hashRegistry = new HashMap<Integer, IPrimitiveRecipe>();

    public static void registerRecipe(IPrimitiveRecipe recipe) {
        registry.add(recipe);
        hashRegistry.put(recipe.hashCode(), recipe);
    }

    public static void registerRecipe(ItemStack a, ItemStack b, ItemStack result, ResourceLocation loc) {
        PrimitiveRecipe recipe = new PrimitiveRecipe(result, RecipeRegistry.get(a), RecipeRegistry.get(b), loc);
        RecipeRegistry.registerRecipe(recipe);
    }

    public static void registerRecipe(Ingredient a, Ingredient b, ItemStack result, ResourceLocation loc) {
        PrimitiveRecipe recipe = new PrimitiveRecipe(result, new PrimitiveIngredient(a, 1), new PrimitiveIngredient(b, 1), loc);
        RecipeRegistry.registerRecipe(recipe);
    }

    public static void registerRecipe(PrimitiveIngredient a, PrimitiveIngredient b, ItemStack result, ResourceLocation loc) {
        PrimitiveRecipe recipe = new PrimitiveRecipe(result, a, b, loc);
        RecipeRegistry.registerRecipe(recipe);
    }

    public static void removeRecipe(PrimitiveIngredient a, PrimitiveIngredient b, ItemStack result) {
        ArrayList<IPrimitiveRecipe> recipes = new ArrayList<IPrimitiveRecipe>(registry);
        for (int i = 0; i < recipes.size(); ++i) {
            IPrimitiveRecipe r = (IPrimitiveRecipe)recipes.get(i);
            if ((!r.getA().equals(a) || !r.getB().equals(b)) && (!r.getA().equals(b) || !r.getB().equals(a))) continue;
            if (!ItemStack.func_77989_b((ItemStack)result, (ItemStack)r.getResult())) continue;
            registry.remove(r);
        }
    }

    public static PrimitiveIngredient get(ItemStack stack) {
        return new PrimitiveIngredient(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}), stack.func_190916_E());
    }

    public static PrimitiveIngredient get(Ingredient ing) {
        return new PrimitiveIngredient(ing, 1);
    }

    public static List<IPrimitiveRecipe> getValidRecipes(ItemStack a, ItemStack b, EntityPlayer player) {
        ArrayList<IPrimitiveRecipe> valids = new ArrayList<IPrimitiveRecipe>();
        for (IPrimitiveRecipe r : registry) {
            if (!r.isValid(a, b) || !StageHelper.hasStage(player, r.getTier())) continue;
            valids.add(r);
        }
        valids.sort((r1, r2) -> r1.getResult().func_77973_b().getRegistryName().toString().compareTo(r2.getResult().func_77973_b().getRegistryName().toString()));
        return valids;
    }

    @Nullable
    public static IPrimitiveRecipe getFromHash(int hash) {
        return hashRegistry.get(hash);
    }

    public static void regRecipes() {
        if (PrimitiveConfig.Settings.useDefaultCraftingRecipes) {
            for (IRecipe recipe : ForgeRegistries.RECIPES) {
                if (!PrimitiveConfig.Settings.useWhitelist ? ListHandler.isForbidden(recipe) : !ListHandler.isAllowed(recipe)) continue;
                NonNullList ingredients = recipe.func_192400_c();
                if (ingredients.size() == 2) {
                    if (recipe.func_77571_b().func_190926_b()) continue;
                    RecipeRegistry.registerRecipe((Ingredient)ingredients.get(0), (Ingredient)ingredients.get(1), recipe.func_77571_b(), recipe.getRegistryName());
                    continue;
                }
                if (ingredients.size() <= 1 || !PrimitiveConfig.Settings.recipesWithMultipleIngredients) continue;
                ArrayList<PrimitiveIngredient> sameIngredients = new ArrayList<PrimitiveIngredient>();
                for (Ingredient i : ingredients) {
                    if (i.func_193365_a().length == 0) continue;
                    if (sameIngredients.isEmpty()) {
                        sameIngredients.add(new PrimitiveIngredient(i, 1, false));
                        continue;
                    }
                    boolean newIngredient = true;
                    for (int k = 0; k < sameIngredients.size(); ++k) {
                        PrimitiveIngredient pI = (PrimitiveIngredient)sameIngredients.get(k);
                        if (!RecipeRegistry.areIngredientsEqual(pI.ingredient, i)) continue;
                        ++pI.count;
                        newIngredient = false;
                        break;
                    }
                    if (!newIngredient) continue;
                    sameIngredients.add(new PrimitiveIngredient(i, 1));
                }
                for (PrimitiveIngredient ing : sameIngredients) {
                    ing.initTransformData();
                }
                if (sameIngredients.size() == 2) {
                    if (recipe.func_77571_b().func_190926_b()) continue;
                    RecipeRegistry.registerRecipe((PrimitiveIngredient)sameIngredients.get(0), (PrimitiveIngredient)sameIngredients.get(1), recipe.func_77571_b(), recipe.getRegistryName());
                    continue;
                }
                if (sameIngredients.size() != 1) continue;
                int amount1 = ((PrimitiveIngredient)sameIngredients.get((int)0)).count / 2;
                int amount2 = ((PrimitiveIngredient)sameIngredients.get((int)0)).count - amount1;
                if (recipe.func_77571_b().func_190926_b()) continue;
                RecipeRegistry.registerRecipe(new PrimitiveIngredient(((PrimitiveIngredient)sameIngredients.get((int)0)).ingredient, amount1), new PrimitiveIngredient(((PrimitiveIngredient)sameIngredients.get((int)0)).ingredient, amount2), recipe.func_77571_b(), recipe.getRegistryName());
            }
        }
    }

    public static List<IPrimitiveRecipe> getRecipes() {
        return new ArrayList<IPrimitiveRecipe>(registry);
    }

    public static boolean areIngredientsEqual(Ingredient a, Ingredient b) {
        ItemStack[] thisStack = a.func_193365_a();
        ItemStack[] otherStack = b.func_193365_a();
        boolean equal = true;
        if (thisStack.length != otherStack.length) {
            return false;
        }
        for (int i = 0; i < thisStack.length; ++i) {
            if (PrimitiveRecipe.areStacksEqual(thisStack[i], otherStack[i])) continue;
            equal = false;
        }
        return equal;
    }

    public static String getTierIfStaged(IRecipe recipe) {
        if (Loader.isModLoaded((String)"recipestages")) {
            try {
                Class<?> clazz = Class.forName("com.blamejared.recipestages.recipes.RecipeStage");
                if (clazz.isInstance(recipe)) {
                    Method getTier = ReflectionHelper.findMethod(clazz, (String)"getTier", null, (Class[])new Class[0]);
                    String tier = (String)getTier.invoke((Object)recipe, new Object[0]);
                    return tier;
                }
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public static void initStagedRecipes() {
        if (Loader.isModLoaded((String)"recipestages")) {
            for (IPrimitiveRecipe r : registry) {
                IRecipe parent = (IRecipe)ForgeRegistries.RECIPES.getValue(r.getRegistryName());
                if (parent == null) continue;
                String tier = RecipeRegistry.getTierIfStaged(parent);
                r.setTier(tier);
            }
        }
    }
}

