/*
 * Decompiled with CFR 0.152.
 */
package tschipp.primitivecrafting.common.crafting;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import tschipp.primitivecrafting.common.crafting.PrimitiveRecipe;

public class TransformData {
    private int shrinkAmount = 0;
    private ItemStack giveBack = ItemStack.field_190927_a;
    private ItemStack replace = ItemStack.field_190927_a;
    private int damageApplied = 0;
    private boolean consumeEntire = false;
    public TransformType type;

    protected TransformData() {
    }

    public void transformStack(ItemStack toTransform, EntityPlayer player, boolean isHoverStack, int slot) {
        try {
            switch (this.type) {
                case SHRINK: {
                    toTransform.func_190918_g(this.shrinkAmount);
                    break;
                }
                case REUSE: {
                    break;
                }
                case GIVE_BACK: {
                    if (this.giveBack.func_190926_b()) {
                        PrimitiveRecipe.addItem(player, toTransform.func_77946_l());
                    } else {
                        PrimitiveRecipe.addItem(player, this.giveBack.func_77946_l());
                    }
                    toTransform.func_190918_g(1);
                    break;
                }
                case REPLACE: {
                    if (isHoverStack) {
                        player.field_71071_by.func_70437_b(this.replace.func_77946_l());
                        break;
                    }
                    player.field_71071_by.func_70299_a(slot, this.replace.func_77946_l());
                    break;
                }
                case DAMAGE: {
                    toTransform.func_77972_a(this.damageApplied, (EntityLivingBase)player);
                    break;
                }
                case CONSUME: {
                    toTransform.func_190920_e(0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static TransformData getTransformData(TransformType type, Object ... params) {
        TransformData data = new TransformData();
        data.type = type;
        switch (type) {
            case SHRINK: {
                if (params.length > 0) {
                    data.shrinkAmount = (Integer)params[0];
                    break;
                }
                data.shrinkAmount = 1;
                break;
            }
            case REUSE: {
                break;
            }
            case GIVE_BACK: {
                if (params.length > 0) {
                    data.giveBack = ((ItemStack)params[0]).func_77946_l();
                }
                data.shrinkAmount = 1;
                break;
            }
            case REPLACE: {
                if (params.length <= 0) break;
                data.replace = ((ItemStack)params[0]).func_77946_l();
                break;
            }
            case DAMAGE: {
                if (params.length > 0) {
                    data.damageApplied = (Integer)params[0];
                    break;
                }
                data.damageApplied = 1;
                break;
            }
            case CONSUME: {
                data.consumeEntire = true;
            }
        }
        return data;
    }

    public static enum TransformType {
        SHRINK,
        REUSE,
        GIVE_BACK,
        REPLACE,
        DAMAGE,
        CONSUME;

    }
}

