/*
 * Decompiled with CFR 0.152.
 */
package tschipp.primitivecrafting.compat.crafttweaker;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import tschipp.primitivecrafting.common.crafting.PrimitiveIngredient;
import tschipp.primitivecrafting.common.crafting.PrimitiveRecipe;
import tschipp.primitivecrafting.common.crafting.RecipeRegistry;
import tschipp.primitivecrafting.compat.crafttweaker.CTPrimitiveIngredient;

@ZenRegister
@ZenClass(value="mods.primitivecrafting")
public class CTIntegration {
    private static int recipeCount = 0;

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient a, IIngredient b, String registryName, String gamestage) {
        if (a != null && b != null && output != null && !(a instanceof ILiquidStack) && !(b instanceof ILiquidStack)) {
            ItemStack stackOutput = CraftTweakerMC.getItemStack((IItemStack)output);
            int countA = a.getAmount();
            int countB = b.getAmount();
            if (!stackOutput.func_190926_b()) {
                CTPrimitiveIngredient pA = new CTPrimitiveIngredient(a, countA);
                CTPrimitiveIngredient pB = new CTPrimitiveIngredient(b, countB);
                PrimitiveRecipe recipe = new PrimitiveRecipe(stackOutput, pA, pB, new ResourceLocation(registryName));
                recipe.setTier(gamestage);
                RecipeRegistry.registerRecipe(recipe);
            }
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient a, IIngredient b) {
        CTIntegration.addRecipe(output, a, b, "primitivecrafting:primitive_crafttweaker_recipe_" + recipeCount, "");
        ++recipeCount;
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient a, IIngredient b, String registryName) {
        CTIntegration.addRecipe(output, a, b, registryName, "");
        ++recipeCount;
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output, IIngredient a, IIngredient b) {
        if (a != null && b != null && output != null && !(a instanceof ILiquidStack) && !(b instanceof ILiquidStack)) {
            Ingredient ingA = CraftTweakerMC.getIngredient((IIngredient)a);
            Ingredient ingB = CraftTweakerMC.getIngredient((IIngredient)b);
            ItemStack stackOutput = CraftTweakerMC.getItemStack((IItemStack)output);
            int countA = a.getAmount();
            int countB = b.getAmount();
            if (ingA != null && ingB != null && !stackOutput.func_190926_b()) {
                PrimitiveIngredient pA = new PrimitiveIngredient(ingA, countA);
                PrimitiveIngredient pB = new PrimitiveIngredient(ingB, countB);
                RecipeRegistry.removeRecipe(pA, pB, stackOutput);
            }
        }
    }
}

