/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;
import tamaized.aov.AoV;
import tamaized.aov.client.particle.ParticleColorSpark;
import tamaized.aov.client.particle.ParticleFeather;
import tamaized.aov.client.particle.ParticleHeartColor;
import tamaized.aov.client.particle.ParticleImplosion;
import tamaized.aov.network.client.ClientPacketHandlerParticleMesh;

public class ParticleHelper {
    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticle(ParticleType type, World world, Vec3d pos, Vec3d target, int life, float gravity, float scale, Integer ... colors) {
        int color = colors[world.field_73012_v.nextInt(colors.length)];
        SpriteTexturedParticle particle = null;
        switch (type) {
            case Fluff: {
                break;
            }
            case Heart: {
                particle = new ParticleHeartColor(world, pos, target, life, gravity, scale, color);
                break;
            }
            case Feather: {
                particle = new ParticleFeather(world, pos, target, life, gravity, scale, color);
                break;
            }
            case Spark: {
                Vec3d vec = new Vec3d(1.0, 0.0, 0.0);
                particle = ParticleColorSpark.makeSpark(world, pos.field_72450_a, pos.field_72448_b + 0.75, pos.field_72449_c, -(0.015 * vec.field_72450_a + ((double)world.field_73012_v.nextFloat() * 0.125 - 0.0625)), 0.015 * vec.field_72448_b + ((double)world.field_73012_v.nextFloat() * 0.125 - 0.0625), -(0.015 * vec.field_72449_c + ((double)world.field_73012_v.nextFloat() * 0.125 - 0.0625)), Minecraft.func_71410_x().field_71452_i, color >> 8);
                break;
            }
            case Implosion: {
                particle = ParticleImplosion.make(world, pos.field_72450_a, pos.field_72448_b + 0.75, pos.field_72449_c, target.field_72450_a, target.field_72448_b, target.field_72449_c, Minecraft.func_71410_x().field_71452_i);
            }
        }
        if (particle != null) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
        }
    }

    public static void spawnParticleMesh(MeshType type, ParticleType particle, World world, Vec3d target, int range, int color) {
        if (!world.field_72995_K) {
            AoV.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f(new BlockPos(target.field_72450_a, target.field_72448_b, target.field_72449_c))), (Object)new ClientPacketHandlerParticleMesh(type, particle, target, range, color));
        } else {
            switch (type) {
                case BURST: {
                    ParticleHelper.burstParticles(particle, world, target, range, color);
                    break;
                }
            }
        }
    }

    private static void burstParticles(ParticleType particle, World world, Vec3d pos, int range, int color) {
        int amount = range * 4;
        for (int i = -amount; i <= amount; ++i) {
            double dx = world.field_73012_v.nextFloat() * 0.2f - 0.1f;
            double dz = world.field_73012_v.nextFloat() * 0.2f - 0.1f;
            ParticleHelper.spawnParticle(particle, world, pos, new Vec3d(dx, 0.0, dz), 20 * world.field_73012_v.nextInt(6), -0.01f, world.field_73012_v.nextFloat() * 0.9f - 0.25f, color);
        }
    }

    public static enum ParticleType {
        Fluff,
        Heart,
        Feather,
        Spark,
        Implosion;

    }

    public static enum MeshType {
        BURST;

    }
}

