/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.client;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL11;
import tamaized.aov.AoV;
import tamaized.aov.client.entity.ModelPolymorphWolf;
import tamaized.aov.client.gui.AoVOverlay;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.common.items.Handwraps;

@Mod.EventBusSubscriber(modid="aov", value={Dist.CLIENT})
public class RenderPlayer {
    private static final ResourceLocation TEXTURE_WING = new ResourceLocation("aov", "textures/entity/wing.png");
    private static final ResourceLocation TEXTURE_SUNBODY = new ResourceLocation("aov", "textures/entity/sunbody.png");
    private static final ModelPolymorphWolf WOLF_MODEL = new ModelPolymorphWolf();
    private static final ResourceLocation WOLF_TEXTURES = new ResourceLocation("textures/entity/wolf/wolf.png");
    private static boolean hackyshit = false;

    @SubscribeEvent
    public static void render(RenderPlayerEvent.Pre e) {
        PlayerEntity player = e.getPlayer();
        IPolymorphCapability cap = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.POLYMORPH);
        if (cap != null && cap.getMorph() == IPolymorphCapability.Morph.Wolf) {
            GlStateManager.pushMatrix();
            e.getRenderer().func_177067_a((LivingEntity)((AbstractClientPlayerEntity)player), e.getX(), e.getY(), e.getZ());
            GlStateManager.translated((double)e.getX(), (double)e.getY(), (double)e.getZ());
            float swingProgress = player.field_184619_aG - player.field_70721_aZ * (1.0f - e.getPartialRenderTick());
            float swingAmount = player.field_184618_aE + (player.field_70721_aZ - player.field_184618_aE) * e.getPartialRenderTick();
            if (swingAmount > 1.0f) {
                swingAmount = 1.0f;
            }
            float f = RenderPlayer.interpolateRotation(player.field_70760_ar, player.field_70761_aq, e.getPartialRenderTick());
            float f1 = RenderPlayer.interpolateRotation(player.field_70758_at, player.field_70759_as, e.getPartialRenderTick());
            float netHeadYaw = f1 - f;
            float headPitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * e.getPartialRenderTick();
            float ticksExisted = 1.6650441f;
            RenderPlayer.applyRotations((LivingEntity)player, ticksExisted, f, e.getPartialRenderTick());
            float scale = e.getRenderer().func_188322_c((LivingEntity)((AbstractClientPlayerEntity)player), e.getPartialRenderTick());
            WOLF_MODEL.func_212843_a_((WolfEntity)null, swingProgress, swingAmount, e.getPartialRenderTick());
            WOLF_MODEL.func_212844_a_(null, swingProgress, swingAmount, ticksExisted, netHeadYaw, headPitch, scale);
            e.getRenderer().func_110776_a(WOLF_TEXTURES);
            WOLF_MODEL.func_78088_a(null, swingProgress, swingAmount, ticksExisted, netHeadYaw, headPitch, scale);
            GlStateManager.popMatrix();
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderName(RenderLivingEvent.Specials.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> e) {
        if (hackyshit) {
            return;
        }
        IPolymorphCapability cap = CapabilityList.getCap((ICapabilityProvider)e.getEntity(), CapabilityList.POLYMORPH);
        if (cap != null && (cap.getMorph() == IPolymorphCapability.Morph.WaterElemental || cap.getMorph() == IPolymorphCapability.Morph.FireElemental || cap.getMorph() == IPolymorphCapability.Morph.ArchAngel)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderLiving(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> e) {
        GlStateManager.blendFunc((int)770, (int)771);
        if (!(e.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)e.getEntity();
        IPolymorphCapability cap = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.POLYMORPH);
        if (cap != null) {
            GlStateManager.enableBlend();
            RenderPlayer.enableStencils(cap);
        }
    }

    @SubscribeEvent
    public static void renderLiving(RenderLivingEvent.Post<PlayerEntity, PlayerModel<PlayerEntity>> e) {
        if (!(e.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)e.getEntity();
        IPolymorphCapability cap = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.POLYMORPH);
        if (cap != null && (cap.getMorph() == IPolymorphCapability.Morph.WaterElemental || cap.getMorph() == IPolymorphCapability.Morph.FireElemental || cap.getMorph() == IPolymorphCapability.Morph.ArchAngel)) {
            if (AoVOverlay.NO_STENCIL) {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                RenderPlayer.disableStencils();
                hackyshit = true;
                e.getRenderer().func_177067_a((LivingEntity)player, e.getX(), e.getY(), e.getZ());
                hackyshit = false;
            }
            IAoVCapability aov = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.AOV);
            if (aov != null && cap.getMorph() == IPolymorphCapability.Morph.FireElemental && aov.isAuraActive(Abilities.elementalEmpowerment)) {
                GlStateManager.pushMatrix();
                GlStateManager.translated((double)e.getX(), (double)e.getY(), (double)e.getZ());
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_SUNBODY);
                Tessellator tess = Tessellator.func_178181_a();
                BufferBuilder buffer = tess.func_178180_c();
                GlStateManager.translated((double)0.0, (double)(player.func_70047_e() / 1.5f), (double)0.0);
                GlStateManager.rotatef((float)(180.0f - e.getRenderer().func_177068_d().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotatef((float)((float)(e.getRenderer().func_177068_d().field_78733_k.field_74320_O == 2 ? -1 : 1) * -e.getRenderer().func_177068_d().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
                float r = 1.0f;
                float g = 0.35f;
                float b = 0.0f;
                float a = 1.0f;
                float size = 1.5f;
                float z = 0.0f;
                for (int index = 0; index < 3; ++index) {
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    buffer.func_181662_b((double)(-size), (double)(-size), (double)z).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b((double)size, (double)(-size), (double)z).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b((double)size, (double)size, (double)z).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b((double)(-size), (double)size, (double)z).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
                    GlStateManager.pushMatrix();
                    GlStateManager.rotatef((float)((float)((2 + index * 3) * player.field_70173_aa) + e.getPartialRenderTick()), (float)0.0f, (float)0.0f, (float)((index & 1) == 0 ? 1 : -1));
                    GlStateManager.disableLighting();
                    int j = 240;
                    int k = 240;
                    GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)j, (float)k);
                    GlStateManager.enableBlend();
                    tess.func_78381_a();
                    GlStateManager.popMatrix();
                    GlStateManager.enableLighting();
                    size -= 0.25f;
                    z += 1.0E-4f;
                }
                GlStateManager.popMatrix();
            }
            GlStateManager.disableBlend();
        }
    }

    public static void enableStencils(IPolymorphCapability cap) {
        if (cap.getMorph() == IPolymorphCapability.Morph.WaterElemental || cap.getMorph() == IPolymorphCapability.Morph.FireElemental || cap.getMorph() == IPolymorphCapability.Morph.ArchAngel) {
            if (AoVOverlay.NO_STENCIL) {
                if (cap.getMorph() == IPolymorphCapability.Morph.WaterElemental) {
                    GlStateManager.color4f((float)0.0f, (float)0.5f, (float)1.0f, (float)0.75f);
                } else if (cap.getMorph() == IPolymorphCapability.Morph.FireElemental) {
                    GlStateManager.color4f((float)1.0f, (float)0.75f, (float)0.0f, (float)0.75f);
                } else if (cap.getMorph() == IPolymorphCapability.Morph.ArchAngel) {
                    GlStateManager.color4f((float)1.0f, (float)1.0f, (float)0.0f, (float)0.75f);
                }
            } else {
                GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GL11.glEnable((int)2960);
                GL11.glStencilMask((int)255);
                GL11.glStencilFunc((int)519, (int)((Integer)AoV.config_client.stencil.get() + (cap.getMorph() == IPolymorphCapability.Morph.WaterElemental ? 8 : (cap.getMorph() == IPolymorphCapability.Morph.FireElemental ? 9 : 10)) + (AoVOverlay.hackyshit ? 3 : 0)), (int)255);
                GL11.glStencilOp((int)7680, (int)7680, (int)7681);
            }
        }
    }

    public static void disableStencils() {
        GL11.glStencilFunc((int)519, (int)0, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glStencilMask((int)0);
        GL11.glDisable((int)2960);
        GlStateManager.blendFunc((int)770, (int)771);
    }

    @SubscribeEvent
    public static void render(RenderHandEvent e) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        IPolymorphCapability cap = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.POLYMORPH);
        if (cap != null && (cap.getMorph() == IPolymorphCapability.Morph.WaterElemental || cap.getMorph() == IPolymorphCapability.Morph.FireElemental || cap.getMorph() == IPolymorphCapability.Morph.ArchAngel)) {
            boolean flag;
            Minecraft mc = Minecraft.func_71410_x();
            boolean bl = flag = mc.func_175606_aa() instanceof LivingEntity && ((LivingEntity)mc.func_175606_aa()).func_70608_bn();
            if (!(mc.field_71474_y.field_74320_O != 0 || flag || mc.field_71474_y.field_74319_N || mc.field_71442_b.func_178887_k())) {
                mc.field_71460_t.func_180436_i();
                GlStateManager.enableBlend();
                if (AoVOverlay.NO_STENCIL) {
                    if (cap.getMorph() == IPolymorphCapability.Morph.WaterElemental) {
                        GlStateManager.color4f((float)0.0f, (float)0.5f, (float)1.0f, (float)0.75f);
                    } else if (cap.getMorph() == IPolymorphCapability.Morph.FireElemental) {
                        GlStateManager.color4f((float)1.0f, (float)0.75f, (float)0.0f, (float)0.75f);
                    } else if (cap.getMorph() == IPolymorphCapability.Morph.FireElemental) {
                        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)0.0f, (float)0.75f);
                    }
                } else {
                    e.setCanceled(true);
                    GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    GL11.glEnable((int)2960);
                    GL11.glStencilMask((int)255);
                    GL11.glStencilFunc((int)519, (int)((Integer)AoV.config_client.stencil.get() + (cap.getMorph() == IPolymorphCapability.Morph.WaterElemental ? 8 : (cap.getMorph() == IPolymorphCapability.Morph.FireElemental ? 9 : 10))), (int)255);
                    GL11.glStencilOp((int)7680, (int)7680, (int)7681);
                    mc.field_71460_t.field_78516_c.func_78440_a(e.getPartialTicks());
                    GL11.glStencilFunc((int)519, (int)0, (int)255);
                    GL11.glStencilOp((int)7680, (int)7680, (int)7680);
                    GL11.glStencilMask((int)0);
                    GL11.glDisable((int)2960);
                    GlStateManager.blendFunc((int)770, (int)771);
                }
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.disableBlend();
                mc.field_71460_t.func_175072_h();
            }
        }
    }

    @SubscribeEvent
    public static void render(RenderSpecificHandEvent e) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        IPolymorphCapability cap = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.POLYMORPH);
        if (cap != null && cap.getMorph() == IPolymorphCapability.Morph.Wolf) {
            e.setCanceled(true);
            boolean flag = (e.getHand() == Hand.MAIN_HAND ? player.func_184591_cq() : player.func_184591_cq().func_188468_a()) != HandSide.LEFT;
            float f = flag ? 1.0f : -1.0f;
            float f1 = MathHelper.func_76129_c((float)e.getSwingProgress());
            float f2 = -0.3f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
            float f3 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
            float f4 = -0.4f * MathHelper.func_76126_a((float)(e.getSwingProgress() * (float)Math.PI));
            GlStateManager.translated((double)(f * (f2 + 0.64000005f)), (double)(f3 + -0.6f + e.getEquipProgress() * -0.6f), (double)(f4 + -0.71999997f));
            GlStateManager.rotatef((float)(f * 45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            float f5 = MathHelper.func_76126_a((float)(e.getSwingProgress() * e.getSwingProgress() * (float)Math.PI));
            float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
            GlStateManager.rotatef((float)(f * f6 * 40.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)(f * f5 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            ClientPlayerEntity abstractclientplayer = Minecraft.func_71410_x().field_71439_g;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WOLF_TEXTURES);
            GlStateManager.translated((double)(f * -1.0f), (double)3.6f, (double)3.5);
            GlStateManager.rotatef((float)(f * 120.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)(f * -135.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translated((double)(f * 5.6f), (double)0.0, (double)0.0);
            GlStateManager.disableCull();
            RenderPlayer.renderRightArm((AbstractClientPlayerEntity)abstractclientplayer);
            GlStateManager.enableCull();
        } else if (e.getItemStack().func_77973_b() instanceof Handwraps && e.getHand() == Hand.MAIN_HAND) {
            Minecraft mc = Minecraft.func_71410_x();
            float f = player.func_70678_g(e.getPartialTicks());
            Hand enumhand = (Hand)MoreObjects.firstNonNull((Object)player.field_184622_au, (Object)Hand.MAIN_HAND);
            float f3 = enumhand == e.getHand() ? f : 0.0f;
            float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * e.getPartialTicks();
            mc.func_175597_ag().func_187457_a((AbstractClientPlayerEntity)player, e.getPartialTicks(), f1, e.getHand(), f3, ItemStack.field_190927_a, 0.0f);
            e.setCanceled(true);
        }
    }

    public static void renderRightArm(AbstractClientPlayerEntity clientPlayer) {
        float f = 1.0f;
        GlStateManager.color3f((float)f, (float)f, (float)f);
        float f1 = 0.0625f;
        GlStateManager.enableBlend();
        GlStateManager.pushMatrix();
        float scale = 3.0f;
        GlStateManager.scalef((float)scale, (float)scale, (float)scale);
        GlStateManager.translated((double)0.25, (double)-0.65f, (double)0.0);
        RenderPlayer.WOLF_MODEL.field_217112_c = 0.0f;
        WOLF_MODEL.func_212844_a_(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, f1);
        RenderPlayer.WOLF_MODEL.field_78181_d.field_78795_f = 0.0f;
        RenderPlayer.WOLF_MODEL.field_78181_d.func_78785_a(f1);
        GlStateManager.popMatrix();
        GlStateManager.disableBlend();
    }

    protected static float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }

    protected static void applyRotations(LivingEntity entityLiving, float p_77043_2_, float rotationYaw, float partialTicks) {
        GlStateManager.rotatef((float)(180.0f - rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        if (entityLiving.field_70725_aQ > 0) {
            float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            GlStateManager.rotatef((float)(f * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            String s = TextFormatting.func_110646_a((String)entityLiving.func_200200_C_().getString());
            if (s != null && ("Dinnerbone".equals(s) || "Grumm".equals(s)) && (!(entityLiving instanceof PlayerEntity) || ((PlayerEntity)entityLiving).func_175148_a(PlayerModelPart.CAPE))) {
                GlStateManager.translated((double)0.0, (double)(entityLiving.func_213302_cg() + 0.1f), (double)0.0);
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }
}

