/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.client.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import tamaized.aov.AoV;
import tamaized.aov.common.entity.EntityEarthquake;

public class RenderEarthquake
extends EntityRenderer<EntityEarthquake> {
    private static final ResourceLocation SHADOW_TEXTURES = new ResourceLocation("textures/misc/shadow.png");
    private static final ResourceLocation TEXTURE = new ResourceLocation("aov", "textures/entity/earthquake.png");

    public RenderEarthquake(EntityRendererManager renderManager) {
        super(renderManager);
    }

    private static void renderShadow(EntityRendererManager renderManager, Entity entityIn, double x, double y, double z, float shadowSize, float shadowAlpha, float partialTicks) {
        MobEntity mobentity;
        GlStateManager.enableBlend();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderManager.field_78724_e.func_110577_a(SHADOW_TEXTURES);
        World iworldreader = renderManager.field_78722_g;
        GlStateManager.depthMask((boolean)false);
        float f = shadowSize;
        if (entityIn instanceof MobEntity && (mobentity = (MobEntity)entityIn).func_70631_g_()) {
            f *= 0.5f;
        }
        double d5 = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70142_S, (double)entityIn.field_70165_t);
        double d0 = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70137_T, (double)entityIn.field_70163_u);
        double d1 = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70136_U, (double)entityIn.field_70161_v);
        int i = MathHelper.func_76128_c((double)(d5 - (double)f));
        int j = MathHelper.func_76128_c((double)(d5 + (double)f));
        int k = MathHelper.func_76128_c((double)(d0 - (double)f));
        int l = MathHelper.func_76128_c((double)d0);
        int i1 = MathHelper.func_76128_c((double)(d1 - (double)f));
        int j1 = MathHelper.func_76128_c((double)(d1 + (double)f));
        double d2 = x - d5;
        double d3 = y - d0;
        double d4 = z - d1;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)new BlockPos(i, k, i1), (BlockPos)new BlockPos(j, l, j1))) {
            BlockPos blockpos1 = blockpos.func_177977_b();
            BlockState blockstate = iworldreader.func_180495_p(blockpos1);
            if (blockstate.func_185901_i() == BlockRenderType.INVISIBLE || iworldreader.func_201696_r(blockpos) <= 3) continue;
            RenderEarthquake.func_217759_a(renderManager, blockstate, (IWorldReader)iworldreader, blockpos1, x, y, z, blockpos, shadowAlpha, f, d2, d3, d4);
        }
        tessellator.func_78381_a();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
    }

    private static void func_217759_a(EntityRendererManager renderManager, BlockState p_217759_1_, IWorldReader p_217759_2_, BlockPos p_217759_3_, double p_217759_4_, double p_217759_6_, double p_217759_8_, BlockPos p_217759_10_, float p_217759_11_, float p_217759_12_, double p_217759_13_, double p_217759_15_, double p_217759_17_) {
        VoxelShape voxelshape;
        if (p_217759_1_.func_224756_o((IBlockReader)p_217759_2_, p_217759_3_) && !(voxelshape = p_217759_1_.func_196954_c((IBlockReader)renderManager.field_78722_g, p_217759_10_.func_177977_b())).func_197766_b()) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            double d0 = ((double)p_217759_11_ - (p_217759_6_ - ((double)p_217759_10_.func_177956_o() + p_217759_15_)) / 2.0) * 0.5 * (double)renderManager.field_78722_g.func_205052_D(p_217759_10_);
            if (!(d0 < 0.0)) {
                if (d0 > 1.0) {
                    d0 = 1.0;
                } else if (d0 < 0.5) {
                    d0 = 0.0;
                }
                AxisAlignedBB axisalignedbb = voxelshape.func_197752_a();
                double d1 = (double)p_217759_10_.func_177958_n() + axisalignedbb.field_72340_a + p_217759_13_;
                double d2 = (double)p_217759_10_.func_177958_n() + axisalignedbb.field_72336_d + p_217759_13_;
                double d3 = (double)p_217759_10_.func_177956_o() + axisalignedbb.field_72338_b + p_217759_15_ + 0.015625;
                double d4 = (double)p_217759_10_.func_177952_p() + axisalignedbb.field_72339_c + p_217759_17_;
                double d5 = (double)p_217759_10_.func_177952_p() + axisalignedbb.field_72334_f + p_217759_17_;
                float f = (float)((p_217759_4_ - d1) / 2.0 / (double)p_217759_12_ + 0.5);
                float f1 = (float)((p_217759_4_ - d2) / 2.0 / (double)p_217759_12_ + 0.5);
                float f2 = (float)((p_217759_8_ - d4) / 2.0 / (double)p_217759_12_ + 0.5);
                float f3 = (float)((p_217759_8_ - d5) / 2.0 / (double)p_217759_12_ + 0.5);
                bufferbuilder.func_181662_b(d1, d3, d4).func_187315_a((double)f, (double)f2).func_181666_a(1.0f, 1.0f, 1.0f, (float)d0).func_181675_d();
                bufferbuilder.func_181662_b(d1, d3, d5).func_187315_a((double)f, (double)f3).func_181666_a(1.0f, 1.0f, 1.0f, (float)d0).func_181675_d();
                bufferbuilder.func_181662_b(d2, d3, d5).func_187315_a((double)f1, (double)f3).func_181666_a(1.0f, 1.0f, 1.0f, (float)d0).func_181675_d();
                bufferbuilder.func_181662_b(d2, d3, d4).func_187315_a((double)f1, (double)f2).func_181666_a(1.0f, 1.0f, 1.0f, (float)d0).func_181675_d();
            }
        }
    }

    public void doRender(@Nonnull EntityEarthquake entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        this.renderMask(entity, x, y, z, partialTicks);
        this.renderQuakes(entity, x, y, z, partialTicks);
    }

    private void renderMask(@Nonnull EntityEarthquake entity, double x, double y, double z, float partialTicks) {
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GL11.glEnable((int)2960);
        GL11.glStencilMask((int)255);
        GL11.glStencilFunc((int)519, (int)((Integer)AoV.config_client.stencil.get() + 6), (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        RenderEarthquake.renderShadow(this.field_76990_c, entity, x, y, z, 3.0f, 1.0f, partialTicks);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glStencilMask((int)0);
        GL11.glDisable((int)2960);
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.disableBlend();
    }

    private void renderQuakes(@Nonnull EntityEarthquake entity, double x, double y, double z, float partialTicks) {
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)514, (int)((Integer)AoV.config_client.stencil.get() + 6), (int)255);
        this.func_110776_a(TEXTURE);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableBlend();
        AtomicReference<Float> offset = new AtomicReference<Float>(Float.valueOf(0.0f));
        entity.quakes.removeIf(q -> q.render(entity, x, y + (double)((Float)offset.updateAndGet(v -> Float.valueOf(v.floatValue() + 1.0E-4f))).floatValue(), z, partialTicks));
        GL11.glStencilMask((int)0);
        GL11.glDisable((int)2960);
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.disableBlend();
    }

    @Nullable
    protected ResourceLocation getEntityTexture(@Nonnull EntityEarthquake entity) {
        return TEXTURE;
    }
}

