/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.AoV;
import tamaized.aov.client.gui.GuiScreenClose;
import tamaized.aov.client.gui.RenderUtils;
import tamaized.aov.client.gui.buttonlist.AstroSkillRegisterButtons;
import tamaized.aov.client.gui.buttonlist.ClericSkillRegisterButtons;
import tamaized.aov.client.gui.buttonlist.DruidSkillRegisterButtons;
import tamaized.aov.client.gui.buttonlist.FavoredSoulSkillRegisterButtons;
import tamaized.aov.client.gui.buttonlist.IClassButtons;
import tamaized.aov.client.gui.buttonlist.PaladinSkillRegisterButtons;
import tamaized.aov.client.gui.buttons.SkillButton;
import tamaized.aov.common.blocks.BlockAngelicBlock;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.gui.GuiHandler;
import tamaized.aov.network.server.ServerPacketHandlerSpellSkill;

public class AoVSkillsGUI
extends GuiScreenClose {
    private static List<IClassButtons> CLASS_BUTTON_REGISTRY = Lists.newArrayList((Object[])new IClassButtons[]{new FavoredSoulSkillRegisterButtons(), new ClericSkillRegisterButtons(), new PaladinSkillRegisterButtons(), new AstroSkillRegisterButtons(), new DruidSkillRegisterButtons()});
    private final BlockAngelicBlock.ClassType classType;
    private int page;
    private List<SkillButton> skillbuttons = new ArrayList<SkillButton>();
    private int lastMx = 0;
    private int lastMy = 0;
    private IAoVCapability cap;

    public AoVSkillsGUI(BlockAngelicBlock.ClassType classType) {
        super(AoVSkillsGUI.makeTranslationKey("skills"));
        this.classType = classType;
    }

    public void init() {
        super.init();
        this.cap = CapabilityList.getCap((ICapabilityProvider)Objects.requireNonNull(this.minecraft).field_71439_g, CapabilityList.AOV);
        if (this.cap != null) {
            if (this.classType == BlockAngelicBlock.ClassType.ALL) {
                for (IClassButtons b : CLASS_BUTTON_REGISTRY) {
                    if (!b.active(this.cap)) continue;
                    this.page = CLASS_BUTTON_REGISTRY.indexOf(b);
                    break;
                }
            } else {
                this.page = this.classType.ordinal() - 1;
            }
            this.initButtons();
        } else {
            this.minecraft.field_71439_g.func_71053_j();
        }
    }

    public void initButtons() {
        this.buttons.clear();
        this.skillbuttons.clear();
        this.buttons.add(new Button(10, this.height - 25, 80, 20, I18n.func_135052_a((String)"aov.gui.button.close", (Object[])new Object[0]), button -> Objects.requireNonNull(this.minecraft).field_71439_g.func_71053_j()));
        this.buttons.add(new Button(110, this.height - 25, 80, 20, I18n.func_135052_a((String)"aov.gui.button.spellbook", (Object[])new Object[0]), button -> GuiHandler.openGui(GuiHandler.GUI.SPELLBOOK, this.classType)));
        this.buttons.add(new Button(this.width - 190, this.height - 25, 80, 20, I18n.func_135052_a((String)"aov.gui.button.stats", (Object[])new Object[0]), button -> GuiHandler.openGui(GuiHandler.GUI.CHECKSTATS, this.classType)));
        this.buttons.add(new Button(this.width - 90, this.height - 25, 80, 20, I18n.func_135052_a((String)"aov.gui.button.reset", (Object[])new Object[0]), button -> GuiHandler.openGui(GuiHandler.GUI.RESET, this.classType)));
        if (this.classType == BlockAngelicBlock.ClassType.ALL) {
            this.buttons.add(new ArrowButton(this.width / 2 - 95, 39, 20, this.height - 70, "<", button -> {
                if (this.page > 0) {
                    --this.page;
                }
                this.initButtons();
            }, page -> page > 0));
            this.buttons.add(new ArrowButton(this.width / 2 + 69, 39, 20, this.height - 70, ">", button -> {
                if (this.page < CLASS_BUTTON_REGISTRY.size() - 1) {
                    ++this.page;
                }
                this.initButtons();
            }, page -> page < CLASS_BUTTON_REGISTRY.size() - 1));
        }
        CLASS_BUTTON_REGISTRY.get(MathHelper.func_76125_a((int)this.page, (int)0, (int)(CLASS_BUTTON_REGISTRY.size() - 1))).register(this);
    }

    public void addNewButton(SkillButton button) {
        this.buttons.add(button);
        this.skillbuttons.add(button);
    }

    public void doSkillButton(SkillButton button) {
        button.active = !this.beginChecks(button);
    }

    private boolean beginChecks(SkillButton button) {
        if ((button.getSkill() == null || !this.cap.hasSkill(button.getSkill())) && button.canObtain(this.cap)) {
            AoV.network.sendToServer((Object)new ServerPacketHandlerSpellSkill(ServerPacketHandlerSpellSkill.PacketType.SKILLEDIT_CHECK_CANOBTAIN, null, button.getSkill().getID()));
        }
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void tick() {
        super.tick();
        for (Widget button : this.buttons) {
            if (button instanceof SkillButton) {
                ((SkillButton)button).update(this.cap);
                continue;
            }
            if (!(button instanceof ArrowButton)) continue;
            ((ArrowButton)button).update(this.page);
        }
        if (!Objects.requireNonNull(this.minecraft).field_71439_g.func_70089_S() || !this.minecraft.field_71439_g.func_70089_S()) {
            this.minecraft.field_71439_g.func_71053_j();
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"aov.gui.title.skills", (Object[])new Object[0]), this.width / 2, 15, 0xFFFFFF);
        this.drawString(this.font, I18n.func_135052_a((String)"aov.gui.skills.points", (Object[])new Object[]{this.cap == null ? "null" : Integer.valueOf(this.cap.getSkillPoints())}), 5, 5, -256);
        this.drawString(this.font, I18n.func_135052_a((String)"aov.gui.skills.spent", (Object[])new Object[]{this.cap == null ? "null" : Integer.valueOf(this.cap.getSpentSkillPoints()), this.cap == null ? "null" : Integer.valueOf(this.cap.getLevel())}), 5, 15, -256);
        this.drawString(this.font, I18n.func_135052_a((String)"aov.gui.skills.level", (Object[])new Object[0]), this.width - 40, 5, -256);
        this.drawString(this.font, "" + (this.cap == null ? "null" : Integer.valueOf(this.cap.getLevel())), this.width - 40, 15, -256);
        GlStateManager.enableBlend();
        RenderUtils.setup(this.blitOffset);
        RenderUtils.renderRect((float)this.width / 2.0f - 66.0f, (float)(this.height - 215), 126.0f, 188.0f, false, 136);
        super.render(mouseX, mouseY, partialTicks);
        GlStateManager.disableBlend();
        if (mouseX != this.lastMx || mouseY != this.lastMy) {
            boolean flag = true;
            for (SkillButton b : this.skillbuttons) {
                if (!b.visible || mouseX < b.x || mouseX > b.x + b.getWidth() || mouseY < b.y || mouseY > b.y + b.getHeight() || b.getSkill() == null || b.getSkill().getDescriptionAsTextComponent() == null) continue;
                this.renderComponentHoverEffect(b.getSkill().getDescriptionAsTextComponent(), mouseX, mouseY);
                flag = false;
                break;
            }
            if (flag) {
                this.lastMy = mouseY;
                this.lastMx = mouseX;
            }
        }
    }

    static class ArrowButton
    extends Button {
        private static final ResourceLocation TEXTURE = new ResourceLocation("aov", "textures/gui/buttons.png");
        private final Function<Integer, Boolean> func;

        public ArrowButton(int x, int y, int widthIn, int heightIn, String buttonText, Button.IPressable func, Function<Integer, Boolean> active) {
            super(x, y, widthIn, heightIn, buttonText, func);
            this.func = active;
        }

        public void update(int data) {
            this.active = this.func.apply(data);
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            Minecraft mc = Minecraft.func_71410_x();
            if (this.visible) {
                FontRenderer font = mc.field_71466_p;
                mc.func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
                int i = this.getYImage(this.isHovered());
                GlStateManager.enableBlend();
                GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                bufferbuilder.func_181662_b((double)this.x, (double)this.y, 0.0).func_187315_a((double)((float)i / 3.0f), 0.0).func_181675_d();
                bufferbuilder.func_181662_b((double)this.x, (double)(this.y + this.height), 0.0).func_187315_a((double)((float)i / 3.0f), 1.0).func_181675_d();
                bufferbuilder.func_181662_b((double)(this.x + 20), (double)(this.y + this.height), 0.0).func_187315_a((double)((1.0f + (float)i) / 3.0f), 1.0).func_181675_d();
                bufferbuilder.func_181662_b((double)(this.x + 20), (double)this.y, 0.0).func_187315_a((double)((1.0f + (float)i) / 3.0f), 0.0).func_181675_d();
                tessellator.func_78381_a();
                this.mouseDragged(mouseX, mouseY, 0, mouseX, mouseY);
                int j = this.getFGColor();
                this.drawCenteredString(font, this.getMessage(), this.x + this.width / 2, this.y + (this.height - 8) / 2, j);
            }
        }
    }
}

