/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.capabilities.aov;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import tamaized.aov.AoV;
import tamaized.aov.common.capabilities.aov.AoVCapabilityHandler;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.core.skills.AoVSkill;
import tamaized.aov.common.core.skills.AoVSkills;

public class AoVCapabilityStorage
implements Capability.IStorage<IAoVCapability> {
    public INBT writeNBT(Capability<IAoVCapability> capability, IAoVCapability instance, Direction side) {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (AoVSkill aoVSkill : instance.getObtainedSkills()) {
            list.add((Object)new IntNBT(aoVSkill.getID()));
        }
        nbt.func_218657_a("obtainedSkills", (INBT)list);
        list = new ListNBT();
        for (Map.Entry entry : instance.getDecayMap().entrySet()) {
            CompoundNBT comp = new CompoundNBT();
            comp.func_74768_a("id", AbilityBase.getID((AbilityBase)entry.getKey()));
            comp.func_74768_a("decay", ((AoVCapabilityHandler.DecayWrapper)entry.getValue()).getDecay());
            list.add((Object)comp);
        }
        nbt.func_218657_a("decay", (INBT)list);
        nbt.func_74768_a("skillPoints", instance.getSkillPoints());
        nbt.func_74768_a("exp", instance.getExp());
        nbt.func_74768_a("maxLevel", instance.getMaxLevel());
        nbt.func_74757_a("invokeMass", instance.getInvokeMass());
        list = new ListNBT();
        for (int index = 0; index < 9; ++index) {
            CompoundNBT compoundNBT = new CompoundNBT();
            Ability ability = instance.getSlot(index);
            compoundNBT.func_74768_a("slot", index);
            compoundNBT.func_74768_a("id", ability == null ? -1 : ability.getAbility().getID());
            list.add((Object)compoundNBT);
        }
        nbt.func_218657_a("slots", (INBT)list);
        list = new ListNBT();
        for (Ability ability : instance.getAbilities()) {
            list.add((Object)ability.encode(new CompoundNBT(), instance));
        }
        nbt.func_218657_a("abilities", (INBT)list);
        nbt.func_74768_a("currentSlot", instance.getCurrentSlot());
        return nbt;
    }

    public void readNBT(Capability<IAoVCapability> capability, IAoVCapability instance, Direction side, INBT nbt) {
        CompoundNBT compound = (CompoundNBT)nbt;
        INBT tag = compound.func_74781_a("obtainedSkills");
        if (tag instanceof ListNBT) {
            ListNBT list = (ListNBT)tag;
            for (int index = 0; index < list.size(); ++index) {
                instance.addObtainedSkill(AoVSkills.getSkillFromID(list.func_186858_c(index)));
            }
        }
        HashMap<AbilityBase, AoVCapabilityHandler.DecayWrapper> decay = new HashMap<AbilityBase, AoVCapabilityHandler.DecayWrapper>();
        tag = compound.func_74781_a("decay");
        if (tag instanceof ListNBT) {
            ListNBT list = (ListNBT)tag;
            for (int index = 0; index < list.size(); ++index) {
                CompoundNBT comp = list.func_150305_b(index);
                AbilityBase abilityBase = AbilityBase.getAbilityFromID(comp.func_74762_e("id"));
                AoVCapabilityHandler aoVCapabilityHandler = (AoVCapabilityHandler)instance;
                aoVCapabilityHandler.getClass();
                decay.put(abilityBase, aoVCapabilityHandler.new AoVCapabilityHandler.DecayWrapper(comp.func_74762_e("decay")));
            }
        }
        if (!decay.isEmpty()) {
            instance.setDecayMap(decay);
        }
        instance.setSkillPoints(compound.func_74762_e("skillPoints"));
        instance.setExp(compound.func_74762_e("exp"));
        instance.setMaxLevel((Integer)AoV.config.maxlevel.get());
        instance.toggleInvokeMass(compound.func_74767_n("invokeMass"));
        instance.update(null);
        tag = compound.func_74781_a("abilities");
        if (tag instanceof ListNBT) {
            for (INBT nt : (ListNBT)tag) {
                if (!(nt instanceof CompoundNBT)) continue;
                instance.addAbility(Ability.construct(instance, null, (CompoundNBT)nt));
            }
        }
        if ((tag = compound.func_74781_a("slots")) instanceof ListNBT) {
            for (INBT nt : (ListNBT)tag) {
                if (!(nt instanceof CompoundNBT)) continue;
                CompoundNBT ct = (CompoundNBT)nt;
                instance.setSlot(new Ability(AbilityBase.getAbilityFromID(ct.func_74762_e("id"))), ct.func_74762_e("slot"), false);
            }
        }
        instance.setCurrentSlot(compound.func_74762_e("currentSlot"));
        instance.markDirty();
        instance.setLoaded();
    }
}

