/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.capabilities.polymorph;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import tamaized.aov.common.capabilities.IPlayerCapabilityHandler;

public interface IPolymorphCapability
extends IPlayerCapabilityHandler<IPolymorphCapability> {
    public static final Set<Effect> ELEMENTAL_IMMUNITY_EFFECTS = ImmutableSet.of((Object)Effects.field_76421_d, (Object)Effects.field_76436_u, (Object)Effects.field_82731_v);
    public static final ResourceLocation ID = new ResourceLocation("aov", "polymorphcapabilityhandler");

    public Morph getMorph();

    public void morph(Morph var1);

    public boolean localMorphSize();

    public void setLocalMorphSize(boolean var1);

    public float getAttackCooldown();

    public void doAttack(PlayerEntity var1);

    public void doAttack(PlayerEntity var1, boolean var2);

    public void doAttack(PlayerEntity var1, boolean var2, int var3);

    public float getInitalAttackCooldown();

    public void callWolves(World var1, PlayerEntity var2, float var3);

    public void update(PlayerEntity var1);

    public byte getFlagBits();

    public void setFlagBits(byte var1);

    public boolean isFlagBitActive(byte var1);

    public void addFlagBits(byte var1);

    public void subtractFlagBits(byte var1);

    public static enum Morph {
        Wolf,
        FireElemental,
        WaterElemental,
        ArchAngel(tamaized.aov.registry.SoundEvents.aura, false);

        public static final Morph[] values;
        public final boolean requiresCentered;
        public final SoundEvent sound;

        private Morph() {
            this(true);
        }

        private Morph(SoundEvent sound) {
            this(sound, true);
        }

        private Morph(boolean centered) {
            this(SoundEvents.field_187514_aD, centered);
        }

        private Morph(SoundEvent sound, boolean centered) {
            this.requiresCentered = centered;
            this.sound = sound;
        }

        public static Morph getMorph(int ordinal) {
            return ordinal < 0 || ordinal >= values.length ? null : values[ordinal];
        }

        static {
            values = Morph.values();
        }
    }
}

