/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.astro;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.client.ParticleHelper;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntitySpellAoVParticles;
import tamaized.aov.registry.SoundEvents;

public class AspectedBenefic
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/aspectedbenefic.png");
    private static final int charges = 2;
    private static final int distance = 10;
    private static final int heal = 8;

    public AspectedBenefic() {
        super(new TranslationTextComponent(AspectedBenefic.getStaticName(), new Object[0]), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.global.charges", new Object[]{2}), new TranslationTextComponent("aov.spells.global.range", new Object[]{10}), new TranslationTextComponent("aov.spells.global.healing", new Object[]{8}), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.aspectedbenefic.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.aspectedbenefic.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)AspectedBenefic.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 3;
    }

    @Override
    public int getMaxCharges() {
        return 2;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 10.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
        return IAoVCapability.canBenefit((Entity)caster, cap, target);
    }

    @Override
    public boolean cast(Ability ability, PlayerEntity caster, LivingEntity target) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (cap == null) {
            return false;
        }
        PlayerEntity entity = target != null && IAoVCapability.canBenefit((Entity)caster, cap, target) ? target : caster;
        int a = (int)(8.0f * (1.0f + cap.getSpellPower() / 100.0f));
        entity.func_70691_i((float)a);
        SoundEvents.playMovingSoundOnServer(SoundEvents.aspectedbenefic, (Entity)entity);
        entity.field_70170_p.func_217376_c((Entity)new EntitySpellAoVParticles(entity.field_70170_p, (Entity)entity, ParticleHelper.ParticleType.Heart, 5, 0xFFD8FF));
        entity.func_195064_c(new EffectInstance(Effects.field_76428_l, 600));
        cap.addExp((Entity)caster, 15, this);
        return true;
    }
}

