/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.astro;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.client.ParticleHelper;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntitySpellAoVParticles;
import tamaized.aov.registry.SoundEvents;

public class AspectedHelios
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/aspectedhelios.png");
    private static final int charges = 2;
    private static final int distance = 20;
    private static final int heal = 8;

    public AspectedHelios() {
        super(new TranslationTextComponent(AspectedHelios.getStaticName(), new Object[0]), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.global.charges", new Object[]{2}), new TranslationTextComponent("aov.spells.global.range", new Object[]{20}), new TranslationTextComponent("aov.spells.global.healing", new Object[]{8}), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.aspectedhelios.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.aspectedhelios.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)AspectedHelios.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 2;
    }

    @Override
    public int getMaxCharges() {
        return 2;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 20.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
        return false;
    }

    @Override
    public boolean cast(Ability ability, PlayerEntity caster, LivingEntity target) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (cap == null) {
            return false;
        }
        PlayerEntity e = target != null && IAoVCapability.canBenefit((Entity)caster, cap, target) ? target : caster;
        List list = e.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(e.func_180425_c().func_177982_a(-20, -20, -20), e.func_180425_c().func_177982_a(20, 20, 20)));
        for (LivingEntity entity : list) {
            if (entity == caster || IAoVCapability.canBenefit((Entity)caster, cap, entity)) {
                entity.func_70691_i(8.0f);
                entity.field_70170_p.func_217376_c((Entity)new EntitySpellAoVParticles(entity.field_70170_p, (Entity)entity, ParticleHelper.ParticleType.Heart, 5, 0xFF87FF));
                entity.func_195064_c(new EffectInstance(Effects.field_76428_l, 600));
            }
            cap.addExp((Entity)caster, 15, this);
        }
        SoundEvents.playMovingSoundOnServer(SoundEvents.aspectedhelios, (Entity)e);
        return true;
    }
}

