/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.astro;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntityCombust;
import tamaized.aov.registry.SoundEvents;

public class Combust
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/combust.png");
    private static final int charges = 6;
    private static final int distance = 32;
    private static final int damage = 2;

    public Combust() {
        super(new TranslationTextComponent(Combust.getStaticName(), new Object[0]), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.global.charges", new Object[]{6}), new TranslationTextComponent("aov.spells.global.range", new Object[]{32}), new TranslationTextComponent("aov.spells.global.damage", new Object[]{2}), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.combust.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.combust.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)Combust.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 3;
    }

    @Override
    public int getMaxCharges() {
        return 6;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 32.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
        return IAoVCapability.selectiveTarget((Entity)caster, cap, target);
    }

    @Override
    public boolean cast(Ability ability, PlayerEntity caster, LivingEntity target) {
        if (target == null) {
            return false;
        }
        IAoVCapability aov = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (!caster.field_70170_p.field_72995_K && aov != null && IAoVCapability.selectiveTarget((Entity)caster, aov, target)) {
            int a = (int)(2.0f * (1.0f + aov.getSpellPower() / 100.0f));
            EntityCombust spell = new EntityCombust(caster.field_70170_p, (Entity)caster, (Entity)target, a);
            caster.field_70170_p.func_217376_c((Entity)spell);
            SoundEvents.playMovingSoundOnServer(SoundEvents.malefic_hit, spell);
            return true;
        }
        return false;
    }
}

