/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.astro;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntitySpellVanillaParticles;
import tamaized.aov.registry.SoundEvents;

public class EssentialDignity
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/essentialdignity.png");
    private static final int charges = -1;
    private static final int distance = 10;

    public EssentialDignity() {
        super(new TranslationTextComponent(EssentialDignity.getStaticName(), new Object[0]), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.global.charges", new Object[]{"aov.gui.infinite"}), new TranslationTextComponent("aov.spells.global.range", new Object[]{10}), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.essentialdignity.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.essentialdignity.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)EssentialDignity.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 40;
    }

    @Override
    public int getMaxCharges() {
        return -1;
    }

    @Override
    public int getChargeCost() {
        return 0;
    }

    @Override
    public double getMaxDistance() {
        return 10.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
        return IAoVCapability.canBenefit((Entity)caster, cap, target);
    }

    @Override
    public boolean cast(Ability ability, PlayerEntity caster, LivingEntity target) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (cap == null) {
            return false;
        }
        PlayerEntity entity = target != null && IAoVCapability.canBenefit((Entity)caster, cap, target) ? target : caster;
        entity.func_70691_i(entity.func_110138_aP());
        SoundEvents.playMovingSoundOnServer(SoundEvents.essentialdignity, (Entity)entity);
        entity.field_70170_p.func_217376_c((Entity)new EntitySpellVanillaParticles(entity.field_70170_p, (Entity)entity, (IParticleData)ParticleTypes.field_197624_q, 10));
        cap.addExp((Entity)caster, 12, this);
        return true;
    }
}

