/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.astro;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntityMalefic;
import tamaized.aov.registry.SoundEvents;

public class Malefic
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/malefic.png");
    private static final int charges = 8;
    private static final int distance = 32;
    private static final int damage = 4;

    public Malefic() {
        super(new TranslationTextComponent(Malefic.getStaticName(), new Object[0]), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.global.charges", new Object[]{8}), new TranslationTextComponent("aov.spells.global.range", new Object[]{32}), new TranslationTextComponent("aov.spells.global.damage", new Object[]{4}), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.malefic.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.malefic.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)Malefic.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 5;
    }

    @Override
    public int getMaxCharges() {
        return 8;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 32.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
        return false;
    }

    @Override
    public boolean cast(Ability ability, PlayerEntity caster, LivingEntity target) {
        IAoVCapability aov = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (!caster.field_70170_p.field_72995_K && aov != null) {
            EntityMalefic spell = new EntityMalefic(caster.field_70170_p, caster);
            spell.setSpell(this);
            int a = (int)(4.0f * (1.0f + aov.getSpellPower() / 100.0f));
            spell.func_70239_b(a);
            spell.setMaxRange(32);
            spell.setSpeed(1);
            caster.field_70170_p.func_217376_c((Entity)spell);
            SoundEvents.playMovingSoundOnServer(SoundEvents.malefic_cast, (Entity)spell);
        }
        return true;
    }
}

