/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.astro;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.astro.IAstroCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.core.abilities.astro.Draw;

public class Spread
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/spread.png");
    private static final int charges = -1;
    private static final int distance = 10;

    public Spread() {
        super(new TranslationTextComponent(Spread.getStaticName(), new Object[0]), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.global.range", new Object[]{10}), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.spread.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.spread.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)Spread.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 30;
    }

    @Override
    public int getMaxCharges() {
        return -1;
    }

    @Override
    public int getChargeCost() {
        return 0;
    }

    @Override
    public double getMaxDistance() {
        return 10.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
        return IAoVCapability.canBenefit((Entity)caster, cap, target);
    }

    @Override
    public boolean cast(Ability ability, PlayerEntity caster, LivingEntity target) {
        IAstroCapability astro = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.ASTRO);
        IAoVCapability aov = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (astro == null || aov == null) {
            return false;
        }
        if (astro.getSpread() == null) {
            ability.setNextCooldown(1);
            if (astro.getDraw() != null) {
                astro.spreadCard((LivingEntity)caster);
                for (Ability a : aov.getSlots()) {
                    if (a == null || a.getAbility() != Abilities.draw) continue;
                    a.setTimer(0);
                }
            }
        } else {
            IAstroCapability.ICard card = astro.getSpread();
            PlayerEntity entity = target == null || (double)caster.func_70032_d((Entity)target) >= this.getMaxDistance() ? caster : target;
            int potency = (int)Math.floor(aov.getSpellPower() / 10.0f);
            IAstroCapability.ICard burn = astro.getBurn();
            astro.useSpread((LivingEntity)caster);
            Draw.doDrawEffects((LivingEntity)entity, card, potency, burn, false);
            aov.addExp((Entity)caster, 15, this);
        }
        astro.sendPacketUpdates(caster);
        return true;
    }
}

