/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.cleric.Cores;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.client.ParticleHelper;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.core.abilities.IAura;
import tamaized.aov.registry.AoVDamageSource;
import tamaized.aov.registry.SoundEvents;

public class PosEnergyAura
extends AbilityBase
implements IAura {
    private static final int charges = 6;
    private static final int range = 10;
    private static final int dmg = 2;
    private static final int life = 45;

    public PosEnergyAura() {
        super(new TranslationTextComponent(PosEnergyAura.getStaticName(), new Object[0]), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.global.charges", new Object[]{6}), new TranslationTextComponent("aov.spells.global.range", new Object[]{10}), new TranslationTextComponent("aov.spells.global.healing", new Object[]{2}), new TranslationTextComponent("aov.spells.global.length", new Object[]{45}), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.posaura.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.posaura.name";
    }

    @Override
    public boolean cast(Ability ability, PlayerEntity player, LivingEntity e) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.AOV);
        if (cap == null) {
            return false;
        }
        cap.addAura(this.createAura(ability));
        SoundEvents.playMovingSoundOnServer(SoundEvents.aura, (Entity)player);
        cap.addExp((Entity)player, 30, this);
        return true;
    }

    @Override
    public void castAsAura(PlayerEntity caster, IAoVCapability cap, int life) {
        int tick = 900 - life;
        if (tick > 0 && tick % 20 == 0) {
            ParticleHelper.spawnParticleMesh(ParticleHelper.MeshType.BURST, ParticleHelper.ParticleType.Heart, caster.field_70170_p, caster.func_174791_d(), 10, -65281);
            int a = (int)(2.0f * (1.0f + cap.getSpellPower() / 100.0f));
            List list = caster.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(caster.func_180425_c().func_177982_a(-10, -10, -10), caster.func_180425_c().func_177982_a(10, 10, 10)));
            for (LivingEntity entity : list) {
                if (entity.func_70662_br()) {
                    entity.func_70097_a(AoVDamageSource.createEntityDamageSource(DamageSource.field_76376_m, (Entity)caster), (float)a);
                    continue;
                }
                if (!IAoVCapability.canBenefit((Entity)caster, cap, entity)) continue;
                entity.func_70691_i((float)a);
            }
        }
    }

    @Override
    public int getLife() {
        return 45;
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/posaura.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)PosEnergyAura.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 60;
    }

    @Override
    public int getMaxCharges() {
        return 6;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 10.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
        return false;
    }
}

