/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.druid;

import java.util.Objects;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.client.ParticleHelper;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntitySpellAoVParticles;
import tamaized.aov.registry.AoVPotions;

public class NaturesBounty
extends AbilityBase {
    private static final String UNLOC = "aov.spells.naturesbounty";
    private static final int CHARGES = 5;
    private static final float RANGE = 10.0f;
    private static final ResourceLocation ICON = new ResourceLocation("aov", "textures/spells/naturesbounty.png");

    public NaturesBounty() {
        super(new TranslationTextComponent(UNLOC.concat(".name"), new Object[0]), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.global.charges", new Object[]{5}), new TranslationTextComponent("aov.spells.global.range", new Object[]{Float.valueOf(10.0f)}), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent(UNLOC.concat(".desc"), new Object[0]));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)UNLOC.concat(".name"), (Object[])new Object[0]);
    }

    @Override
    public int getMaxCharges() {
        return 5;
    }

    @Override
    public int getExtraCharges(LivingEntity entity, IAoVCapability cap) {
        return IAoVCapability.isImprovedCentered(entity, cap) ? this.getMaxCharges() : super.getExtraCharges(entity, cap);
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 10.0;
    }

    @Override
    public int getCoolDown() {
        return 45;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
        return IAoVCapability.canBenefit((Entity)caster, cap, target);
    }

    @Override
    public boolean cast(Ability ability, PlayerEntity caster, LivingEntity target) {
        if (target != null) {
            this.addPotionEffects(target);
        } else {
            this.addPotionEffects((LivingEntity)caster);
        }
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (cap != null) {
            cap.addExp((Entity)caster, 15, this);
        }
        return true;
    }

    private void addPotionEffects(LivingEntity entity) {
        entity.func_195064_c(new EffectInstance((Effect)Objects.requireNonNull(AoVPotions.naturesBounty.get()), 18000));
        entity.field_70170_p.func_217376_c((Entity)new EntitySpellAoVParticles(entity.field_70170_p, (Entity)entity, ParticleHelper.ParticleType.Heart, 1, 0xFFAAFF));
        entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_193789_dh, SoundCategory.PLAYERS, 1.0f, entity.func_70681_au().nextFloat() * 0.5f + 0.75f);
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }
}

