/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.favoredsoul;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.ProjectileFlameStrike;
import tamaized.aov.common.helper.UtilHelper;
import tamaized.aov.registry.SoundEvents;

public class FlameStrike
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/flamestrike.png");
    private static final int damage = 6;
    private static final int charges = 5;
    private static final int distance = 45;

    public FlameStrike() {
        super(new TranslationTextComponent(FlameStrike.getStaticName(), new Object[0]), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.global.charges", new Object[]{5}), new TranslationTextComponent("aov.spells.global.range", new Object[]{45}), new TranslationTextComponent("aov.spells.global.damage", new Object[]{6}), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.flamestrike.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.flamestrike.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)FlameStrike.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 8;
    }

    @Override
    public int getMaxCharges() {
        return 5;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 45.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
        return IAoVCapability.selectiveTarget((Entity)caster, cap, target);
    }

    @Override
    public boolean cast(Ability ability, PlayerEntity caster, LivingEntity target) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (cap == null) {
            return false;
        }
        int a = (int)(6.0f * (1.0f + cap.getSpellPower() / 100.0f));
        ProjectileFlameStrike strike = new ProjectileFlameStrike(caster.field_70170_p, (Entity)caster, a);
        Vec3d pos = UtilHelper.getSpellLocation(caster, 45, (Entity)target);
        strike.func_70107_b(pos.field_72450_a, pos.field_72448_b + 15.0, pos.field_72449_c);
        caster.field_70170_p.func_217376_c((Entity)strike);
        strike.field_70170_p.func_184148_a(null, strike.field_70165_t, strike.field_70163_u - 20.0, strike.field_70161_v, SoundEvents.firestrike, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        return true;
    }
}

