/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.paladin;

import java.util.Objects;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.registry.AoVPotions;
import tamaized.aov.registry.SoundEvents;

public class Zeal
extends AbilityBase {
    private static final String name = "aov.spells.zeal.name";
    private static final int charges = 5;

    public Zeal() {
        super(new TranslationTextComponent(name, new Object[0]), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.global.charges", new Object[]{5}), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.zeal.desc", new Object[0]));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)name, (Object[])new Object[0]);
    }

    @Override
    public double getMaxDistance() {
        return 1.0;
    }

    @Override
    public int getMaxCharges() {
        return 5;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
        return false;
    }

    protected int getParticleColor() {
        return -1;
    }

    @Override
    public boolean cast(Ability ability, PlayerEntity player, LivingEntity e) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.AOV);
        if (cap == null) {
            return false;
        }
        this.addPotionEffects((LivingEntity)player);
        SoundEvents.playMovingSoundOnServer(SoundEvents.cast_2, (Entity)player);
        cap.addExp((Entity)player, 8, this);
        return true;
    }

    private void addPotionEffects(LivingEntity entity) {
        entity.func_195064_c(new EffectInstance((Effect)Objects.requireNonNull(AoVPotions.zeal.get()), 3000));
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public int getCoolDown() {
        return 12;
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/zeal.png");
    }
}

