/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.stun.IStunCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.common.core.abilities.favoredsoul.AlignmentAoE;
import tamaized.aov.common.helper.RayTraceHelper;
import tamaized.aov.registry.AoVEntities;

public class EntityAlignmentAoE
extends Entity {
    public static final DataParameter<Integer> ALIGNMENT_TYPE = EntityDataManager.func_187226_a(EntityAlignmentAoE.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final List<Entity> alreadyHit = Lists.newArrayList();
    private AlignmentAoE.Type alignment;
    private Entity caster;
    private float damage = 1.0f;
    private float damageMod = 1.0f;

    public EntityAlignmentAoE(World worldIn) {
        super((EntityType)Objects.requireNonNull(AoVEntities.entityalignmentaoe.get()), worldIn);
        this.field_70158_ak = true;
    }

    public EntityAlignmentAoE(World world, AlignmentAoE.Type type, Entity entity, float dmg, int r) {
        this(world);
        RayTraceResult ray;
        this.alignment = type;
        this.setAlignment(this.alignment);
        this.caster = entity;
        this.field_70177_z = this.caster.field_70177_z;
        this.damage = dmg;
        if (this.caster instanceof PlayerEntity && (ray = RayTraceHelper.tracePath(this.caster, world, (PlayerEntity)this.caster, r, 1.0f, (HashSet<Entity>)Sets.newHashSet((Object[])new Entity[]{this.caster}))) != null) {
            BlockPos pos = ray instanceof BlockRayTraceResult ? ((BlockRayTraceResult)ray).func_216350_a() : (ray instanceof EntityRayTraceResult ? ((EntityRayTraceResult)ray).func_216348_a().func_180425_c() : this.caster.func_180425_c());
            this.func_70634_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public EntityAlignmentAoE(World world, AlignmentAoE.Type type, Entity entity, float dmg, Vec3d pos) {
        this(world);
        this.alignment = type;
        this.setAlignment(this.alignment);
        this.caster = entity;
        this.field_70177_z = this.caster.field_70177_z;
        this.damage = dmg;
        this.func_70634_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ALIGNMENT_TYPE, (Object)0);
    }

    public AlignmentAoE.Type getAlignment() {
        return AlignmentAoE.Type.getTypeFromID((Integer)this.field_70180_af.func_187225_a(ALIGNMENT_TYPE));
    }

    public void setAlignment(AlignmentAoE.Type alignment) {
        this.field_70180_af.func_187227_b(ALIGNMENT_TYPE, (Object)alignment.ordinal());
    }

    protected void func_70037_a(@Nonnull CompoundNBT compound) {
        this.alignment = AlignmentAoE.Type.getTypeFromID(compound.func_74762_e("alignment"));
        if (this.alignment != null) {
            this.setAlignment(this.alignment);
        }
    }

    protected void func_213281_b(@Nonnull CompoundNBT compound) {
        compound.func_74768_a("alignment", this.alignment.ordinal());
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.getAlignment() == AlignmentAoE.Type.ChaosHammer) {
            if (this.field_70173_aa >= 14) {
                for (int i = 0; i <= 7; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5, (double)(this.field_70146_Z.nextFloat() * 6.0f - 3.0f), (double)this.field_70146_Z.nextFloat(), (double)(this.field_70146_Z.nextFloat() * 6.0f - 3.0f));
                }
            }
            return;
        }
        if (this.field_70173_aa >= 50) {
            this.func_70106_y();
            return;
        }
        int range = 4;
        for (LivingEntity e : this.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(this.func_180425_c().func_177982_a(-range, -2, -range), this.func_180425_c().func_177982_a(range, 2, range)))) {
            if (e == this.caster || this.alreadyHit.contains(e)) continue;
            this.doDamage(e);
            this.alreadyHit.add((Entity)e);
        }
    }

    private void doDamage(LivingEntity e) {
        boolean canDamage = false;
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)this.caster, CapabilityList.AOV);
        if (cap != null) {
            if (IAoVCapability.selectiveTarget(this.caster, cap, e)) {
                canDamage = true;
                cap.addExp(this.caster, 20, Abilities.gravity);
            }
        } else {
            canDamage = true;
        }
        if (canDamage) {
            e.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.caster), this.damage * this.damageMod);
            IStunCapability stun = CapabilityList.getCap((ICapabilityProvider)e, CapabilityList.STUN);
            if (stun != null && (e.func_70662_br() && this.alignment == AlignmentAoE.Type.OrdersWrath || !e.func_70662_br() && this.alignment == AlignmentAoE.Type.ChaosHammer)) {
                stun.setStunTicks(this.field_70146_Z.nextInt(60) + 40);
            }
            if (this.damageMod > 0.5f) {
                this.damageMod -= 0.1f;
            }
        }
    }
}

