/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.entity;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.registry.AoVEntities;

public class EntitySpellLightningBolt
extends Entity {
    public long boltVertex;
    private int lightningState;
    private int boltLivingTime;
    private LivingEntity caster;
    private float damage;
    private AbilityBase source;

    public EntitySpellLightningBolt(World world) {
        super((EntityType)Objects.requireNonNull(AoVEntities.entityspelllightningbolt.get()), world);
        this.boltVertex = this.field_70146_Z.nextLong();
        this.lightningState = 2;
        this.boltLivingTime = this.field_70146_Z.nextInt(3) + 1;
        this.damage = 3.0f;
    }

    public EntitySpellLightningBolt(World world, LivingEntity caster, float damage, AbilityBase source) {
        this(world);
        this.caster = caster;
        this.damage = damage;
        this.source = source;
    }

    protected void func_70088_a() {
    }

    @Nonnull
    public SoundCategory func_184176_by() {
        return SoundCategory.WEATHER;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.lightningState == 2) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187754_de, SoundCategory.WEATHER, 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187752_dd, SoundCategory.WEATHER, 2.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.2f);
        }
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.func_70106_y();
            } else if (this.lightningState < -this.field_70146_Z.nextInt(10)) {
                --this.boltLivingTime;
                this.lightningState = 1;
                if (!this.field_70170_p.field_72995_K) {
                    this.boltVertex = this.field_70146_Z.nextLong();
                    BlockPos blockpos = new BlockPos((Entity)this);
                    if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223598_a) && this.field_70170_p.isAreaLoaded(blockpos, 10) && this.field_70170_p.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a && Blocks.field_150480_ab.func_176223_P().func_196955_c((IWorldReader)this.field_70170_p, blockpos)) {
                        this.field_70170_p.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                    }
                }
            }
        }
        if (this.lightningState >= 0) {
            List list = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(this.field_70165_t - 3.0, this.field_70163_u - 3.0, this.field_70161_v - 3.0, this.field_70165_t + 3.0, this.field_70163_u + 6.0 + 3.0, this.field_70161_v + 3.0));
            IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)this.caster, CapabilityList.AOV);
            for (Entity entity : list) {
                if (entity instanceof LivingEntity && !IAoVCapability.selectiveTarget((Entity)this.caster, cap, (LivingEntity)entity) || !entity.func_70097_a(DamageSource.field_180137_b, this.damage) || cap == null) continue;
                cap.addExp((Entity)this.caster, 20, this.source == null ? Abilities.litStrike : this.source);
            }
        }
    }

    protected void func_70037_a(@Nonnull CompoundNBT compound) {
    }

    protected void func_213281_b(@Nonnull CompoundNBT compound) {
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

